/*
 * Created on 2005/04/29
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.audiotools.spectrogram.views;

import org.eclipse.swt.graphics.GC;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.rcp.ui.GraphMemoryLabelProvider;
import org.jpn.xucker.rcp.ui.SimpleGraphMemoryPainter;

/**
 * 
 *
 */
public class KHZMemoryPainter extends SimpleGraphMemoryPainter implements GraphMemoryLabelProvider{
public static Log log=LogFactory.getLog(KHZMemoryPainter.class);
private int height=512;
private int samplerate=48000;
private int labellength;
private int perLabel;

public KHZMemoryPainter(){
    super();
    setSplitSubSub(3);
    initGraph();
}
public int getHeight() {
    return height;
}
public void setHeight(int height) {
    this.height = height;
    initGraph();
}
public int getSamplerate() {
    return samplerate;
}
public void setSamplerate(int samplerate) {
    this.samplerate = samplerate;
    initGraph();
}


public String[] createLabel(double arg0) {
    //TODO zoom not support.
    List labels=new ArrayList();
    for(int i=0;i<=labellength;i++){
        if(i!=0){
            
            labels.add(i*perLabel+" khz");
            
        }else{
            labels.add("");
        }
        
    }
    return (String[])labels.toArray(new String[labels.size()]);
}

public void initGraph(){
    labellength = samplerate/2/1000;
    perLabel = 1;
    double perStep;
    if(labellength>24/2){
        perLabel=2;
        perStep=height/(samplerate/2/2000);
        labellength/=2;
    }else{
        perStep=height*2*1000/samplerate;
    }
    
    
    
    
    log.trace("labellength="+labellength+",perlabel="+perLabel+",perstep="+perStep);
    setPerMain(perStep);
    setMainLabel(createLabel(0));
    
}



}
