package org.jpn.xucker.rcp.audiotools;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.jpn.xucker.rcp.audiotools.formats.AC3Format;
import org.jpn.xucker.rcp.audiotools.formats.MP2Format;
import org.jpn.xucker.rcp.audiotools.formats.MP3Format;
import org.jpn.xucker.rcp.audiotools.formats.SWFFormat;
import org.jpn.xucker.rcp.audiotools.formats.ThreeGPFormat;
import org.jpn.xucker.rcp.audiotools.formats.WavFormat;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class AudioToolsPlugin extends AbstractUIPlugin {
	//The shared instance.
	private static AudioToolsPlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;
	
	private AudioFormat[] audioFormats;
    public AudioFormat[] getAudioFormats() {
        return audioFormats;
    }
    public void setAudioFormats(AudioFormat[] audioFormats) {
        this.audioFormats = audioFormats;
    }
	/**
	 * The constructor.
	 */
	public AudioToolsPlugin() {
		super();
		plugin = this;
		try {
			resourceBundle = ResourceBundle.getBundle("org.jpn.xucker.rcp.audiotools.AudiotoolsPluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		
		//getPluginPreferences().setValue("ffmpegPath","C:\\Documents and Settings\\akito\\fXNgbv\\ffmpeggui03c\\ffmpeg.exe");
		getPluginPreferences().setValue("ffmpegPath","C:\\Program files\\3GP_Converter031\\cores\\ffmpeg.exe");
	
		//TODO change extention;
		List arrayList=new ArrayList();
		arrayList.add(new AC3Format());
		arrayList.add(new MP2Format());
		arrayList.add(new MP3Format());
		arrayList.add(new SWFFormat());
		arrayList.add(new ThreeGPFormat());
		arrayList.add(new WavFormat());
		audioFormats=(AudioFormat[]) arrayList.toArray(new AudioFormat[arrayList.size()]);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
	}

	/**
	 * Returns the shared instance.
	 */
	public static AudioToolsPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = AudioToolsPlugin.getDefault().getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
	
	AudioConverter[] audioConverters;
    public AudioConverter[] getAudioConverters() {
        return audioConverters;
    }
	public void init(){
	    try {
            audioConverters=searchAudioConverter();
            System.out.println("converter-length:"+audioConverters.length);
        } catch (CoreException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
	}
	private AudioConverter[] searchAudioConverter() throws CoreException {
	    ArrayList dictionaries = new ArrayList();
	     
	    IExtensionRegistry registry = Platform.getExtensionRegistry();
	    IExtensionPoint point =
	        registry.getExtensionPoint(
	            "org.jpn.xucker.rcp.audiotools.audiotool");
	    IExtension[] extensions = point.getExtensions();
	    
	    for (int i = 0; i < extensions.length; i++) {
	        IConfigurationElement[] elements =
	            extensions[i].getConfigurationElements();
	        for (int j = 0; j < elements.length; j++) {
	            if ("audioconverter".equals(elements[j].getName())) {
	                AudioConverter dictionary =
	                    (AudioConverter) elements[j]
	                            .createExecutableExtension("class");
	                dictionaries.add(dictionary);
	            }
	        }
	    }
	    AudioConverter[] result = new AudioConverter[dictionaries.size()];
	    dictionaries.toArray(result);
	    return result;
	}
}
