/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.framelist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.IFrameSource;

public class FrameList {
    public static final String P_CURRENT_FRAME = "currentFrame";
    private IFrameSource source;
    private List frames;
    private int current;
    private ListenerList propertyListeners = new ListenerList();

    public FrameList(IFrameSource source) {
        this.source = source;
        Frame frame = source.getFrame(1, 0);
        frame.setParent(this);
        frame.setIndex(0);
        this.frames = new ArrayList();
        this.frames.add(frame);
        this.current = 0;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyListeners.add((Object)listener);
    }

    public void back() {
        if (this.current > 0) {
            this.setCurrent(this.current - 1);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        Object[] listeners = this.propertyListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(event);
            ++i;
        }
    }

    public void forward() {
        if (this.current < this.frames.size() - 1) {
            this.setCurrent(this.current + 1);
        }
    }

    public Frame getCurrentFrame() {
        return this.getFrame(this.current);
    }

    public int getCurrentIndex() {
        return this.current;
    }

    public Frame getFrame(int index) {
        if (index < 0 || index >= this.frames.size()) {
            return null;
        }
        return (Frame)this.frames.get(index);
    }

    public IFrameSource getSource() {
        return this.source;
    }

    public void gotoFrame(Frame frame) {
        int i = this.frames.size();
        while (--i > this.current) {
            this.frames.remove(i);
        }
        frame.setParent(this);
        int index = this.frames.size();
        frame.setIndex(index);
        this.frames.add(frame);
        this.setCurrent(index);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyListeners.remove((Object)listener);
    }

    void setCurrent(int newCurrent) {
        Assert.isTrue((newCurrent >= 0 && newCurrent < this.frames.size() ? 1 : 0) != 0);
        int oldCurrent = this.current;
        if (oldCurrent != newCurrent) {
            this.updateCurrentFrame();
            this.current = newCurrent;
            this.firePropertyChange(new PropertyChangeEvent((Object)this, P_CURRENT_FRAME, (Object)this.getFrame(oldCurrent), (Object)this.getFrame(newCurrent)));
        }
    }

    public void setCurrentIndex(int index) {
        if (index != -1 && index != this.current) {
            this.setCurrent(index);
        }
    }

    public int size() {
        return this.frames.size();
    }

    public void updateCurrentFrame() {
        Assert.isTrue((this.current >= 0 ? 1 : 0) != 0);
        Frame frame = this.source.getFrame(1, 1);
        frame.setParent(this);
        frame.setIndex(this.current);
        this.frames.set(this.current, frame);
    }
}

