/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.util.TString;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.Topic;

public class BookmarksData
extends RequestData {
    public static final int NONE = 0;
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int REMOVE_ALL = 3;

    public BookmarksData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        switch (this.getOperation()) {
            case 1: {
                this.addBookmark();
                break;
            }
            case 2: {
                this.removeBookmark();
                break;
            }
            case 3: {
                this.removeAllBookmarks();
                break;
            }
        }
    }

    public void addBookmark() {
        String bookmarkURL = this.request.getParameter("bookmark");
        if (bookmarkURL != null && bookmarkURL.length() > 0 && !bookmarkURL.equals("about:blank")) {
            String title = this.request.getParameter("title");
            if (title == null) {
                return;
            }
            Preferences prefs = HelpBasePlugin.getDefault().getPluginPreferences();
            String bookmarks = prefs.getString("bookmarks");
            if (bookmarks.indexOf("," + BookmarksData.encode(bookmarkURL) + "|") != -1) {
                return;
            }
            bookmarks = String.valueOf(bookmarks) + "," + BookmarksData.encode(bookmarkURL) + "|" + BookmarksData.encode(title);
            prefs.setValue("bookmarks", bookmarks);
            HelpBasePlugin.getDefault().savePluginPreferences();
        }
    }

    public void removeBookmark() {
        String bookmarkURL = this.request.getParameter("bookmark");
        if (bookmarkURL != null && bookmarkURL.length() > 0 && !bookmarkURL.equals("about:blank")) {
            String removeString;
            String title = this.request.getParameter("title");
            if (title == null) {
                return;
            }
            Preferences prefs = HelpBasePlugin.getDefault().getPluginPreferences();
            String bookmarks = prefs.getString("bookmarks");
            int i = bookmarks.indexOf(removeString = "," + BookmarksData.encode(bookmarkURL) + "|" + BookmarksData.encode(title));
            if (i == -1) {
                return;
            }
            bookmarks = String.valueOf(bookmarks.substring(0, i)) + bookmarks.substring(i + removeString.length());
            prefs.setValue("bookmarks", bookmarks);
            HelpBasePlugin.getDefault().savePluginPreferences();
        }
    }

    public void removeAllBookmarks() {
        Preferences prefs = HelpBasePlugin.getDefault().getPluginPreferences();
        prefs.setValue("bookmarks", "");
        HelpBasePlugin.getDefault().savePluginPreferences();
    }

    public Topic[] getBookmarks() {
        if (BaseHelpSystem.getMode() != 1) {
            Preferences prefs = HelpBasePlugin.getDefault().getPluginPreferences();
            String bookmarks = prefs.getString("bookmarks");
            StringTokenizer tokenizer = new StringTokenizer(bookmarks, ",");
            Topic[] topics = new Topic[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String bookmark = tokenizer.nextToken();
                int separator = bookmark.indexOf(124);
                String label = BookmarksData.decode(bookmark.substring(separator + 1));
                String href = separator < 0 ? "" : BookmarksData.decode(bookmark.substring(0, separator));
                topics[i] = new Topic(label, href);
                ++i;
            }
            return topics;
        }
        return new Topic[0];
    }

    private int getOperation() {
        String op = this.request.getParameter("operation");
        if ("add".equals(op)) {
            return 1;
        }
        if ("remove".equals(op)) {
            return 2;
        }
        if ("removeAll".equals(op)) {
            return 3;
        }
        return 0;
    }

    private static String encode(String s) {
        s = TString.change((String)s, (String)"\\", (String)"\\escape");
        s = TString.change((String)s, (String)",", (String)"\\comma");
        return TString.change((String)s, (String)"|", (String)"\\pipe");
    }

    private static String decode(String s) {
        s = TString.change((String)s, (String)"\\pipe", (String)"|");
        s = TString.change((String)s, (String)"\\comma", (String)",");
        return TString.change((String)s, (String)"\\escape", (String)"\\");
    }
}

