/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.swt.ui;

import java.io.File;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jpn.xucker.commons.swt.ui.FileStatusChangeListener;
import org.jpn.xucker.commons.swt.ui.FileStatusChanger;
import org.jpn.xucker.commons.util.WildCard;

public class FileDirChoicer
extends Canvas
implements SelectionListener {
    public static final int FILE = 0;
    public static final int DIR = 1;
    Layout rowLayout;
    RowData labelLayoutData;
    RowData textLayoutData;
    RowData buttonLayoutData;
    private Button button;
    private Label label;
    private Text text;
    private int type;
    private String[] filterExtensions;
    private String[] filterNames;
    FileStatusChanger fileListChanger = new FileStatusChanger(){

        protected void addFilePath(String path) {
            FileDirChoicer.this.addFile(path);
        }

        protected void addDirectoryPath(String path) {
            FileDirChoicer.this.addDirectory(path);
        }
    };
    private Button resetButton;
    private RowData resetButtonLayoutData;

    public void setPathWidth(int width) {
        this.textLayoutData.width = width;
    }

    public void setEnabled(boolean bool) {
        super.setEnabled(bool);
        this.label.setEnabled(bool);
        this.text.setEnabled(bool);
        this.button.setEnabled(bool);
        if (this.resetButton != null) {
            this.resetButton.setEnabled(bool);
        }
    }

    public void removeFileListChangeListener(FileStatusChangeListener listener) {
        this.fileListChanger.removeFileListChangeListener(listener);
    }

    public void addFileListChangeListener(FileStatusChangeListener listener) {
        this.fileListChanger.addFileListChangeListener(listener);
    }

    public FileDirChoicer(Composite arg0, int arg1, int type, String labelText) {
        this(arg0, arg1, type, labelText, false);
    }

    public void addFile(String path) {
        if (this.type == 0 && this.isAllowFile(path)) {
            this.inSetText(path);
        }
    }

    public void addDirectory(String path) {
        if (this.type == 1) {
            this.inSetText(path);
        }
    }

    public FileDirChoicer(Composite arg0, int arg1, int type, String labelText, boolean haveReset) {
        super(arg0, arg1);
        this.type = type;
        this.rowLayout = new RowLayout();
        this.setLayout(this.rowLayout);
        this.label = new Label((Composite)this, 0);
        if (labelText != null) {
            this.label.setText(labelText);
            this.labelLayoutData = new RowData();
            this.labelLayoutData.width = 100;
            this.label.setLayoutData((Object)this.labelLayoutData);
        }
        this.text = new Text((Composite)this, 8);
        this.textLayoutData = new RowData();
        this.textLayoutData.width = 200;
        this.text.setLayoutData((Object)this.textLayoutData);
        this.text.setBackground(new Color((Device)this.getShell().getDisplay(), 255, 255, 255));
        this.button = new Button((Composite)this, 0);
        this.button.setText("\u53c2\u7167");
        this.buttonLayoutData = new RowData();
        this.buttonLayoutData.width = 50;
        this.button.setLayoutData((Object)this.buttonLayoutData);
        this.button.addSelectionListener((SelectionListener)this);
        if (haveReset) {
            this.resetButton = new Button((Composite)this, 0);
            this.resetButton.setText("\u30ea\u30bb\u30c3\u30c8");
            this.resetButtonLayoutData = new RowData();
            this.resetButtonLayoutData.width = 50;
            this.resetButton.setLayoutData((Object)this.buttonLayoutData);
            this.resetButton.addSelectionListener((SelectionListener)this);
        }
        Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
        int operations = 3;
        DropTarget target2 = new DropTarget((Control)this.text, operations);
        target2.setTransfer(types);
        target2.addDropListener(this.fileListChanger.getMonitor());
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.getSource() == this.button) {
            if (this.type == 0) {
                this.openFileDialog();
            } else {
                this.openDirectoryDialog();
            }
        } else if (event.getSource() == this.resetButton) {
            String pre = this.text.getText();
            this.text.setText("");
            this.fileListChanger.fireRemoveFile(pre);
        }
    }

    private void openDirectoryDialog() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        String result = dialog.open();
        if (result != null) {
            this.inSetText(result);
        }
    }

    public void inSetText(String path) {
        this.text.setText(path);
        this.fileListChanger.fireAddFile(path);
    }

    private void openFileDialog() {
        String result;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        if (this.filterExtensions != null) {
            dialog.setFilterExtensions(this.filterExtensions);
        }
        if (this.filterNames != null) {
            dialog.setFilterNames(this.filterNames);
        }
        if ((result = dialog.open()) != null) {
            this.inSetText(result);
        }
    }

    private void setFilePathLabel(String path) {
        if (path != null) {
            this.text.setText(path);
            this.fileListChanger.fireAddFile(path);
        }
    }

    public void removePath() {
        String path = this.text.getText();
        if (!path.equals("")) {
            this.fileListChanger.fireAddFile(path);
            this.text.setText("");
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void setFile(File file) {
        if (file != null) {
            this.text.setText(file.getAbsolutePath());
        } else {
            this.text.setText("");
        }
    }

    public File getFile() {
        File file = null;
        if (!this.text.getText().equals("")) {
            file = new File(this.text.getText());
        }
        return file;
    }

    public String getAbsoluteFilePath() {
        if (this.getFile() == null) {
            return "";
        }
        return this.getFile().getAbsolutePath();
    }

    public void setFilePath(String path) {
        if (path == null || path.equals("")) {
            this.setFile(null);
        } else {
            this.setFile(new File(path));
        }
    }

    private boolean isAllowFile(String path) {
        if (this.filterExtensions == null) {
            return true;
        }
        if (this.filterExtensions != null) {
            File f = new File(path);
            int i = 0;
            while (i < this.filterExtensions.length) {
                WildCard wildCard = new WildCard(this.filterExtensions[i]);
                if (wildCard.match(path)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public void setFilterExtensions(String[] alowExtensions) {
        this.filterExtensions = alowExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = filterNames;
    }
}

