/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.mediainfo;

import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jpn.xucker.rcp.mediainfo.MediaInfoParser;
import org.osgi.framework.BundleContext;

public class MediaInfoRcpPlugin
extends AbstractUIPlugin {
    private static MediaInfoRcpPlugin plugin;
    private ResourceBundle resourceBundle;
    private MediaInfoParser parser;

    public MediaInfoRcpPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.jpn.xucker.rcp.mediainfo.MediaInfoRcpPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IPreferenceStore store = MediaInfoRcpPlugin.getDefault().getPreferenceStore();
        File defaultFile = new File(MediaInfoRcpPlugin.getDefault().toPluginDir(MediaInfoRcpPlugin.getDefault()), "MediaInfo_Cmd_Win32/MediaInfo.exe");
        if (defaultFile.exists()) {
            store.setDefault("mediainfo_path", defaultFile.getAbsolutePath());
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static MediaInfoRcpPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = MediaInfoRcpPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public MediaInfoParser getParser() {
        if (this.parser == null) {
            this.parser = new MediaInfoParser(this.getPreferenceStore().getString("mediainfo_path"));
        }
        return this.parser;
    }

    File toPluginDir(AbstractUIPlugin plugin) {
        return new File(Platform.getInstallLocation().getURL().getPath(), "plugins/" + plugin.getBundle().getSymbolicName() + "_" + plugin.getBundle().getHeaders().get("Bundle-Version"));
    }
}

