/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.audiotools.oggtools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import oggrcp.OggrcpPlugin;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.jpn.xucker.rcp.audio.AudioConverter;
import org.jpn.xucker.rcp.audio.AudioSetting;
import org.jpn.xucker.rcp.audio.AudioUtils;

public class OggTools
implements AudioConverter {
    public static Log log;
    public static IConsoleManager consoleManager;
    private MessageConsoleStream consoleStream;
    private MessageConsoleStream errorStream;
    private MessageConsoleStream progressStream;
    private MessageConsole console;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.audiotools.oggtools.OggTools");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public boolean canConvert(String input, String output) {
        if (input.equals("wav") && output.equals("ogg")) {
            return true;
        }
        return input.equals("ogg") && output.equals("wav");
    }

    private String getEncoderPath() {
        return OggrcpPlugin.getDefault().getOGGEncFile().getAbsolutePath();
    }

    private String getDecoderPath() {
        return OggrcpPlugin.getDefault().getOGGDecFile().getAbsolutePath();
    }

    public String[] toDecodeArgs(File input, File output, AudioSetting setting, AudioSetting inputSetting) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(this.getDecoderPath());
        AudioUtils.getExtension((String)input.getName());
        String outputExtension = AudioUtils.getExtension((String)output.getName());
        if (!outputExtension.equals("wav")) {
            throw new RuntimeException("current support wav only");
        }
        if (setting != null) {
            if (setting.getSamplebit() == 16) {
                argList.add("-b");
                argList.add("16");
            } else if (setting.getSamplebit() == 8) {
                argList.add("-b");
                argList.add("8");
                argList.add("-s");
                argList.add("0");
            }
        }
        argList.add(input.getAbsolutePath());
        argList.add("-o");
        argList.add(output.getAbsolutePath());
        return argList.toArray(new String[argList.size()]);
    }

    public String[] toEncodeArgs(File input, File output, AudioSetting setting, AudioSetting inputSetting) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(this.getEncoderPath());
        String inputExtension = AudioUtils.getExtension((String)input.getName());
        AudioUtils.getExtension((String)output.getName());
        if (!inputExtension.equals("wav")) {
            throw new RuntimeException("current support wav only");
        }
        if (setting != null) {
            if (inputSetting.getSamplerate() != setting.getSamplerate()) {
                argList.add("--resample");
                argList.add("" + setting.getSamplerate());
            }
            if (setting.getBitrate() > 0) {
                argList.add("-M");
                argList.add("" + setting.getBitrate() / 1000);
            }
        }
        argList.add(input.getAbsolutePath());
        argList.add("-o");
        argList.add(output.getAbsolutePath());
        return argList.toArray(new String[argList.size()]);
    }

    public void convert(File input, File output, AudioSetting setting, AudioSetting inputSetting) throws IOException {
        String line;
        String errorLine;
        if (consoleManager == null) {
            consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            this.console = new MessageConsole(this.getName(), null);
            consoleManager.addConsoles(new IConsole[]{this.console});
            this.consoleStream = this.console.newMessageStream();
            this.errorStream = this.console.newMessageStream();
            this.progressStream = this.console.newMessageStream();
            Color defaultColor = new Color(null, 0, 0, 0);
            Color errorColor = new Color(null, 255, 0, 0);
            this.errorStream.setColor(errorColor);
            this.consoleStream.setColor(defaultColor);
            this.progressStream.setColor(new Color(null, 0, 0, 255));
        } else {
            consoleManager.showConsoleView((IConsole)this.console);
        }
        Runtime runtime = Runtime.getRuntime();
        String[] args = null;
        args = AudioUtils.getExtension((File)input).equals("wav") ? this.toEncodeArgs(input, output, setting, inputSetting) : this.toDecodeArgs(input, output, setting, inputSetting);
        String command = "";
        int i = 0;
        while (i < args.length) {
            command = String.valueOf(command) + this.toArg(args[i]) + " ";
            ++i;
        }
        this.consoleStream.println(command);
        File pathFile = new File(this.getEncoderPath());
        Process process = runtime.exec(args, null, pathFile.getParentFile());
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        while ((errorLine = errorReader.readLine()) != null) {
            if (this.isError(errorLine)) {
                this.errorStream.println(errorLine);
                continue;
            }
            if (this.isProgress(errorLine)) {
                this.progressStream.println(errorLine);
                continue;
            }
            this.consoleStream.println(errorLine);
        }
        errorReader.close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            if (this.isError(line)) {
                this.errorStream.println(line);
                continue;
            }
            if (this.isProgress(line)) {
                this.progressStream.println(line);
                continue;
            }
            this.consoleStream.println(line);
        }
        reader.close();
    }

    public boolean isProgress(String line) {
        return line.indexOf("remaining]") != -1 || line.indexOf("%]") != -1 || line.indexOf("Done encoding file") != -1;
    }

    public boolean isError(String line) {
        return line.indexOf("Mode initialisation failed: invalid parameters for bitrate") != -1;
    }

    private String toArg(String text) {
        if (text.indexOf(" ") != -1) {
            return "\"" + text + "\"";
        }
        return text;
    }

    public String getName() {
        return "OggTools";
    }
}

