/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.internal.editors.text.ColorEditor;
import org.eclipse.ui.internal.editors.text.IPreferenceConfigurationBlock;
import org.eclipse.ui.internal.editors.text.OverlayPreferenceStore;
import org.eclipse.ui.internal.editors.text.PixelConverter;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

class AnnotationsConfigurationBlock
implements IPreferenceConfigurationBlock {
    private OverlayPreferenceStore fStore;
    private ColorEditor fAnnotationForegroundColorEditor;
    private Button fShowInTextCheckBox;
    private Combo fDecorationStyleCombo;
    private Button fHighlightInTextCheckBox;
    private Button fShowInOverviewRulerCheckBox;
    private Button fShowInVerticalRulerCheckBox;
    private List fAnnotationList;
    private final String[][] fAnnotationColorListModel;
    private ArrayList fMasterSlaveListeners = new ArrayList();
    private final String[][] fAnnotationDecorationListModel = new String[][]{{TextEditorMessages.getString("AnnotationConfigurationBlock.NONE"), "NONE"}, {TextEditorMessages.getString("AnnotationConfigurationBlock.SQUIGGLES"), "SQUIGGLES"}, {TextEditorMessages.getString("AnnotationConfigurationBlock.UNDERLINE"), "UNDERLINE"}, {TextEditorMessages.getString("AnnotationConfigurationBlock.BOX"), "BOX"}, {TextEditorMessages.getString("AnnotationConfigurationBlock.IBEAM"), "IBEAM"}};

    public AnnotationsConfigurationBlock(OverlayPreferenceStore store) {
        Assert.isNotNull((Object)store);
        MarkerAnnotationPreferences markerAnnotationPreferences = new MarkerAnnotationPreferences();
        this.fStore = store;
        this.fStore.addKeys(this.createOverlayStoreKeys(markerAnnotationPreferences));
        this.fAnnotationColorListModel = this.createAnnotationTypeListModel(markerAnnotationPreferences);
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys(MarkerAnnotationPreferences preferences) {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, info.getColorPreferenceKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getTextPreferenceKey()));
            if (info.getHighlightPreferenceKey() != null) {
                overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getHighlightPreferenceKey()));
            }
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getOverviewRulerPreferenceKey()));
            if (info.getVerticalRulerPreferenceKey() != null) {
                overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getVerticalRulerPreferenceKey()));
            }
            if (info.getTextStylePreferenceKey() == null) continue;
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, info.getTextStylePreferenceKey()));
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public Control createControl(Composite parent) {
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 16384);
        label.setText(TextEditorMessages.getString("AnnotationConfigurationBlock.annotationPresentationOptions"));
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAnnotationList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(20);
        this.fAnnotationList.setLayoutData((Object)gd);
        Composite optionsComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        optionsComposite.setLayout((Layout)layout);
        optionsComposite.setLayoutData((Object)new GridData(1808));
        this.fShowInTextCheckBox = new Button(optionsComposite, 32);
        this.fShowInTextCheckBox.setText(TextEditorMessages.getString("AnnotationConfigurationBlock.showInText"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fShowInTextCheckBox.setLayoutData((Object)gd);
        this.fDecorationStyleCombo = new Combo(optionsComposite, 8);
        int i = 0;
        while (i < this.fAnnotationDecorationListModel.length) {
            this.fDecorationStyleCombo.add(this.fAnnotationDecorationListModel[i][0]);
            ++i;
        }
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 20;
        this.fDecorationStyleCombo.setLayoutData((Object)gd);
        this.fHighlightInTextCheckBox = new Button(optionsComposite, 32);
        this.fHighlightInTextCheckBox.setText(TextEditorMessages.getString("AnnotationConfigurationBlock.highlightInText"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fHighlightInTextCheckBox.setLayoutData((Object)gd);
        this.fShowInOverviewRulerCheckBox = new Button(optionsComposite, 32);
        this.fShowInOverviewRulerCheckBox.setText(TextEditorMessages.getString("AnnotationConfigurationBlock.showInOverviewRuler"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fShowInOverviewRulerCheckBox.setLayoutData((Object)gd);
        this.fShowInVerticalRulerCheckBox = new Button(optionsComposite, 32);
        this.fShowInVerticalRulerCheckBox.setText(TextEditorMessages.getString("AnnotationConfigurationBlock.showInVerticalRuler"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fShowInVerticalRulerCheckBox.setLayoutData((Object)gd);
        label = new Label(optionsComposite, 16384);
        label.setText(TextEditorMessages.getString("AnnotationConfigurationBlock.color"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fAnnotationForegroundColorEditor = new ColorEditor(optionsComposite);
        Button foregroundColorButton = this.fAnnotationForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fAnnotationList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AnnotationsConfigurationBlock.this.handleAnnotationListSelection();
            }
        });
        this.fShowInTextCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AnnotationsConfigurationBlock.this.fAnnotationList.getSelectionIndex();
                String key = AnnotationsConfigurationBlock.this.fAnnotationColorListModel[i][2];
                AnnotationsConfigurationBlock.this.fStore.setValue(key, AnnotationsConfigurationBlock.this.fShowInTextCheckBox.getSelection());
                String decorationKey = AnnotationsConfigurationBlock.this.fAnnotationColorListModel[i][6];
                AnnotationsConfigurationBlock.this.fDecorationStyleCombo.setEnabled(decorationKey != null && AnnotationsConfigurationBlock.this.fShowInTextCheckBox.getSelection());
            }
        });
        this.fHighlightInTextCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AnnotationsConfigurationBlock.this.fAnnotationList.getSelectionIndex();
                String key = AnnotationsConfigurationBlock.this.fAnnotationColorListModel[i][4];
                AnnotationsConfigurationBlock.this.fStore.setValue(key, AnnotationsConfigurationBlock.this.fHighlightInTextCheckBox.getSelection());
            }
        });
        this.fShowInOverviewRulerCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AnnotationsConfigurationBlock.this.fAnnotationList.getSelectionIndex();
                String key = AnnotationsConfigurationBlock.this.fAnnotationColorListModel[i][3];
                AnnotationsConfigurationBlock.this.fStore.setValue(key, AnnotationsConfigurationBlock.this.fShowInOverviewRulerCheckBox.getSelection());
            }
        });
        this.fShowInVerticalRulerCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AnnotationsConfigurationBlock.this.fAnnotationList.getSelectionIndex();
                String key = AnnotationsConfigurationBlock.this.fAnnotationColorListModel[i][5];
                AnnotationsConfigurationBlock.this.fStore.setValue(key, AnnotationsConfigurationBlock.this.fShowInVerticalRulerCheckBox.getSelection());
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AnnotationsConfigurationBlock.this.fAnnotationList.getSelectionIndex();
                String key = AnnotationsConfigurationBlock.this.fAnnotationColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)AnnotationsConfigurationBlock.this.fStore, (String)key, (RGB)AnnotationsConfigurationBlock.this.fAnnotationForegroundColorEditor.getColorValue());
            }
        });
        this.fDecorationStyleCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AnnotationsConfigurationBlock.this.fAnnotationList.getSelectionIndex();
                String key = AnnotationsConfigurationBlock.this.fAnnotationColorListModel[i][6];
                if (key != null) {
                    int j = 0;
                    while (j < AnnotationsConfigurationBlock.this.fAnnotationDecorationListModel.length) {
                        if (AnnotationsConfigurationBlock.this.fAnnotationDecorationListModel[j][0].equals(AnnotationsConfigurationBlock.this.fDecorationStyleCombo.getText())) {
                            AnnotationsConfigurationBlock.this.fStore.setValue(key, AnnotationsConfigurationBlock.this.fAnnotationDecorationListModel[j][1]);
                            break;
                        }
                        ++j;
                    }
                }
            }
        });
        return composite;
    }

    public void performOk() {
    }

    public void performDefaults() {
        this.fStore.loadDefaults();
        this.handleAnnotationListSelection();
    }

    private void handleAnnotationListSelection() {
        int i = this.fAnnotationList.getSelectionIndex();
        String key = this.fAnnotationColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fStore, (String)key);
        this.fAnnotationForegroundColorEditor.setColorValue(rgb);
        key = this.fAnnotationColorListModel[i][2];
        boolean showInText = this.fStore.getBoolean(key);
        this.fShowInTextCheckBox.setSelection(showInText);
        key = this.fAnnotationColorListModel[i][6];
        if (key != null) {
            this.fDecorationStyleCombo.setEnabled(showInText);
            int j = 0;
            while (j < this.fAnnotationDecorationListModel.length) {
                String value = this.fStore.getString(key);
                if (this.fAnnotationDecorationListModel[j][1].equals(value)) {
                    this.fDecorationStyleCombo.setText(this.fAnnotationDecorationListModel[j][0]);
                    break;
                }
                ++j;
            }
        } else {
            this.fDecorationStyleCombo.setEnabled(false);
            this.fDecorationStyleCombo.setText(this.fAnnotationDecorationListModel[1][0]);
        }
        key = this.fAnnotationColorListModel[i][3];
        this.fShowInOverviewRulerCheckBox.setSelection(this.fStore.getBoolean(key));
        key = this.fAnnotationColorListModel[i][4];
        if (key != null) {
            this.fHighlightInTextCheckBox.setSelection(this.fStore.getBoolean(key));
            this.fHighlightInTextCheckBox.setEnabled(true);
        } else {
            this.fHighlightInTextCheckBox.setSelection(false);
            this.fHighlightInTextCheckBox.setEnabled(false);
        }
        key = this.fAnnotationColorListModel[i][5];
        if (key != null) {
            this.fShowInVerticalRulerCheckBox.setSelection(this.fStore.getBoolean(key));
            this.fShowInVerticalRulerCheckBox.setEnabled(true);
        } else {
            this.fShowInVerticalRulerCheckBox.setSelection(true);
            this.fShowInVerticalRulerCheckBox.setEnabled(false);
        }
    }

    public void initialize() {
        int i = 0;
        while (i < this.fAnnotationColorListModel.length) {
            this.fAnnotationList.add(this.fAnnotationColorListModel[i][0]);
            ++i;
        }
        this.fAnnotationList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (AnnotationsConfigurationBlock.this.fAnnotationList != null && !AnnotationsConfigurationBlock.this.fAnnotationList.isDisposed()) {
                    AnnotationsConfigurationBlock.this.fAnnotationList.select(0);
                    AnnotationsConfigurationBlock.this.handleAnnotationListSelection();
                }
            }
        });
    }

    private String[][] createAnnotationTypeListModel(MarkerAnnotationPreferences preferences) {
        ArrayList<String[]> listModelItems = new ArrayList<String[]>();
        TreeSet sortedPreferences = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                if (!(o2 instanceof AnnotationPreference)) {
                    return -1;
                }
                if (!(o1 instanceof AnnotationPreference)) {
                    return 1;
                }
                AnnotationPreference a1 = (AnnotationPreference)o1;
                AnnotationPreference a2 = (AnnotationPreference)o2;
                return Collator.getInstance().compare(a1.getPreferenceLabel(), a2.getPreferenceLabel());
            }
        });
        sortedPreferences.addAll(preferences.getAnnotationPreferences());
        Iterator e = sortedPreferences.iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            if (!info.isIncludeOnPreferencePage()) continue;
            listModelItems.add(new String[]{info.getPreferenceLabel(), info.getColorPreferenceKey(), info.getTextPreferenceKey(), info.getOverviewRulerPreferenceKey(), info.getHighlightPreferenceKey(), info.getVerticalRulerPreferenceKey(), info.getTextStylePreferenceKey()});
        }
        String[][] items = new String[listModelItems.size()][];
        listModelItems.toArray((T[])items);
        return items;
    }

    private static void indent(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = 20;
        control.setLayoutData((Object)gridData);
    }

    private void createDependency(final Button master, String masterKey, final Control slave) {
        AnnotationsConfigurationBlock.indent(slave);
        boolean masterState = this.fStore.getBoolean(masterKey);
        slave.setEnabled(masterState);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                slave.setEnabled(master.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        master.addSelectionListener(listener);
        this.fMasterSlaveListeners.add(listener);
    }

    public void dispose() {
    }
}

