/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.Iterator;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.draw2d.internal.graph.CompoundBreakCycles;
import org.eclipse.draw2d.internal.graph.CompoundHorizontalPlacement;
import org.eclipse.draw2d.internal.graph.CompoundPopulateRanks;
import org.eclipse.draw2d.internal.graph.CompoundRankSorter;
import org.eclipse.draw2d.internal.graph.CompoundVerticalPlacement;
import org.eclipse.draw2d.internal.graph.ConvertCompoundGraph;
import org.eclipse.draw2d.internal.graph.GraphVisitor;
import org.eclipse.draw2d.internal.graph.InitialRankSolver;
import org.eclipse.draw2d.internal.graph.InvertEdges;
import org.eclipse.draw2d.internal.graph.LocalOptimizer;
import org.eclipse.draw2d.internal.graph.MinCross;
import org.eclipse.draw2d.internal.graph.PlaceEndpoints;
import org.eclipse.draw2d.internal.graph.RankAssigmentSolver;
import org.eclipse.draw2d.internal.graph.RestoreCompoundGraph;
import org.eclipse.draw2d.internal.graph.SortSubgraphs;
import org.eclipse.draw2d.internal.graph.TightSpanningTreeSolver;

public final class CompoundDirectedGraphLayout
extends GraphVisitor {
    public void visit(DirectedGraph g) {
        CompoundDirectedGraph graph = (CompoundDirectedGraph)g;
        new CompoundBreakCycles().visit(graph);
        new ConvertCompoundGraph().visit(graph);
        new InitialRankSolver().visit(graph);
        new TightSpanningTreeSolver().visit(graph);
        new RankAssigmentSolver().visit(graph);
        new CompoundPopulateRanks().visit(graph);
        new CompoundVerticalPlacement().visit(graph);
        Iterator containment = graph.containment.iterator();
        while (containment.hasNext()) {
            Edge e = (Edge)containment.next();
            if (e.getSlack() <= 0) continue;
            graph.removeEdge(e);
            containment.remove();
        }
        int i = 0;
        while (i < graph.ranks.size()) {
            Rank rank = graph.ranks.getRank(i);
            rank.assignIndices();
            ++i;
        }
        MinCross minCross = new MinCross();
        minCross.setRankSorter(new CompoundRankSorter());
        minCross.visit(graph);
        new LocalOptimizer().visit(graph);
        new SortSubgraphs().visit(graph);
        containment = graph.containment.iterator();
        while (containment.hasNext()) {
            graph.removeEdge((Edge)containment.next());
        }
        graph.containment.clear();
        new CompoundHorizontalPlacement().visit(graph);
        new PlaceEndpoints().visit(graph);
        new InvertEdges().visit(graph);
        new RestoreCompoundGraph().visit(graph);
    }
}

