/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.sound;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import jp.sourceforge.acerola3d.a3.Util;
import jp.sourceforge.acerola3d.sound.A3Sound;
import jp.sourceforge.acerola3d.sound.A3SoundSystem;
import jp.sourceforge.acerola3d.sound.A3SoundType;

public class ShortSound
implements A3Sound {
    String file;
    A3SoundSystem soundSystem;
    float segnoTime;
    A3SoundType type;
    float gain;
    boolean loop = false;
    Vector3f offset = new Vector3f();
    Vector3f loc = new Vector3f();
    Quat4d quat = new Quat4d(0.0, 0.0, 0.0, 1.0);
    Vector3f orgDir = new Vector3f(0.0f, 0.0f, 1.0f);
    Vector3f dir = new Vector3f(0.0f, 0.0f, 1.0f);
    int[] buffer = new int[1];
    int[] source = new int[1];
    boolean sourceInit = false;

    ShortSound() {
    }

    @Override
    public void init(String file, A3SoundSystem ss, float segno, A3SoundType t, float g, boolean l, Vector3d offset, Vector3d dir) throws Exception {
        this.file = file;
        this.soundSystem = ss;
        this.segnoTime = segno;
        this.type = t;
        this.gain = g;
        this.loop = l;
        this.offset.set(offset);
        this.orgDir.set(dir);
        this.dir.set(dir);
        this.initBuffer();
    }

    void initBuffer() throws Exception {
        if (this.soundSystem.al == null) {
            return;
        }
        int[] format = new int[1];
        ByteBuffer[] data = new ByteBuffer[1];
        int[] size = new int[1];
        int[] freq = new int[1];
        URL url = new URL(this.file);
        InputStream is = url.openStream();
        AudioInputStream ais = AudioSystem.getAudioInputStream(is);
        AudioFormat audioFormat = ais.getFormat();
        audioFormat = new AudioFormat(audioFormat.getSampleRate(), 16, audioFormat.getChannels(), true, false);
        ais = AudioSystem.getAudioInputStream(audioFormat, ais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int cnt = 0;
        while ((cnt = ais.read(b)) != -1) {
            baos.write(b, 0, cnt);
        }
        b = baos.toByteArray();
        data[0] = ByteBuffer.wrap(b);
        format[0] = audioFormat.getChannels() == 1 ? 4353 : 4355;
        size[0] = b.length;
        freq[0] = (int)audioFormat.getSampleRate();
        this.soundSystem.al.alGenBuffers(1, this.buffer, 0);
        this.check(1);
        this.soundSystem.al.alBufferData(this.buffer[0], format[0], (Buffer)data[0], size[0], freq[0]);
        this.check(2);
    }

    void initSource() {
        if (this.soundSystem.al == null) {
            return;
        }
        this.soundSystem.al.alGenSources(1, this.source, 0);
        this.check(3);
        this.sourceInit = true;
        this.soundSystem.al.alSourcei(this.source[0], 4105, this.buffer[0]);
        this.soundSystem.al.alSourcef(this.source[0], 4099, 1.0f);
        this.soundSystem.al.alSourcef(this.source[0], 4106, 1.0f);
        Vector3d v = Util.trans(this.quat, new Vector3d(this.offset));
        v.add(new Vector3d(this.loc));
        this.soundSystem.al.alSource3f(this.source[0], 4100, (float)v.x, (float)v.y, (float)v.z);
        this.soundSystem.al.alSourcef(this.source[0], 4106, this.gain);
        if (this.loop) {
            this.soundSystem.al.alSourcei(this.source[0], 4103, 1);
        } else {
            this.soundSystem.al.alSourcei(this.source[0], 4103, 0);
        }
        if (this.type == A3SoundType.BackgroundSound) {
            this.soundSystem.al.alSourcei(this.source[0], 514, 1);
            this.soundSystem.al.alSource3f(this.source[0], 4100, 0.0f, 0.0f, 0.0f);
            this.loc.set(0.0f, 0.0f, 0.0f);
        }
        if (this.type == A3SoundType.ConeSound) {
            this.soundSystem.al.alSourcef(this.source[0], 4097, 90.0f);
            this.soundSystem.al.alSourcef(this.source[0], 4098, 135.0f);
            this.soundSystem.al.alSourcef(this.source[0], 4130, 0.0f);
            this.soundSystem.al.alSource3f(this.source[0], 4101, this.dir.x, this.dir.y, this.dir.z);
        }
        this.check(4);
    }

    boolean alIsSource() {
        return this.sourceInit;
    }

    @Override
    public void start() {
        if (this.soundSystem.al == null) {
            return;
        }
        if (!this.alIsSource()) {
            this.initSource();
        }
        this.soundSystem.al.alSourcePlay(this.source[0]);
        this.check(5);
    }

    @Override
    public void segno() {
        if (this.soundSystem.al == null) {
            return;
        }
        if (!this.alIsSource()) {
            return;
        }
        this.soundSystem.al.alSourcef(this.source[0], 4132, this.segnoTime);
        this.soundSystem.al.alGetError();
        this.soundSystem.al.alSourcePlay(this.source[0]);
        this.check(7);
    }

    @Override
    public void stop() {
        if (this.soundSystem.al == null) {
            return;
        }
        if (!this.alIsSource()) {
            return;
        }
        this.soundSystem.al.alSourceStop(this.source[0]);
        this.soundSystem.al.alDeleteSources(1, this.source, 0);
        this.sourceInit = false;
    }

    @Override
    public void pause() {
        if (this.soundSystem.al == null) {
            return;
        }
        if (!this.alIsSource()) {
            return;
        }
        this.soundSystem.al.alSourcePause(this.source[0]);
    }

    @Override
    public void rewind() {
        if (this.soundSystem.al == null) {
            return;
        }
        if (!this.alIsSource()) {
            return;
        }
        this.soundSystem.al.alSourceRewind(this.source[0]);
    }

    @Override
    public void setLoc(float x, float y, float z) {
        if (this.soundSystem.al == null) {
            return;
        }
        if (this.type != A3SoundType.BackgroundSound) {
            this.loc.set(x, y, z);
            if (this.alIsSource()) {
                Vector3d v = Util.trans(this.quat, new Vector3d(this.offset));
                v.add(new Vector3d(this.loc));
                this.soundSystem.al.alSource3f(this.source[0], 4100, (float)v.x, (float)v.y, (float)v.z);
            }
        }
    }

    @Override
    public void setLoc(Vector3d v) {
        this.setLoc((float)v.x, (float)v.y, (float)v.z);
    }

    @Override
    public void setRot(float x, float y, float z) {
        Quat4d q = Util.euler2quat(x, y, z);
        this.setQuat(q);
    }

    @Override
    public void setRot(Vector3d r) {
        Quat4d q = Util.euler2quat(r);
        this.setQuat(q);
    }

    @Override
    public void setQuat(Quat4d q) {
        if (this.soundSystem.al == null) {
            return;
        }
        if (this.type != A3SoundType.BackgroundSound) {
            this.quat.set(q);
            Vector3d v = Util.trans(q, new Vector3d(this.orgDir));
            this.dir.set(v);
            if (this.alIsSource()) {
                this.soundSystem.al.alSource3f(this.source[0], 4101, this.dir.x, this.dir.y, this.dir.z);
            }
        }
    }

    @Override
    public void setVel() {
    }

    @Override
    public void setGain(float g) {
        if (this.soundSystem.al == null) {
            return;
        }
        this.gain = g;
        if (this.alIsSource()) {
            this.soundSystem.al.alSourcef(this.source[0], 4106, g);
        }
    }

    @Override
    public float getGain() {
        return this.gain;
    }

    @Override
    public void setDirection(float x, float y, float z) {
        if (this.soundSystem.al == null) {
            return;
        }
        this.orgDir.set(x, y, z);
        Vector3d v = Util.trans(this.quat, new Vector3d(this.orgDir));
        this.dir.set(v);
        if (this.alIsSource()) {
            this.soundSystem.al.alSource3f(this.source[0], 4101, this.dir.x, this.dir.y, this.dir.z);
        }
    }

    @Override
    public void setDirection(Vector3d d) {
        this.setDirection((float)d.x, (float)d.y, (float)d.z);
    }

    @Override
    public void setOffset(float x, float y, float z) {
        if (this.soundSystem.al == null) {
            return;
        }
        this.offset.set(x, y, z);
        if (this.alIsSource()) {
            Vector3d v = Util.trans(this.quat, new Vector3d(this.offset));
            v.add(new Vector3d(this.loc));
            this.soundSystem.al.alSource3f(this.source[0], 4100, (float)v.x, (float)v.y, (float)v.z);
        }
    }

    @Override
    public void setOffset(Vector3d o) {
        this.setOffset((float)o.x, (float)o.y, (float)o.z);
    }

    @Override
    public void setLoop(boolean l) {
        if (this.soundSystem.al == null) {
            return;
        }
        this.loop = l;
        if (this.alIsSource()) {
            if (this.loop) {
                this.soundSystem.al.alSourcei(this.source[0], 4103, 1);
            } else {
                this.soundSystem.al.alSourcei(this.source[0], 4103, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() {
        if (this.soundSystem.al == null) {
            return;
        }
        this.soundSystem.al.alSourceStop(this.source[0]);
        this.soundSystem.al.alDeleteSources(1, this.source, 0);
        this.sourceInit = false;
        ArrayList<A3Sound> arrayList = this.soundSystem.sounds;
        synchronized (arrayList) {
            this.soundSystem.sounds.remove(this);
        }
    }

    @Override
    public void setType(A3SoundType t) {
        if (this.soundSystem.al == null) {
            return;
        }
        this.type = t;
        if (!this.alIsSource()) {
            return;
        }
        if (t == A3SoundType.BackgroundSound) {
            this.soundSystem.al.alSourcei(this.source[0], 514, 1);
            this.soundSystem.al.alSource3f(this.source[0], 4100, 0.0f, 0.0f, 0.0f);
        } else if (t == A3SoundType.ConeSound) {
            this.soundSystem.al.alSourcef(this.source[0], 4097, 90.0f);
            this.soundSystem.al.alSourcef(this.source[0], 4098, 135.0f);
            this.soundSystem.al.alSourcef(this.source[0], 4130, 0.0f);
            this.soundSystem.al.alSource3f(this.source[0], 4101, this.dir.x, this.dir.y, this.dir.z);
        } else {
            this.soundSystem.al.alSourcef(this.source[0], 4097, 360.0f);
            this.soundSystem.al.alSourcef(this.source[0], 4098, 360.0f);
            this.soundSystem.al.alSourcef(this.source[0], 4130, 0.0f);
        }
    }

    @Override
    public void setSegno(float s) {
        this.segnoTime = s;
    }

    @Override
    public A3Sound copy() {
        ShortSound ret = new ShortSound();
        ret.file = this.file;
        ret.soundSystem = this.soundSystem;
        ret.segnoTime = this.segnoTime;
        ret.type = this.type;
        ret.gain = this.gain;
        ret.loop = this.loop;
        ret.offset.set(this.offset);
        ret.orgDir.set(this.orgDir);
        ret.dir.set(this.dir);
        ret.buffer[0] = this.buffer[0];
        this.check(9);
        return ret;
    }

    void check(int i) {
        if (this.soundSystem.al == null) {
            return;
        }
        int e = this.soundSystem.al.alGetError();
        if (e == 0) {
            return;
        }
        String s = "??????";
        switch (e) {
            case 40961: {
                s = "AL_INVALID_NAME";
                break;
            }
            case 40962: {
                s = "AL_INVALID_ENUM";
                break;
            }
            case 40963: {
                s = "AL_INVALID_VALUE";
                break;
            }
            case 40964: {
                s = "AL_INVALID_OPERATION";
                break;
            }
            case 40965: {
                s = "AL_OUT_OF_MEMORY";
            }
        }
        System.out.println("----------ShortSound----------");
        System.out.println("OpenAL error raised..." + s + i);
        System.out.println("------------------------------\n");
    }
}

