/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Event;

class SimpleController
extends A3Controller {
    Vector3d fixationPoint = null;
    double distance;
    Quat4d cameraQuat = null;
    int lastMouseX;
    int lastMouseY;

    public SimpleController() {
        this.distance = 0.0;
    }

    public SimpleController(Object ... params) {
        this.distance = params.length == 1 ? (Double)params[0] : 0.0;
    }

    @Override
    public void init() {
        if (this.distance == 0.0) {
            this.distance = this.a3canvas.getCameraScale() * 3.0;
        }
        this.cameraQuat = this.a3canvas.getCameraQuat();
        Quat4d cameraQuatC = new Quat4d();
        cameraQuatC.conjugate(this.cameraQuat);
        Quat4d tmpQ = new Quat4d(this.cameraQuat);
        tmpQ.mul(new Quat4d(0.0, 0.0, 1.0, 0.0));
        tmpQ.mul(cameraQuatC);
        tmpQ.scale(this.distance);
        this.fixationPoint = new Vector3d();
        Vector3d cameraLoc = this.a3canvas.getCameraLoc();
        this.fixationPoint.sub(cameraLoc, new Vector3d(tmpQ.x, tmpQ.y, tmpQ.z));
        this.setCamera();
    }

    @Override
    public void mousePressed(A3Event ae) {
        MouseEvent me = ae.getMouseEvent();
        this.lastMouseX = me.getX();
        this.lastMouseY = me.getY();
    }

    @Override
    public void mouseDragged(A3Event ae) {
        MouseEvent me = ae.getMouseEvent();
        int shiftX = me.getX() - this.lastMouseX;
        int shiftY = me.getY() - this.lastMouseY;
        if ((me.getModifiersEx() & 0x400) != 0) {
            Quat4d q0 = new Quat4d(0.0, 0.0, 0.0, 1.0);
            double t = (double)(-shiftX) * 0.01;
            Quat4d q1 = new Quat4d(0.0, Math.sin(t), 0.0, Math.cos(t));
            t = (double)(-shiftY) * 0.01;
            Quat4d q2 = new Quat4d(Math.sin(t), 0.0, 0.0, Math.cos(t));
            q0.mul(q1);
            q0.mul(q2);
            this.cameraQuat.mul(q0);
        } else if ((me.getModifiersEx() & 0x800) != 0) {
            Vector3d v = this.a3canvas.virtualCSToPhysicalCS(this.fixationPoint);
            Point3d shift = this.a3canvas.canvasToPhysicalCS(this.lastMouseX, this.lastMouseY, -v.z);
            shift.sub(this.a3canvas.canvasToPhysicalCS(me.getX(), me.getY(), -v.z));
            if ((me.getModifiers() & 1) != 0) {
                shift.set(shift.x, 0.0, -shift.y);
            }
            Vector3d vx = this.a3canvas.getCameraUnitVecX();
            Vector3d vy = this.a3canvas.getCameraUnitVecY();
            Vector3d vz = this.a3canvas.getCameraUnitVecZ();
            vx.scale(shift.x);
            vy.scale(shift.y);
            vz.scale(shift.z);
            this.fixationPoint.add(vx);
            this.fixationPoint.add(vy);
            this.fixationPoint.add(vz);
        } else if ((me.getModifiersEx() & 0x1000) != 0) {
            this.distance = this.distance * (double)(100 + shiftY) / 100.0;
        }
        this.setCamera();
        this.lastMouseX = me.getX();
        this.lastMouseY = me.getY();
    }

    void setCamera() {
        Quat4d tmpQ = new Quat4d(0.0, 0.0, 1.0, 0.0);
        Quat4d cameraQuatC = new Quat4d();
        cameraQuatC.conjugate(this.cameraQuat);
        tmpQ.mul(this.cameraQuat, tmpQ);
        tmpQ.mul(cameraQuatC);
        tmpQ.scale(this.distance);
        Vector3d cameraLoc = new Vector3d();
        cameraLoc.set(tmpQ.x, tmpQ.y, tmpQ.z);
        cameraLoc.add(this.fixationPoint);
        this.a3canvas.setCameraLocImmediately(cameraLoc);
        this.a3canvas.setCameraQuatImmediately(this.cameraQuat);
        this.a3canvas.setCameraScaleImmediately(this.distance / 3.0);
    }

    @Override
    public void mouseReleased(A3Event e) {
    }

    @Override
    public void mouseClicked(A3Event ae) {
    }

    @Override
    public void mouseDoubleClicked(A3Event ae) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

