/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Event;
import jp.sourceforge.acerola3d.a3.Util;

class FlyController
extends A3Controller
implements Runnable {
    int startMouseX = -1;
    int startMouseY = -1;
    int lastMouseX;
    int lastMouseY;
    MouseStatus mouseStatus = MouseStatus.N;

    FlyController() {
    }

    @Override
    public void init() {
        this.startMouseX = -1;
        this.startMouseY = -1;
        this.lastMouseX = 0;
        this.lastMouseY = 0;
        this.mouseStatus = MouseStatus.N;
        this.a3canvas.insertTaskIntoTimerLoop(this);
    }

    @Override
    public void stop() {
        this.a3canvas.removeTaskFromTimerLoop(this);
    }

    @Override
    public void run() {
        if (this.mouseStatus == MouseStatus.B1) {
            this.flyNavi();
        } else if (this.mouseStatus == MouseStatus.B2) {
            this.rotNavi();
        } else if (this.mouseStatus == MouseStatus.B3) {
            this.transNavi();
        }
    }

    @Override
    public void mousePressed(A3Event ae) {
        MouseEvent me = ae.getMouseEvent();
        this.startMouseX = me.getX();
        this.startMouseY = me.getY();
        this.lastMouseX = me.getX();
        this.lastMouseY = me.getY();
        if ((me.getModifiersEx() & 0x400) != 0) {
            this.mouseStatus = MouseStatus.B1;
        } else if ((me.getModifiersEx() & 0x800) != 0) {
            this.mouseStatus = MouseStatus.B2;
        } else if ((me.getModifiersEx() & 0x1000) != 0) {
            this.mouseStatus = MouseStatus.B3;
        }
    }

    @Override
    public void mouseDragged(A3Event ae) {
        MouseEvent me = ae.getMouseEvent();
        if (this.startMouseX == -1) {
            this.startMouseX = me.getX();
            this.startMouseY = me.getY();
        }
        this.lastMouseX = me.getX();
        this.lastMouseY = me.getY();
        if ((me.getModifiersEx() & 0x400) != 0) {
            this.mouseStatus = MouseStatus.B1;
        } else if ((me.getModifiersEx() & 0x800) != 0) {
            this.mouseStatus = MouseStatus.B2;
        } else if ((me.getModifiersEx() & 0x1000) != 0) {
            this.mouseStatus = MouseStatus.B3;
        }
    }

    void flyNavi() {
        Vector3d cameraV = this.a3canvas.getCameraLoc();
        Quat4d cameraQ = this.a3canvas.getCameraQuat();
        int shiftX = this.lastMouseX - this.startMouseX;
        int shiftY = this.lastMouseY - this.startMouseY;
        long elapsedTime = this.a3canvas.getUpdateInterval();
        double speed = this.a3canvas.getNavigationSpeed();
        double step = speed * (double)elapsedTime / 1000.0;
        Vector3d v = Util.trans(cameraQ, new Vector3d(0.0, 0.0, 0.04 * (double)shiftY * step));
        cameraV.add(v);
        double t = (double)shiftX * -0.004 * (double)elapsedTime / 1000.0;
        Quat4d q = new Quat4d(0.0, Math.sin(t), 0.0, Math.cos(t));
        cameraQ.mul(q);
        this.a3canvas.setCameraLocImmediately(cameraV);
        this.a3canvas.setCameraQuatImmediately(cameraQ);
    }

    void rotNavi() {
        Quat4d cameraQ = this.a3canvas.getCameraQuat();
        int shiftX = this.lastMouseX - this.startMouseX;
        int shiftY = this.lastMouseY - this.startMouseY;
        long elapsedTime = this.a3canvas.getUpdateInterval();
        double t = (double)shiftY * -0.004 * (double)elapsedTime / 1000.0;
        Quat4d q = new Quat4d(Math.sin(t), 0.0, 0.0, Math.cos(t));
        cameraQ.mul(q);
        t = (double)shiftX * -0.004 * (double)elapsedTime / 1000.0;
        q = new Quat4d(0.0, Math.sin(t), 0.0, Math.cos(t));
        cameraQ.mul(q);
        this.a3canvas.setCameraQuatImmediately(cameraQ);
    }

    void transNavi() {
        Vector3d cameraV = this.a3canvas.getCameraLoc();
        Quat4d cameraQ = this.a3canvas.getCameraQuat();
        int shiftX = this.lastMouseX - this.startMouseX;
        int shiftY = this.lastMouseY - this.startMouseY;
        long elapsedTime = this.a3canvas.getUpdateInterval();
        double speed = this.a3canvas.getNavigationSpeed();
        double step = speed * (double)elapsedTime / 1000.0;
        Vector3d v = Util.trans(cameraQ, new Vector3d(0.04 * (double)shiftX * step, 0.0, 0.0));
        cameraV.add(v);
        v = Util.trans(cameraQ, new Vector3d(0.0, -0.04 * (double)shiftY * step, 0.0));
        cameraV.add(v);
        this.a3canvas.setCameraLocImmediately(cameraV);
    }

    @Override
    public void mouseReleased(A3Event ae) {
        this.mouseStatus = MouseStatus.N;
    }

    @Override
    public void mouseClicked(A3Event ae) {
    }

    @Override
    public void mouseDoubleClicked(A3Event ae) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    static enum MouseStatus {
        N,
        B1,
        B2,
        B3;

    }
}

