/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.util.Enumeration;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.Behavior;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.vecmath.Tuple3d;
import jp.sourceforge.acerola3d.a3.A3VirtualUniverse;
import jp.sourceforge.acerola3d.a3.Action3DData;

class CameraBehavior
extends Behavior {
    A3VirtualUniverse virtualUniverse = null;
    double interpolateRatio = 0.1;

    CameraBehavior(A3VirtualUniverse vu) {
        this.virtualUniverse = vu;
    }

    @Override
    public void initialize() {
        WakeupOnBehaviorPost w = new WakeupOnBehaviorPost(this.virtualUniverse.timerBehavior, 1);
        this.wakeupOn(w);
    }

    @Override
    public void processStimulus(Enumeration criteria) {
        WakeupOnBehaviorPost w = new WakeupOnBehaviorPost(this.virtualUniverse.timerBehavior, 1);
        this.wakeupOn(w);
        if (this.interpolateRatio == 0.0) {
            this.virtualUniverse.scene.cameraNowS = this.virtualUniverse.scene.cameraNextS;
            this.virtualUniverse.scene.cameraNowQ.set(this.virtualUniverse.scene.cameraNextQ);
            this.virtualUniverse.scene.cameraNowQ.normalize();
            this.virtualUniverse.scene.cameraNowV.set(this.virtualUniverse.scene.cameraNextV);
        } else {
            double ratio = 1.0 - Math.pow(this.interpolateRatio, (double)this.virtualUniverse.elapsedTime / 1000.0);
            this.virtualUniverse.scene.cameraNowS += ratio * (this.virtualUniverse.scene.cameraNextS - this.virtualUniverse.scene.cameraNowS);
            this.virtualUniverse.scene.cameraNowQ.normalize();
            this.virtualUniverse.scene.cameraNowQ.interpolate(this.virtualUniverse.scene.cameraNextQ, ratio);
            this.virtualUniverse.scene.cameraNowQ.normalize();
            this.virtualUniverse.scene.cameraNowV.interpolate((Tuple3d)this.virtualUniverse.scene.cameraNextV, ratio);
        }
        this.virtualUniverse.transform.set(this.virtualUniverse.scene.cameraNowQ, this.virtualUniverse.scene.cameraNowV, this.virtualUniverse.scene.cameraNowS);
        try {
            this.virtualUniverse.tGroup.setTransform(this.virtualUniverse.transform);
        }
        catch (BadTransformException e) {
            System.out.println("BadTransformException in CameraBehavior.processStimulus().");
            this.virtualUniverse.scene.cameraNowS = 1.0;
            this.virtualUniverse.scene.cameraNowQ.set(0.0, 0.0, 0.0, 1.0);
            this.virtualUniverse.scene.cameraNowV.set(0.0, 0.0, 0.0);
        }
        if (Action3DData.soundSystem != null) {
            Action3DData.soundSystem.setListenerLoc(this.virtualUniverse.scene.cameraNowV);
            Action3DData.soundSystem.setListenerQuat(this.virtualUniverse.scene.cameraNowQ);
        }
    }

    void setInterpolateRatio(double ir) {
        this.interpolateRatio = ir;
    }
}

