/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.Serializable;
import java.net.URL;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;
import jp.sourceforge.acerola3d.A23;
import jp.sourceforge.acerola3d.a3.A3InitData;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.A3UpdateData;

public class A3Image
extends A3Object {
    Image image;
    static Image errImg;

    public A3Image(String url) {
        super(A3Image.initHack());
        A3InitData d = new A3InitData("jp.sourceforge.acerola3d.a3.A3Image");
        d.set(new Serializable[]{url});
        this.realConstructor(d);
    }

    public A3Image(URL url) {
        super(A3Image.initHack());
        A3InitData d = new A3InitData("jp.sourceforge.acerola3d.a3.A3Image");
        d.set(new Serializable[]{url.toString()});
        this.realConstructor(d);
    }

    public A3Image(A3InitData d) {
        super(d);
        this.realConstructor(d);
    }

    static A3InitData initHack() {
        return new A3InitData("jp.sourceforge.acerola3d.a3.A3Image");
    }

    void realConstructor(A3InitData d) {
        A23.initA23();
        this.makeImage(d.getString(0));
        BranchGroup bg = new BranchGroup();
        Texture texture = this.makeTexture();
        Appearance app = new Appearance();
        app.setTexture(texture);
        Point3d[] vertices1 = new Point3d[]{new Point3d(-1.0, 0.0, 0.1), new Point3d(1.0, 0.0, 0.1), new Point3d(1.0, 2.0, 0.1), new Point3d(-1.0, 2.0, 0.1)};
        TexCoord2f[] txcoords1 = new TexCoord2f[]{new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f)};
        QuadArray geometry1 = new QuadArray(vertices1.length, 33);
        geometry1.setCoordinates(0, vertices1);
        geometry1.setTextureCoordinates(0, 0, txcoords1);
        Shape3D shape1 = new Shape3D(geometry1, app);
        bg.addChild(shape1);
        Point3d[] vertices2 = new Point3d[]{new Point3d(-1.0, 2.0, -0.1), new Point3d(1.0, 2.0, -0.1), new Point3d(1.0, 0.0, -0.1), new Point3d(-1.0, 0.0, -0.1)};
        TexCoord2f[] txcoords2 = new TexCoord2f[]{new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f)};
        QuadArray geometry2 = new QuadArray(vertices2.length, 33);
        geometry2.setCoordinates(0, vertices2);
        geometry2.setTextureCoordinates(0, 0, txcoords2);
        Shape3D shape2 = new Shape3D(geometry2, app);
        bg.addChild(shape2);
        this.setNode(bg);
    }

    Image makeImage(String source) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            URL resource = new URL(source);
            this.image = toolkit.getImage(resource);
            return this.image;
        }
        catch (Exception e) {
            try {
                if (errImg == null) {
                    URL resource = new URL("x-res:///jp/sourceforge/acerola3d/resources/error.gif");
                    errImg = toolkit.getImage(resource);
                    return errImg;
                }
                return errImg;
            }
            catch (Exception ee) {
                ee.printStackTrace();
                return null;
            }
        }
    }

    Texture makeTexture() {
        Image img = this.image.getScaledInstance(256, 256, 4);
        return new TextureLoader(img, null).getTexture();
    }

    @Override
    public void update(A3UpdateData d) {
        super.update(d);
    }

    public static A3Image load(String url) {
        return A3Image.load(url, false, null);
    }

    public static A3Image load(String url, boolean isEnableBehavior, String label) {
        A23.initA23();
        A3InitData d = new A3InitData("jp.sourceforge.acerola3d.a3.A3Image");
        d.setEnableBehavior(isEnableBehavior);
        d.setLabel(label);
        d.set(new Serializable[]{url});
        A3Image a = new A3Image(d);
        return a;
    }
}

