/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.RoundRectangle2D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3CanvasInterface;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.Component2D;

class A3Balloon
extends Component2D {
    A3Object a3;
    String description = "none";
    double rightOffsetX;
    double rightOffsetY;
    double leftOffsetX;
    double leftOffsetY;
    double topOffsetX;
    double topOffsetY;
    double bottomOffsetX;
    double bottomOffsetY;
    int width;
    int height;
    A3Object.BalloonDir direction = A3Object.BalloonDir.RIGHT;

    A3Balloon(String s, A3Object a3) {
        this.description = s;
        this.a3 = a3;
    }

    @Override
    public void paint(Graphics2D g, A3CanvasInterface canvas) {
        int l2y;
        int l2x;
        int l1y;
        int l1x;
        int offsetY;
        int offsetX;
        g.setStroke(new BasicStroke(2.0f));
        Vector3d v = this.a3.getLoc();
        if (!this.a3.lockedA3) {
            v = canvas.virtualCSToPhysicalCS(v);
        }
        Vector3d vv = null;
        if (this.direction == A3Object.BalloonDir.RIGHT) {
            vv = new Vector3d(this.rightOffsetX, this.rightOffsetY, 0.0);
        } else if (this.direction == A3Object.BalloonDir.LEFT) {
            vv = new Vector3d(this.leftOffsetX, this.leftOffsetY, 0.0);
        } else if (this.direction == A3Object.BalloonDir.TOP) {
            vv = new Vector3d(this.topOffsetX, this.topOffsetY, 0.0);
        } else if (this.direction == A3Object.BalloonDir.BOTTOM) {
            vv = new Vector3d(this.bottomOffsetX, this.bottomOffsetY, 0.0);
        }
        vv.scale(this.a3.getScale());
        if (!this.a3.lockedA3) {
            vv.scale(1.0 / canvas.getCameraScale());
        }
        Vector3d p3d = new Vector3d(v.x + vv.x, v.y + vv.y, v.z + vv.z);
        Point p = canvas.physicalCSToCanvas(new Point3d(p3d));
        int i0 = this.description.length();
        int i1 = i0 / 10;
        int i2 = i0 % 10;
        String[] desc = new String[i1 + (i2 == 0 ? 0 : 1)];
        for (int i = 0; i < desc.length; ++i) {
            int j0 = i * 10;
            int j1 = i * 10 + 10;
            j1 = j1 > this.description.length() ? this.description.length() : j1;
            desc[i] = this.description.substring(j0, j1);
        }
        FontMetrics fm = g.getFontMetrics();
        int ir = i0 < 10 ? i0 : 10;
        this.width = fm.stringWidth("\u3042") * ir + 20;
        this.height = fm.getHeight() * desc.length + 20;
        if (this.direction == A3Object.BalloonDir.RIGHT) {
            offsetX = p.x + 10;
            offsetY = p.y - this.height / 2;
        } else if (this.direction == A3Object.BalloonDir.LEFT) {
            offsetX = p.x - this.width - 10;
            offsetY = p.y - this.height / 2;
        } else if (this.direction == A3Object.BalloonDir.TOP) {
            offsetX = p.x - this.width / 2;
            offsetY = p.y - this.height - 10;
        } else {
            offsetX = p.x - this.width / 2;
            offsetY = p.y + 10;
        }
        RoundRectangle2D.Double rec = new RoundRectangle2D.Double(offsetX, offsetY, this.width, this.height, 10.0, 10.0);
        g.setColor(Color.white);
        g.fill(rec);
        g.setColor(Color.black);
        g.draw(rec);
        for (int i = 0; i < desc.length; ++i) {
            g.drawString(desc[i], offsetX + 10, offsetY + i * fm.getHeight() + 20);
        }
        int[] x = new int[3];
        int[] y = new int[3];
        if (this.direction == A3Object.BalloonDir.RIGHT) {
            x[0] = p.x + 0;
            x[1] = p.x + 12;
            x[2] = p.x + 12;
            y[0] = p.y + 0;
            y[1] = p.y + 6;
            y[2] = p.y - 6;
            l1x = p.x + 10;
            l1y = p.y + 5;
            l2x = p.x + 10;
            l2y = p.y - 5;
        } else if (this.direction == A3Object.BalloonDir.LEFT) {
            x[0] = p.x + 0;
            x[1] = p.x - 12;
            x[2] = p.x - 12;
            y[0] = p.y + 0;
            y[1] = p.y + 6;
            y[2] = p.y - 6;
            l1x = p.x - 10;
            l1y = p.y + 5;
            l2x = p.x - 10;
            l2y = p.y - 5;
        } else if (this.direction == A3Object.BalloonDir.TOP) {
            x[0] = p.x + 0;
            x[1] = p.x + 6;
            x[2] = p.x - 6;
            y[0] = p.y + 0;
            y[1] = p.y - 12;
            y[2] = p.y - 12;
            l1x = p.x + 5;
            l1y = p.y - 10;
            l2x = p.x - 5;
            l2y = p.y - 10;
        } else {
            x[0] = p.x + 0;
            x[1] = p.x + 6;
            x[2] = p.x - 6;
            y[0] = p.y + 0;
            y[1] = p.y + 12;
            y[2] = p.y + 12;
            l1x = p.x + 5;
            l1y = p.y + 10;
            l2x = p.x - 5;
            l2y = p.y + 10;
        }
        g.setColor(Color.white);
        g.fillPolygon(x, y, 3);
        g.setColor(Color.black);
        g.drawLine(p.x, p.y, l1x, l1y);
        g.drawLine(p.x, p.y, l2x, l2y);
    }

    public void setString(String s) {
        this.description = s;
    }

    public void setDir(A3Object.BalloonDir d) {
        this.direction = d;
    }

    public void setOffset(A3Object.BalloonDir d, double x, double y) {
        this.direction = d;
        if (d == A3Object.BalloonDir.RIGHT) {
            this.rightOffsetX = x;
            this.rightOffsetY = y;
        } else if (d == A3Object.BalloonDir.LEFT) {
            this.leftOffsetX = x;
            this.leftOffsetY = y;
        } else if (d == A3Object.BalloonDir.TOP) {
            this.topOffsetX = x;
            this.topOffsetY = y;
        } else if (d == A3Object.BalloonDir.BOTTOM) {
            this.bottomOffsetX = x;
            this.bottomOffsetY = y;
        }
    }

    public void getOffset(A3Object.BalloonDir d, double[] ret) {
        if (d == A3Object.BalloonDir.RIGHT) {
            ret[0] = this.rightOffsetX;
            ret[1] = this.rightOffsetY;
        } else if (d == A3Object.BalloonDir.LEFT) {
            ret[0] = this.leftOffsetX;
            ret[1] = this.leftOffsetY;
        } else if (d == A3Object.BalloonDir.TOP) {
            ret[0] = this.topOffsetX;
            ret[1] = this.topOffsetY;
        } else if (d == A3Object.BalloonDir.BOTTOM) {
            ret[0] = this.bottomOffsetX;
            ret[1] = this.bottomOffsetY;
        } else {
            ret[1] = 0.0;
            ret[0] = 0.0;
        }
    }

    @Override
    public void calPhysicalZ(A3CanvasInterface canvas) {
        Vector3d v = canvas.virtualCSToPhysicalCS(this.a3.getLoc());
        this.z = v.z;
    }
}

