/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.loader;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import net.sf.nwn.loader.AnimEmitterNode;
import net.sf.nwn.loader.AnimNode;
import net.sf.nwn.loader.EmitterBehavior;
import net.sf.nwn.loader.EmitterNode;
import net.sf.nwn.loader.GeomNode;
import net.sf.nwn.loader.NWNUserData;

public class ModelAnimation
implements Serializable {
    private String name;
    private String model;
    private float length;
    private float transTime;
    private String animRoot;
    private ArrayList nodes = new ArrayList();
    private static Transform3D t3 = new Transform3D();
    private static final long serialVersionUID = 1L;

    public ModelAnimation(String string, String string2) {
        this.name = string.toLowerCase();
        this.model = string2;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float f) {
        this.length = f;
    }

    public float getTransTime() {
        return this.transTime;
    }

    public void setTransTime(float f) {
        this.transTime = f;
    }

    public String getAnimRoot() {
        return this.animRoot;
    }

    public void setAnimRoot(String string) {
        this.animRoot = string;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String string) {
        this.model = string;
    }

    public void addNode(AnimNode animNode) {
        this.nodes.add(animNode);
    }

    public void dump(StringBuffer stringBuffer) {
        stringBuffer.append("newanim ").append(this.getName()).append(" ").append(this.getModel()).append("\n");
        stringBuffer.append("  length ").append(this.getLength()).append("\n");
        stringBuffer.append("  transtime ").append(this.getTransTime()).append("\n");
        stringBuffer.append("animroot ").append(this.getAnimRoot()).append("\n");
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            ((AnimNode)iterator.next()).dump(stringBuffer);
        }
        stringBuffer.append("doneanim ").append(this.getName()).append(" ").append(this.getModel()).append("\n\n");
    }

    public void fixupEmitters(GeomNode geomNode) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!(this.nodes.get(i) instanceof AnimEmitterNode)) continue;
            AnimEmitterNode animEmitterNode = (AnimEmitterNode)this.nodes.get(i);
            EmitterNode emitterNode = (EmitterNode)geomNode.findChild(animEmitterNode.getName());
            if (emitterNode == null) {
                System.out.println("WARN : Missing EmitterBehavior for " + animEmitterNode.getName());
                continue;
            }
            animEmitterNode.fixupEmitter(emitterNode);
        }
    }

    public void update(Map map, Map map2, float f, boolean bl) {
        if (f > this.getLength()) {
            return;
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            TransformGroup transformGroup;
            AnimNode animNode = (AnimNode)this.nodes.get(i);
            if (animNode.getParent().equalsIgnoreCase("null") || (transformGroup = (TransformGroup)map.get(animNode.getName())) == null) continue;
            NWNUserData nWNUserData = (NWNUserData)transformGroup.getUserData();
            if (nWNUserData.owner != transformGroup) {
                transformGroup.setUserData((Object)new NWNUserData(nWNUserData.name, (Node)transformGroup));
            }
            transformGroup.getTransform(t3);
            animNode.update(t3, nWNUserData, f, bl ? this.getTransTime() : 0.0f);
            transformGroup.setTransform(t3);
            if (!(animNode instanceof AnimEmitterNode)) continue;
            EmitterBehavior emitterBehavior = (EmitterBehavior)((Object)map2.get(animNode.getName() + "%EMITTER"));
            if (emitterBehavior == null) {
                System.out.println("WARN : Missing EmitterBehavior for " + animNode.getName());
                continue;
            }
            ((AnimEmitterNode)animNode).update(emitterBehavior, f);
        }
    }
}

