/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.ac3d.tree;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import org.newdawn.j3d.loaders.ac3d.AC3DMaterial;
import org.newdawn.j3d.loaders.ac3d.AC3DSurface;
import org.newdawn.j3d.loaders.ac3d.NodeFactory;
import org.newdawn.j3d.loaders.ac3d.tree.GeometryNode;
import org.newdawn.j3d.loaders.ac3d.tree.GeometryNodeKey;
import org.newdawn.j3d.loaders.resourcepools.TextureResourcePool;
import org.newdawn.loaders.resourcepools.ResourceLoadFailedException;

public class ShapeTree {
    private HashMap nodes = new HashMap();
    private ArrayList subTrees = new ArrayList();

    public void addSurface(AC3DSurface surface, String textureName) {
        GeometryNodeKey key = new GeometryNodeKey(surface.isTwoSided(), surface.isLine(), surface.getMaterial(), textureName);
        GeometryNode node = (GeometryNode)this.nodes.get(key);
        if (node == null) {
            node = new GeometryNode(surface.isTwoSided(), surface.isLine(), surface.getMaterial(), textureName);
            this.nodes.put(key, node);
        }
        node.addGeometry(surface.getGeometry());
    }

    public void addTree(ShapeTree tree) {
        this.subTrees.add(tree);
    }

    public ArrayList getShapes(AC3DMaterial[] materials, NodeFactory nodeFactory) throws ResourceLoadFailedException {
        ArrayList<Shape3D> tempShapes = new ArrayList<Shape3D>();
        Iterator subIt = this.subTrees.iterator();
        Iterator keyIt = this.nodes.keySet().iterator();
        while (subIt.hasNext()) {
            tempShapes.addAll(((ShapeTree)subIt.next()).getShapes(materials, nodeFactory));
        }
        while (keyIt.hasNext()) {
            GeometryNodeKey key = (GeometryNodeKey)keyIt.next();
            GeometryNode node = (GeometryNode)this.nodes.get(key);
            Iterator geomIt = node.getGeometrys().iterator();
            Shape3D shape = nodeFactory.createShape3D();
            int geomCount = 0;
            while (geomIt.hasNext()) {
                shape.addGeometry((Geometry)geomIt.next());
                ++geomCount;
            }
            AC3DMaterial material = materials[node.getMaterialIndex()];
            shape.setAppearance(this.getAppearance(node.isTwoSided(), node.isLine(), material, node.getTextureName()));
            nodeFactory.finishOffShape(shape);
            tempShapes.add(shape);
        }
        return tempShapes;
    }

    public Appearance getAppearance(boolean isTwoSided, boolean isLine, AC3DMaterial ac3dMaterial, String textureName) throws ResourceLoadFailedException {
        Appearance appearance = new Appearance();
        Material material = new Material();
        TextureAttributes textureAttributes = new TextureAttributes();
        ColoringAttributes colouringAttributes = new ColoringAttributes();
        PolygonAttributes polyAttributes = new PolygonAttributes();
        material.setLightingEnable(true);
        material.setAmbientColor(ac3dMaterial.getAmbience());
        material.setDiffuseColor(ac3dMaterial.getColour());
        material.setEmissiveColor(ac3dMaterial.getEmissive());
        material.setSpecularColor(ac3dMaterial.getSpecular());
        material.setShininess(ac3dMaterial.getShininess());
        TransparencyAttributes transparency = ac3dMaterial.getTranslucency() > 0.0f ? new TransparencyAttributes(2, ac3dMaterial.getTranslucency(), 2, 3) : new TransparencyAttributes(4, 0.0f);
        textureAttributes.setTextureMode(2);
        colouringAttributes.setShadeModel(1);
        if (isTwoSided) {
            polyAttributes.setCullFace(0);
            polyAttributes.setBackFaceNormalFlip(true);
        } else {
            polyAttributes.setCullFace(1);
            polyAttributes.setBackFaceNormalFlip(false);
        }
        if (isLine) {
            polyAttributes.setPolygonMode(1);
        } else {
            polyAttributes.setPolygonMode(2);
        }
        appearance = new Appearance();
        appearance.setMaterial(material);
        appearance.setTextureAttributes(textureAttributes);
        appearance.setColoringAttributes(colouringAttributes);
        appearance.setPolygonAttributes(polyAttributes);
        appearance.setTransparencyAttributes(transparency);
        if (textureName != null && !textureName.equals("")) {
            try {
                appearance.setTexture(TextureResourcePool.getTexture(new URL(textureName)));
            }
            catch (MalformedURLException e) {
                throw new ResourceLoadFailedException("texture " + textureName + " is invalid");
            }
        }
        return appearance;
    }
}

