/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.md3;

import java.io.IOException;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleArray;
import org.newdawn.j3d.loaders.NodeFactory;
import org.newdawn.j3d.loaders.cio.LittleEndianDataInputStream;
import org.newdawn.j3d.loaders.md3.MD3Header;
import org.newdawn.j3d.loaders.md3.MD3MeshFrame;
import org.newdawn.j3d.loaders.md3.MD3Skins;
import org.newdawn.j3d.loaders.md3.Util;

public class MD3Mesh {
    private String ID;
    private String name;
    private int meshFrameNum;
    private int skinNum;
    private int vertexNum;
    private int triangleNum;
    private int triangleStart;
    private int textureStart;
    private int texVecStart;
    private int vertexStart;
    private int meshSize;
    private int[][] tris;
    private String[] skins;
    private float[][] uv;
    private MD3MeshFrame[] frames;

    public MD3Mesh(MD3Header header, LittleEndianDataInputStream in) throws IOException {
        this.ID = Util.readString(in, 4);
        this.name = Util.readString(in, 68);
        this.meshFrameNum = in.readInt();
        this.skinNum = in.readInt();
        this.vertexNum = in.readInt();
        this.triangleNum = in.readInt();
        this.triangleStart = in.readInt();
        int headerSize = in.readInt();
        this.texVecStart = in.readInt();
        this.vertexStart = in.readInt();
        this.meshSize = in.readInt();
        int byteCount = 108;
        boolean skins = headerSize == 0;
        boolean triangles = this.triangleStart == 0;
        boolean texmap = this.texVecStart == 0;
        boolean verts = this.vertexStart == 0;
        while (!(skins && triangles && texmap && verts)) {
            if (byteCount == headerSize) {
                this.readSkins(in);
                byteCount += this.skinNum * 68;
                skins = true;
                continue;
            }
            if (byteCount == this.triangleStart) {
                this.readTriangles(in);
                byteCount += this.triangleNum * 12;
                triangles = true;
                continue;
            }
            if (byteCount == this.texVecStart) {
                this.readTexMap(in);
                byteCount += this.vertexNum * 8;
                texmap = true;
                continue;
            }
            if (byteCount == this.vertexStart) {
                this.readVerts(in);
                byteCount += this.meshFrameNum * this.vertexNum * 8;
                verts = true;
                continue;
            }
            System.out.println("Invalid MD3");
        }
    }

    private void readSkins(LittleEndianDataInputStream in) throws IOException {
        this.skins = new String[this.skinNum];
        int i = 0;
        while (i < this.skinNum) {
            this.skins[i] = Util.readString(in, 68);
            ++i;
        }
    }

    private void readTriangles(LittleEndianDataInputStream in) throws IOException {
        this.tris = new int[this.triangleNum][3];
        int i = 0;
        while (i < this.triangleNum) {
            this.tris[i][0] = in.readInt();
            this.tris[i][1] = in.readInt();
            this.tris[i][2] = in.readInt();
            ++i;
        }
    }

    private void readTexMap(LittleEndianDataInputStream in) throws IOException {
        this.uv = new float[this.vertexNum][2];
        int i = 0;
        while (i < this.vertexNum) {
            this.uv[i][0] = in.readFloat();
            this.uv[i][1] = in.readFloat();
            ++i;
        }
    }

    private void readVerts(LittleEndianDataInputStream in) throws IOException {
        this.frames = new MD3MeshFrame[this.meshFrameNum];
        int i = 0;
        while (i < this.meshFrameNum) {
            this.frames[i] = new MD3MeshFrame(this, in);
            ++i;
        }
    }

    public int getVertexNum() {
        return this.vertexNum;
    }

    public int getFrameCount() {
        return this.meshFrameNum;
    }

    public int getTriangleCount() {
        return this.triangleNum;
    }

    public String getName() {
        return this.name;
    }

    public Shape3D renderFrame(int frame, MD3Skins skins, NodeFactory factory) {
        TriangleArray array = new TriangleArray(this.triangleNum * 3, 33);
        this.frames[frame].render(array, this.tris, this.uv);
        Appearance app = skins.getTextureForMesh(this.name);
        if (app == null) {
            app = new Appearance();
        }
        return factory.createShape3D((Geometry)array, app);
    }
}

