/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.md2;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.vecmath.Point3d;
import org.newdawn.j3d.loaders.md2.MD2Model;
import org.newdawn.j3d.loaders.md2.MD2RenderedFrame;

public class MD2ModelInstance
extends BranchGroup {
    private ArrayList list;
    private int animIndex = 0;
    private int newFrame;
    private MD2Model model;
    private AnimBehavior beh;
    private String lastTag;
    private Object userData;
    private Appearance override;
    private String initialAnim;

    public MD2ModelInstance(String initialAnim, MD2Model model) {
        this.model = model;
        this.initialAnim = initialAnim;
        this.list = model.getAnimation(initialAnim);
        this.setCapability(12);
        this.setCapability(14);
        this.setCapability(13);
        this.beh = new AnimBehavior();
        this.addChild((Node)this.beh);
        this.setFrameNow();
    }

    public void setUserData(Object data) {
        this.userData = data;
    }

    public void setAnimation(String tag) {
        if (tag.equals(this.lastTag)) {
            return;
        }
        this.lastTag = tag;
        ArrayList temp = this.model.getAnimation(tag);
        if (temp != null) {
            this.list = temp;
        }
        this.newFrame = 0;
        this.setFrameNow();
    }

    public int getFrame() {
        return this.newFrame;
    }

    public void nextFrame() {
        ++this.newFrame;
        if (this.newFrame >= this.list.size()) {
            this.newFrame = 0;
        }
    }

    public void prevFrame() {
        --this.newFrame;
        if (this.newFrame < 0) {
            this.newFrame = this.list.size() - 1;
        }
    }

    public void setOverrideAppearance(Appearance app) {
        this.override = app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrameNow() {
        MD2ModelInstance mD2ModelInstance = this;
        synchronized (mD2ModelInstance) {
            int i = 0;
            while (i < this.numChildren()) {
                if (this.getChild(i) instanceof BranchGroup) {
                    this.removeChild(i);
                }
                ++i;
            }
            this.animIndex = this.newFrame;
            BranchGroup bg = new BranchGroup();
            bg.setCapability(17);
            Shape3D shape = ((MD2RenderedFrame)this.list.get(this.animIndex)).getShape();
            shape.setUserData(this.userData);
            if (this.override != null) {
                shape.setAppearance(this.override);
            }
            bg.addChild((Node)shape);
            this.addChild((Node)bg);
        }
    }

    public Node cloneNode(boolean forceDuplicate) {
        MD2ModelInstance usc = new MD2ModelInstance(this.initialAnim, this.model);
        usc.duplicateNode((Node)this, forceDuplicate);
        return usc;
    }

    private class AnimBehavior
    extends Behavior {
        private AnimBehavior() {
        }

        public void initialize() {
            this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0));
            this.wakeupOn((WakeupCondition)new WakeupOnElapsedTime(10L));
        }

        public void processStimulus(Enumeration enumeration) {
            if (MD2ModelInstance.this.newFrame != MD2ModelInstance.this.animIndex) {
                MD2ModelInstance.this.setFrameNow();
            }
            this.wakeupOn((WakeupCondition)new WakeupOnElapsedTime(10L));
        }
    }
}

