/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.bsp;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import org.newdawn.j3d.loaders.DefaultNodeFactory;
import org.newdawn.j3d.loaders.ModelLoadingException;
import org.newdawn.j3d.loaders.NodeFactory;
import org.newdawn.j3d.loaders.bsp.BSPEdgeLump;
import org.newdawn.j3d.loaders.bsp.BSPFaceEdgeLump;
import org.newdawn.j3d.loaders.bsp.BSPFaceLump;
import org.newdawn.j3d.loaders.bsp.BSPHeader;
import org.newdawn.j3d.loaders.bsp.BSPTextureLump;
import org.newdawn.j3d.loaders.bsp.BSPVertexLump;
import org.newdawn.j3d.loaders.cio.ByteArrayBuilder;
import org.newdawn.j3d.loaders.pak.PAKArchive;

public class BSPLoader {
    public BranchGroup load(InputStream file, String basedir) throws ModelLoadingException, IOException {
        return this.load(file, basedir, (NodeFactory)new DefaultNodeFactory());
    }

    public BranchGroup load(InputStream file, String basedir, NodeFactory factory) throws ModelLoadingException, IOException {
        byte[] data = ByteArrayBuilder.fromStream(file);
        file.close();
        BSPHeader header = new BSPHeader(new ByteArrayInputStream(data));
        BSPVertexLump verts = new BSPVertexLump(header, new ByteArrayInputStream(data));
        BSPEdgeLump edges = new BSPEdgeLump(header, new ByteArrayInputStream(data), verts);
        BSPFaceEdgeLump fedge = new BSPFaceEdgeLump(header, new ByteArrayInputStream(data));
        BSPTextureLump texture = new BSPTextureLump(header, new ByteArrayInputStream(data));
        BSPFaceLump faces = new BSPFaceLump(header, fedge, new ByteArrayInputStream(data), edges, texture);
        BranchGroup group = new BranchGroup();
        faces.render(group, basedir, factory);
        TransformGroup tg = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setScale(0.05);
        tg.setTransform(t);
        tg.addChild((Node)group);
        BranchGroup bg = new BranchGroup();
        bg.addChild((Node)tg);
        return bg;
    }

    public BranchGroup load(InputStream file, PAKArchive pak) throws ModelLoadingException, IOException {
        return this.load(file, pak, (NodeFactory)new DefaultNodeFactory());
    }

    public BranchGroup load(InputStream file, PAKArchive pak, NodeFactory factory) throws ModelLoadingException, IOException {
        byte[] data = ByteArrayBuilder.fromStream(file);
        file.close();
        BSPHeader header = new BSPHeader(new ByteArrayInputStream(data));
        BSPVertexLump verts = new BSPVertexLump(header, new ByteArrayInputStream(data));
        BSPEdgeLump edges = new BSPEdgeLump(header, new ByteArrayInputStream(data), verts);
        BSPFaceEdgeLump fedge = new BSPFaceEdgeLump(header, new ByteArrayInputStream(data));
        BSPTextureLump texture = new BSPTextureLump(header, new ByteArrayInputStream(data));
        BSPFaceLump faces = new BSPFaceLump(header, fedge, new ByteArrayInputStream(data), edges, texture);
        BranchGroup group = new BranchGroup();
        faces.render(group, pak, factory);
        TransformGroup tg = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setScale(0.05);
        tg.setTransform(t);
        tg.addChild((Node)group);
        BranchGroup bg = new BranchGroup();
        bg.addChild((Node)tg);
        return bg;
    }

    public static void main(String[] argv) {
        try {
            new BSPLoader().load((InputStream)new FileInputStream("c:\\home\\md2loader\\model\\maps\\base1.bsp"), "c:\\home\\md2loader\\model\\textures\\");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

