/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.bsp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.newdawn.j3d.loaders.cio.LittleEndianDataInputStream;

public class BSPHeader {
    public static final int PLANES = 1;
    public static final int VERTICES = 2;
    public static final int TEXTURES = 5;
    public static final int FACES = 6;
    public static final int EDGES = 11;
    public static final int FACE_EDGE = 12;
    private int[] offsets = new int[19];
    private int[] lengths = new int[19];

    public BSPHeader(InputStream file) throws IOException {
        LittleEndianDataInputStream in = new LittleEndianDataInputStream(new DataInputStream(file));
        int magic = in.readInt();
        int version = in.readInt();
        int i = 0;
        while (i < 19) {
            this.offsets[i] = in.readInt();
            this.lengths[i] = in.readInt();
            ++i;
        }
        in.close();
    }

    public int getOffset(int chunkid) {
        return this.offsets[chunkid];
    }

    public int getLength(int chunkid) {
        return this.lengths[chunkid];
    }
}

