/*
 * Decompiled with CFR 0.152.
 */
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.io.FileInputStream;
import java.io.IOException;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.newdawn.j3d.loaders.ModelLoadingException;
import org.newdawn.j3d.loaders.md2.MD2Loader;
import org.newdawn.j3d.loaders.md2.MD2Model;
import org.newdawn.j3d.loaders.md2.MD2ModelInstance;

public class MD2Test
extends JFrame
implements Runnable {
    private String modelName;
    private String skin;
    private MD2ModelInstance alien;

    public MD2Test(String modelName, String skin) {
        this.modelName = modelName;
        this.skin = skin;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        panel.add("Center", (Component)c);
        SimpleUniverse universe = new SimpleUniverse(c);
        BranchGroup objRoot = new BranchGroup();
        TransformGroup tGroup = new TransformGroup();
        tGroup.setCapability(17);
        tGroup.setCapability(18);
        BranchGroup model = this.loadModel();
        tGroup.addChild((Node)model);
        objRoot.addChild((Node)tGroup);
        Color3f ambientColor = new Color3f(0.5f, 0.5f, 0.5f);
        AmbientLight ambientLightNode = new AmbientLight(ambientColor);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        ambientLightNode.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)ambientLightNode);
        PointLight point = new PointLight();
        point.setColor(new Color3f(1.0f, 1.0f, 1.0f));
        point.setPosition(new Point3f(0.0f, 2.0f, 0.0f));
        point.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)point);
        MouseRotate behavior = new MouseRotate();
        behavior.setTransformGroup(tGroup);
        model.addChild((Node)behavior);
        behavior.setSchedulingBounds((Bounds)bounds);
        objRoot.compile();
        this.setUpView(universe);
        universe.addBranchGraph(objRoot);
        this.setContentPane(panel);
        this.setSize(800, 600);
        this.setVisible(true);
        new Thread(this).start();
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alien.nextFrame();
        }
    }

    public void setUpView(SimpleUniverse u) {
        ViewingPlatform viewingPlatform = u.getViewingPlatform();
        viewingPlatform.setNominalViewingTransform();
        TransformGroup viewTrans = u.getViewingPlatform().getViewPlatformTransform();
        Transform3D tmp = new Transform3D();
        Transform3D mov = new Transform3D();
        mov.setTranslation(new Vector3f(0.0f, 0.0f, 2.0f));
        viewTrans.getTransform(tmp);
        tmp.mul(mov);
        viewTrans.setTransform(tmp);
    }

    private BranchGroup loadModel() {
        try {
            MD2Loader loader = new MD2Loader();
            MD2Model model = loader.loadWithPCX(new FileInputStream(this.modelName), new FileInputStream(this.skin));
            this.alien = model.getInstance();
            this.alien.setAnimation("run");
            BranchGroup temp = new BranchGroup();
            temp.addChild((Node)this.alien);
            return temp;
        }
        catch (ModelLoadingException e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println(e);
            System.exit(1);
        }
        return null;
    }

    public static void main(String[] argv) {
        String model = "model\\tris.md2";
        String skin = "model\\Alien.pcx";
        if (argv.length > 0) {
            if (argv.length == 2) {
                model = argv[0];
                skin = argv[1];
            } else {
                System.out.println("Usage: md2test [<model> <skin>]");
                System.exit(0);
            }
        }
        new MD2Test(model, skin);
    }
}

