/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.loaders.ac3d;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.newdawn.loaders.FileFormatException;
import org.newdawn.loaders.ac3d.AC3DHeader;
import org.newdawn.loaders.ac3d.AC3DMaterial;
import org.newdawn.loaders.ac3d.AC3DModel;
import org.newdawn.loaders.ac3d.AC3DObject;
import org.newdawn.loaders.ac3d.AC3DSurface;

public class AC3DLoader {
    private URL modelURL;
    private BufferedReader reader;
    private String baseURL;
    private AC3DModel model = new AC3DModel();

    private AC3DLoader(URL modelLocation) {
        String tempURLString = modelLocation.toString();
        this.modelURL = modelLocation;
        String file = tempURLString.substring(tempURLString.lastIndexOf("/") + 1);
        this.baseURL = tempURLString.substring(0, tempURLString.lastIndexOf("/") + 1);
    }

    public static AC3DModel load(String modelFilename) throws IOException, FileFormatException {
        URL url = ClassLoader.getSystemResource(modelFilename);
        if (url == null) {
            throw new FileNotFoundException("Could not find file: " + modelFilename);
        }
        return new AC3DLoader(url).load();
    }

    public static AC3DModel load(URL modelLocation) throws IOException, FileFormatException {
        return new AC3DLoader(modelLocation).load();
    }

    private AC3DModel load() throws IOException, FileFormatException {
        String line = new String();
        this.reader = new BufferedReader(new InputStreamReader(this.modelURL.openStream()));
        int materialCount = 0;
        long startTime = System.currentTimeMillis();
        this.model.setHeader(this.loadHeader());
        while (line != null) {
            line = this.reader.readLine();
            if (line == null) continue;
            String token = new StringTokenizer(line, " ").nextToken();
            if (token.equals("MATERIAL")) {
                this.model.addMaterial(this.loadMaterial(line, materialCount++));
                continue;
            }
            if (!token.equals("OBJECT")) continue;
            this.model.addObject(this.loadObject(line, this.reader));
        }
        return this.model;
    }

    private AC3DHeader loadHeader() throws IOException, FileFormatException {
        String header = this.reader.readLine();
        String filetype = header.substring(0, 4);
        String versionText = header.substring(4);
        int formatVersion = Integer.parseInt(versionText, 16);
        if (!header.substring(0, 4).equals("AC3D")) {
            System.out.println("File is not an AC3D file");
            System.out.println("Header read: " + header);
            throw new FileFormatException("File is not an AC3D file");
        }
        return new AC3DHeader(filetype, formatVersion);
    }

    public AC3DMaterial loadMaterial(String data, int materialIndex) {
        StringTokenizer tokenizer = new StringTokenizer(data, " ");
        tokenizer.nextToken();
        String name = tokenizer.nextToken();
        tokenizer.nextToken();
        float r = Float.parseFloat(tokenizer.nextToken());
        float g = Float.parseFloat(tokenizer.nextToken());
        float b = Float.parseFloat(tokenizer.nextToken());
        Color colour = new Color(r, g, b);
        tokenizer.nextToken();
        r = Float.parseFloat(tokenizer.nextToken());
        g = Float.parseFloat(tokenizer.nextToken());
        b = Float.parseFloat(tokenizer.nextToken());
        Color amb = new Color(r, g, b);
        tokenizer.nextToken();
        r = Float.parseFloat(tokenizer.nextToken());
        g = Float.parseFloat(tokenizer.nextToken());
        b = Float.parseFloat(tokenizer.nextToken());
        Color emis = new Color(r, g, b);
        tokenizer.nextToken();
        r = Float.parseFloat(tokenizer.nextToken());
        g = Float.parseFloat(tokenizer.nextToken());
        b = Float.parseFloat(tokenizer.nextToken());
        Color spec = new Color(r, g, b);
        tokenizer.nextToken();
        float shininess = Float.parseFloat(tokenizer.nextToken());
        tokenizer.nextToken();
        float translucency = Float.parseFloat(tokenizer.nextToken());
        return new AC3DMaterial(materialIndex, name, colour, amb, emis, spec, shininess, translucency);
    }

    public AC3DObject loadObject(BufferedReader reader) throws IOException, FileFormatException {
        String line = reader.readLine();
        return this.loadObject(line, reader);
    }

    public AC3DObject loadObject(String line, BufferedReader reader) throws IOException, FileFormatException {
        int type;
        String token;
        String name = null;
        String textureName = null;
        float[] rotation = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        float[] location = new float[3];
        float[][] verts = new float[0][0];
        float textureRepeatX = 1.0f;
        float textureRepeatY = 1.0f;
        float textureOffsetx = 0.0f;
        float textureOffsety = 0.0f;
        ArrayList<AC3DSurface> tempSurfaces = new ArrayList<AC3DSurface>();
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        tokenizer.nextToken();
        String stringType = token = tokenizer.nextToken();
        if (stringType.equals("world")) {
            type = 0;
        } else if (stringType.equals("poly")) {
            type = 1;
        } else if (stringType.equals("group")) {
            type = 2;
        } else {
            throw new FileFormatException("Object type \"" + stringType + "\" is not valid");
        }
        while (!token.equals("kids")) {
            int i;
            int i2;
            line = reader.readLine();
            tokenizer = new StringTokenizer(line);
            token = tokenizer.nextToken();
            if (token.equals("name")) {
                name = tokenizer.nextToken();
                continue;
            }
            if (token.equals("data")) {
                line = reader.readLine();
                continue;
            }
            if (token.equals("texture")) {
                tokenizer.nextToken("\"");
                textureName = tokenizer.nextToken("\"");
                continue;
            }
            if (token.equals("texoff")) {
                textureOffsetx = Float.parseFloat(tokenizer.nextToken());
                textureOffsety = Float.parseFloat(tokenizer.nextToken());
                continue;
            }
            if (token.equals("texrep")) {
                textureRepeatX = Float.parseFloat(tokenizer.nextToken());
                textureRepeatY = Float.parseFloat(tokenizer.nextToken());
                continue;
            }
            if (token.equals("rot")) {
                for (i2 = 0; i2 < 9; ++i2) {
                    rotation[i2] = Float.parseFloat(tokenizer.nextToken());
                }
                continue;
            }
            if (token.equals("loc")) {
                for (i2 = 0; i2 < 3; ++i2) {
                    location[i2] = Float.parseFloat(tokenizer.nextToken());
                }
                continue;
            }
            if (token.equals("url")) {
                System.out.println("url tag unsuported");
                continue;
            }
            if (token.equals("numvert")) {
                int numvert = Integer.parseInt(tokenizer.nextToken());
                verts = new float[numvert][3];
                for (i = 0; i < numvert; ++i) {
                    line = reader.readLine();
                    tokenizer = new StringTokenizer(line, " ");
                    verts[i][0] = Float.parseFloat(tokenizer.nextToken());
                    verts[i][1] = Float.parseFloat(tokenizer.nextToken());
                    verts[i][2] = Float.parseFloat(tokenizer.nextToken());
                }
                continue;
            }
            if (!token.equals("numsurf")) continue;
            int numsurf = Integer.parseInt(tokenizer.nextToken());
            for (i = 0; i < numsurf; ++i) {
                AC3DSurface surface = this.loadSurface(reader);
                if (surface.isLine() || surface.getVertexReferenceCount() >= 3) {
                    tempSurfaces.add(surface);
                    continue;
                }
                --numsurf;
                --i;
            }
        }
        AC3DObject object = new AC3DObject(type, name, textureName, rotation, location, verts, textureRepeatX, textureRepeatY, textureOffsetx, textureOffsety);
        Iterator surfIt = tempSurfaces.iterator();
        while (surfIt.hasNext()) {
            object.addSurface((AC3DSurface)surfIt.next());
        }
        if (token.equals("kids")) {
            int numKids = Integer.parseInt(tokenizer.nextToken());
            for (int i = 0; i < numKids; ++i) {
                object.addObject(this.loadObject(reader));
            }
        } else {
            throw new FileFormatException("\"" + token.toString() + "\"" + " found where only a 'kids' should be");
        }
        return object;
    }

    public AC3DSurface loadSurface(BufferedReader reader) throws IOException, FileFormatException {
        int material = -1;
        String line = reader.readLine();
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        tokenizer.nextToken();
        int flags = Integer.parseInt(tokenizer.nextToken().substring(2), 16);
        int type = flags & 0xF;
        boolean shaded = (flags >> 4 & 1) == 1;
        boolean twoSided = (flags >> 5 & 1) == 1;
        line = reader.readLine();
        tokenizer = new StringTokenizer(line, " ");
        String token = tokenizer.nextToken();
        if (token.equals("mat")) {
            material = Integer.parseInt(tokenizer.nextToken());
            line = reader.readLine();
            tokenizer = new StringTokenizer(line, " ");
            token = tokenizer.nextToken();
        }
        int numRefs = Integer.parseInt(tokenizer.nextToken());
        int[] surfVerts = new int[numRefs];
        float[][] textCoords = new float[numRefs][2];
        for (int i = 0; i < numRefs; ++i) {
            int vertRef;
            line = reader.readLine();
            tokenizer = new StringTokenizer(line, " ");
            token = tokenizer.nextToken();
            surfVerts[i] = vertRef = Integer.parseInt(token);
            textCoords[i][0] = Float.parseFloat(tokenizer.nextToken());
            textCoords[i][1] = Float.parseFloat(tokenizer.nextToken());
        }
        return new AC3DSurface(type, twoSided, shaded, material, surfVerts, textCoords);
    }

    public static void main(String[] args) {
        System.out.println("Trying to load " + args[0]);
        try {
            if (args[0].equals("URL")) {
                AC3DLoader.load(new URL(args[1]));
            } else {
                AC3DLoader.load(args[0]);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

