/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import javax.media.j3d.Node;
import org.jdesktop.j3d.loaders.vrml97.impl.Browser;
import org.jdesktop.j3d.loaders.vrml97.impl.Field;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.Scene;

public abstract class BaseNode {
    String defName;
    Browser browser;
    Loader loader;
    boolean implReady;
    Node implNode;
    BaseNode parent;

    public BaseNode(Browser browser) {
        this.browser = browser;
    }

    BaseNode(Loader loader) {
        this.loader = loader;
        this.browser = loader.browser;
    }

    public abstract String getType();

    public abstract Object clone();

    public abstract void notifyMethod(String var1, double var2);

    public abstract a3vrml.BaseNode wrap();

    public abstract Field getField(String var1);

    public Browser getBrowser() {
        return this.browser;
    }

    void initImpl() {
        if (this.loader.debug) {
            System.out.println("BaseNode.initImpl() called on node " + this.toStringId());
        }
        this.implNode = null;
        this.implReady = true;
    }

    void updateParent(Node parentImpl) {
    }

    public Node getImplNode() {
        return this.implNode;
    }

    void define(String defName) {
        this.defName = defName;
    }

    void registerUse(Scene scene) {
    }

    public int getNumTris() {
        return 0;
    }

    public final String toString() {
        String retval = "";
        if (this.defName != null) {
            retval = retval + "DEF " + this.defName + " ";
        }
        retval = retval + this.toStringBody();
        return retval;
    }

    public String toStringId() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    String toStringBody() {
        return this.toStringId();
    }
}

