/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.demos.utils.scenegraph.traverser;

import com.sun.j3d.demos.utils.scenegraph.traverser.ProcessNodeInterface;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.Switch;

public class TreeScan {
    private static HashSet visitedSharedGroups = null;

    public static void findNode(Node node, Class clazz, ProcessNodeInterface processNodeInterface, boolean bl, boolean bl2) throws CapabilityNotSetException {
        Class[] classArray = new Class[]{clazz};
        TreeScan.findNode(node, classArray, processNodeInterface, bl, bl2);
    }

    public static void findNode(Node node, Class[] classArray, ProcessNodeInterface processNodeInterface, boolean bl, boolean bl2) throws CapabilityNotSetException {
        if (bl2 && visitedSharedGroups == null) {
            visitedSharedGroups = new HashSet();
        }
        TreeScan.actualFindNode(node, classArray, processNodeInterface, bl, bl2);
        if (bl2) {
            visitedSharedGroups.clear();
        }
    }

    public static Class getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new RuntimeException("BAD CLASS " + string);
        }
    }

    private static void actualFindNode(Node node, Class[] classArray, ProcessNodeInterface processNodeInterface, boolean bl, boolean bl2) throws CapabilityNotSetException {
        int n;
        if (node == null) {
            return;
        }
        if (node instanceof SharedGroup && bl2) {
            if (visitedSharedGroups.contains(node)) {
                return;
            }
            visitedSharedGroups.add(node);
        }
        for (n = 0; n < classArray.length; ++n) {
            if (!classArray[n].isAssignableFrom(node.getClass())) continue;
            processNodeInterface.processNode(node);
        }
        if (bl && node instanceof Switch) {
            n = ((Switch)node).getWhichChild();
            if (n == -2) {
                Enumeration enumeration = ((Group)node).getAllChildren();
                while (enumeration.hasMoreElements()) {
                    TreeScan.actualFindNode((Node)enumeration.nextElement(), classArray, processNodeInterface, bl, bl2);
                }
            } else if (n == -3) {
                BitSet bitSet = ((Switch)node).getChildMask();
                for (int i = 0; i < bitSet.length(); ++i) {
                    if (!bitSet.get(i)) continue;
                    TreeScan.actualFindNode(((Switch)node).getChild(i), classArray, processNodeInterface, bl, bl2);
                }
            } else if (n != -1) {
                TreeScan.actualFindNode(((Switch)node).currentChild(), classArray, processNodeInterface, bl, bl2);
            }
        } else if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                TreeScan.actualFindNode((Node)enumeration.nextElement(), classArray, processNodeInterface, bl, bl2);
            }
        } else if (node instanceof Link) {
            TreeScan.actualFindNode((Node)((Link)node).getSharedGroup(), classArray, processNodeInterface, bl, bl2);
        }
    }
}

