/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.bsp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.media.j3d.BranchGroup;
import org.newdawn.j3d.loaders.NodeFactory;
import org.newdawn.j3d.loaders.bsp.BSPEdgeLump;
import org.newdawn.j3d.loaders.bsp.BSPFace;
import org.newdawn.j3d.loaders.bsp.BSPFaceEdgeLump;
import org.newdawn.j3d.loaders.bsp.BSPHeader;
import org.newdawn.j3d.loaders.bsp.BSPTextureLump;
import org.newdawn.j3d.loaders.bsp.WALList;
import org.newdawn.j3d.loaders.cio.LittleEndianDataInputStream;
import org.newdawn.j3d.loaders.pak.PAKArchive;

public class BSPFaceLump {
    private BSPFace[] faces;

    public BSPFaceLump(BSPHeader header, BSPFaceEdgeLump faceEdge, InputStream file, BSPEdgeLump edgeLump, BSPTextureLump textures) throws IOException {
        LittleEndianDataInputStream in = new LittleEndianDataInputStream(new DataInputStream(file));
        int len = header.getLength(6);
        this.faces = new BSPFace[len / 20];
        int offset = header.getOffset(6);
        in.skip(offset);
        int i = 0;
        while (i < this.faces.length) {
            int plane = in.readUnsignedShort();
            int planeSide = in.readUnsignedShort();
            int firstEdge = in.readInt();
            int numEdges = in.readUnsignedShort();
            int textureInfo = in.readUnsignedShort();
            byte[] lightmapStyles = new byte[4];
            in.read(lightmapStyles);
            int lightmapOffset = in.readInt();
            int[] edges = new int[numEdges];
            int j = 0;
            while (j < numEdges) {
                edges[j] = faceEdge.getEdgeFor(firstEdge + j);
                ++j;
            }
            this.faces[i] = new BSPFace(edges, textureInfo, edgeLump, textures);
            ++i;
        }
        in.close();
    }

    public void render(BranchGroup group, PAKArchive pak, NodeFactory factory) {
        WALList list = new WALList();
        int i = 0;
        while (i < this.faces.length) {
            this.faces[i].render(group, pak, list, factory);
            ++i;
        }
    }

    public void render(BranchGroup group, String basedir, NodeFactory factory) {
        WALList list = new WALList();
        int i = 0;
        while (i < this.faces.length) {
            this.faces[i].render(group, basedir, list, factory);
            ++i;
        }
    }
}

