/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.j3dbvh;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sourceforge.acerola3d.A23;
import jp.sourceforge.acerola3d.a3.A3Canvas;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.Action3D;
import jp.sourceforge.acerola3d.a3.Skeleton;
import jp.sourceforge.acerola3d.j3dbvh.A3PHtmlViewer;
import jp.sourceforge.acerola3d.j3dbvh.BvhTransferHandler;
import jp.sourceforge.acerola3d.j3dbvh.JTextAreaOutputStream;
import jp.sourceforge.acerola3d.j3dbvh.MyExamController;
import jp.sourceforge.acerola3d.j3dbvh.MyHBox;
import jp.sourceforge.acerola3d.j3dbvh.MyVBox;

public class J3DBVH
implements ActionListener,
ChangeListener {
    JFrame frame;
    JMenuBar menuBar;
    JMenu configMenu;
    JMenuItem consoleMenuItem;
    JMenuItem resetViewMenuItem;
    JMenuItem snapshotMenuItem;
    JMenu measureMenu;
    JMenuItem measureXZMenuItem;
    JMenuItem measureXYMenuItem;
    JMenuItem measureYZMenuItem;
    JMenuItem measureNoneMenuItem;
    JMenuItem helpMenuItem;
    JMenuItem aboutMenuItem;
    JTextField urlTextField;
    JButton refButton;
    JFileChooser fileChooser;
    A3Canvas a3canvas;
    JButton resetViewButton;
    JCheckBox defaultPoseCheckBox;
    JComboBox boneComboBox;
    JLabel statusBarLabel;
    JFrame consoleFrame;
    JTextArea consoleTextArea;
    JButton clearConsoleButton;
    JCheckBox pauseCheckBox;
    JSlider slider;
    int sliderLength = 100;
    double motionLength;
    A3PHtmlViewer htmlViewer;
    A3PHtmlViewer helpViewer;
    Action3D measure;
    Skeleton skeleton;
    String actionName = "0";
    MyExamController controller;
    ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);

    public J3DBVH(String[] args) {
        this.frame = new JFrame("J3DBVH");
        this.frame.getContentPane().setLayout(new BorderLayout());
        MyVBox baseBox = new MyVBox();
        this.frame.getContentPane().add((Component)baseBox, "Center");
        this.menuBar = new JMenuBar();
        this.frame.setJMenuBar(this.menuBar);
        this.menuBar.add(Box.createHorizontalGlue());
        this.configMenu = new JMenu("Config");
        this.menuBar.add(this.configMenu);
        this.consoleMenuItem = new JMenuItem("Console");
        this.consoleMenuItem.addActionListener(this);
        this.configMenu.add(this.consoleMenuItem);
        this.resetViewMenuItem = new JMenuItem("ResetView");
        this.resetViewMenuItem.addActionListener(this);
        this.configMenu.add(this.resetViewMenuItem);
        this.snapshotMenuItem = new JMenuItem("Snapshot");
        this.snapshotMenuItem.addActionListener(this);
        this.configMenu.add(this.snapshotMenuItem);
        this.measureMenu = new JMenu("measure");
        this.configMenu.add(this.measureMenu);
        this.measureXZMenuItem = new JMenuItem("measure XZ");
        this.measureXZMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureXZMenuItem);
        this.measureXYMenuItem = new JMenuItem("measure XY");
        this.measureXYMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureXYMenuItem);
        this.measureYZMenuItem = new JMenuItem("measure YZ");
        this.measureYZMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureYZMenuItem);
        this.measureNoneMenuItem = new JMenuItem("measure None");
        this.measureNoneMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureNoneMenuItem);
        this.helpMenuItem = new JMenuItem("help");
        this.helpMenuItem.addActionListener(this);
        this.configMenu.add(this.helpMenuItem);
        this.aboutMenuItem = new JMenuItem("about");
        this.aboutMenuItem.addActionListener(this);
        this.configMenu.add(this.aboutMenuItem);
        this.consoleFrame = new JFrame("Console");
        this.consoleFrame.getContentPane().setLayout(new BorderLayout());
        MyVBox b = new MyVBox();
        this.consoleTextArea = new JTextArea(20, 60);
        this.consoleTextArea.setEditable(false);
        JScrollPane sp = new JScrollPane(this.consoleTextArea);
        b.myAdd(sp, 1.0);
        this.clearConsoleButton = new JButton("Clear");
        this.clearConsoleButton.addActionListener(this);
        b.myAdd(this.clearConsoleButton, 0.0);
        this.consoleFrame.getContentPane().add((Component)b, "Center");
        this.consoleFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                J3DBVH.this.consoleFrame.setVisible(false);
            }
        });
        PrintStream systemOut = System.out;
        JTextAreaOutputStream jtaos = new JTextAreaOutputStream(this.consoleTextArea, systemOut);
        PrintStream ps = new PrintStream(jtaos, true);
        System.setOut(ps);
        System.setErr(ps);
        this.consoleFrame.pack();
        MyHBox addressBox = new MyHBox();
        baseBox.myAdd(addressBox, 0.0);
        addressBox.myAdd(new JLabel("URL:"), 0.0);
        this.urlTextField = new JTextField();
        try {
            File f = null;
            f = args != null && args.length == 2 && args[0].equals("-open") ? new File(args[1]) : new File(args[0]);
            this.urlTextField.setText(f.toURI().toString());
        }
        catch (Exception e) {
            this.urlTextField.setText("x-res:///jp/sourceforge/acerola3d/j3dbvh/resources/test.bvh");
        }
        this.urlTextField.addActionListener(this);
        this.urlTextField.setMaximumSize(new Dimension(3000, 30));
        addressBox.myAdd(this.urlTextField, 1.0);
        this.refButton = new JButton("ref");
        this.refButton.addActionListener(this);
        addressBox.myAdd(this.refButton, 0.0);
        MyHBox mainBox = new MyHBox();
        baseBox.myAdd(mainBox, 1.0);
        this.a3canvas = A3Canvas.createA3Canvas((int)300, (int)300);
        this.controller = new MyExamController();
        this.a3canvas.setA3Controller((A3Controller)this.controller);
        mainBox.myAdd((Component)this.a3canvas, 1.0);
        MyVBox controlBox = this.makeControlBox();
        mainBox.myAdd(controlBox, 0.0);
        Box box3 = Box.createHorizontalBox();
        baseBox.myAdd(box3, 0.0);
        this.pauseCheckBox = new JCheckBox("puase");
        this.pauseCheckBox.setSelected(false);
        this.pauseCheckBox.addActionListener(this);
        box3.add(this.pauseCheckBox);
        this.slider = new JSlider();
        this.slider.setMinimum(0);
        this.slider.setMaximum(this.sliderLength);
        this.slider.addChangeListener(this);
        box3.add(this.slider);
        this.statusBarLabel = new JLabel("Status:");
        baseBox.myAdd(this.statusBarLabel, 0.0);
        try {
            this.measure = new Action3D("x-res:///jp/sourceforge/acerola3d/j3dbvh/resources/measure.a3");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.frame.setTransferHandler(new BvhTransferHandler(this));
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                J3DBVH.this.frame.dispose();
                System.exit(0);
            }
        });
        this.frame.pack();
        this.frame.setVisible(true);
        this.htmlViewer = new A3PHtmlViewer(this.frame);
        this.helpViewer = new A3PHtmlViewer(null);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                J3DBVH.this.loadBVH();
            }
        };
        this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
    }

    MyVBox makeControlBox() {
        MyVBox controlBox = new MyVBox();
        this.resetViewButton = new JButton("Reset View");
        this.resetViewButton.addActionListener(this);
        controlBox.myAdd(this.resetViewButton, 0.0);
        this.defaultPoseCheckBox = new JCheckBox("default pose");
        this.defaultPoseCheckBox.setSelected(false);
        this.defaultPoseCheckBox.addActionListener(this);
        controlBox.myAdd(this.defaultPoseCheckBox, 0.0);
        this.boneComboBox = new JComboBox();
        this.boneComboBox.addActionListener(this);
        this.boneComboBox.addItem("[none]");
        controlBox.myAdd(this.boneComboBox, 0.0);
        controlBox.myAdd(new JLabel("Left drag: rotation"), 0.0);
        controlBox.myAdd(new JLabel("Center drag: translation"), 0.0);
        controlBox.myAdd(new JLabel("Right drag: scale"), 0.0);
        controlBox.myAdd(Box.createVerticalGlue(), 1.0);
        String buildDate = null;
        try {
            URL url = this.getClass().getClassLoader().getResource("buildDate.txt");
            InputStreamReader isr = new InputStreamReader(url.openStream(), "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            buildDate = br.readLine();
        }
        catch (Exception e) {
            buildDate = "???";
        }
        controlBox.myAdd(new JLabel("build date:"), 0.0);
        controlBox.myAdd(new JLabel("   " + buildDate), 0.0);
        return controlBox;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.urlTextField) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    J3DBVH.this.loadBVH();
                }
            };
            this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
        } else if (ae.getSource() == this.resetViewButton) {
            this.controller.reset((A3Object)this.skeleton);
        } else if (ae.getSource() == this.defaultPoseCheckBox) {
            if (this.defaultPoseCheckBox.isSelected()) {
                this.skeleton.defaultPose();
            } else {
                this.skeleton.start();
            }
        } else if (ae.getSource() == this.refButton) {
            this.ref();
        } else if (ae.getSource() == this.consoleMenuItem) {
            this.consoleFrame.setVisible(true);
        } else if (ae.getSource() == this.clearConsoleButton) {
            this.consoleTextArea.setText("");
        } else if (ae.getSource() == this.resetViewMenuItem) {
            this.controller.reset((A3Object)this.skeleton);
        } else if (ae.getSource() == this.snapshotMenuItem) {
            try {
                File f = new File("snapshot.png");
                this.a3canvas.saveImage(f);
            }
            catch (Exception e) {
                System.out.println("A3Viewer:snapshot");
                e.printStackTrace();
            }
        } else if (ae.getSource() == this.measureXZMenuItem) {
            this.measure.setRot(-1.5707963267948966, 0.0, 0.0);
            this.a3canvas.add((A3Object)this.measure);
        } else if (ae.getSource() == this.measureXYMenuItem) {
            this.measure.setRot(0.0, 0.0, 0.0);
            this.a3canvas.add((A3Object)this.measure);
        } else if (ae.getSource() == this.measureYZMenuItem) {
            this.measure.setRot(0.0, 1.5707963267948966, 0.0);
            this.a3canvas.add((A3Object)this.measure);
        } else if (ae.getSource() == this.measureNoneMenuItem) {
            this.a3canvas.del((A3Object)this.measure);
        } else if (ae.getSource() == this.helpMenuItem) {
            this.openHelp();
        } else if (ae.getSource() == this.aboutMenuItem) {
            this.openAbout();
        } else if (ae.getSource() == this.pauseCheckBox) {
            if (this.skeleton == null) {
                return;
            }
            if (this.pauseCheckBox.isSelected()) {
                this.skeleton.pause();
                double t = this.motionLength * ((double)this.slider.getValue() / (double)this.sliderLength);
                this.skeleton.setPauseTime(t);
            } else {
                this.skeleton.start();
                double t = this.motionLength * ((double)this.slider.getValue() / (double)this.sliderLength);
                this.skeleton.setPauseTime(t);
            }
        } else if (ae.getSource() == this.boneComboBox) {
            this.selectBone();
        } else {
            System.out.append("gaha???");
        }
    }

    void selectBone() {
        String bn = (String)this.boneComboBox.getSelectedItem();
        if (bn == null) {
            System.out.println("gaha1");
            return;
        }
        if (bn.equals("[none]")) {
            this.resetBone();
        } else {
            this.resetBone();
            this.skeleton.setBoneSelected(bn, true);
        }
    }

    void resetBone() {
        if (this.skeleton == null) {
            return;
        }
        String bn = this.skeleton.getRootBone();
        this.resetBone2(bn);
    }

    void resetBone2(String bn) {
        this.skeleton.setBoneSelected(bn, false);
        for (String nbn : this.skeleton.getChildBones(bn)) {
            this.resetBone2(nbn);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (ce.getSource() == this.slider) {
            if (this.skeleton == null) {
                return;
            }
            double t = this.motionLength * ((double)this.slider.getValue() / (double)this.sliderLength);
            this.skeleton.setPauseTime(t);
        }
    }

    void loadBVH() {
        this.statusBarLabel.setText("Status: Loading ... ");
        this.statusBarLabel.repaint();
        if (this.skeleton != null) {
            this.a3canvas.del((A3Object)this.skeleton);
        }
        String urlString = this.urlTextField.getText();
        try {
            A23.initA23();
            this.skeleton = new Skeleton(urlString);
            this.controller.reset((A3Object)this.skeleton);
        }
        catch (Exception e) {
            System.out.println("J3DVrml.loadVRML. error!");
            e.printStackTrace();
        }
        this.a3canvas.add((A3Object)this.skeleton);
        this.boneComboBox.removeAllItems();
        this.boneComboBox.addItem("[none]");
        for (String bn : this.getBoneNames()) {
            this.boneComboBox.addItem(bn);
        }
        if (this.pauseCheckBox.isSelected()) {
            this.skeleton.pause();
        } else {
            this.skeleton.start();
        }
        this.slider.setValue(0);
        this.motionLength = this.skeleton.getMotionLength();
        this.skeleton.setLocImmediately(0.0, 0.0, 0.0);
        this.skeleton.setQuatImmediately(0.0, 0.0, 0.0, 1.0);
        this.skeleton.setScaleImmediately(1.0);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                J3DBVH.this.controller.reset((A3Object)J3DBVH.this.skeleton);
            }
        };
        this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
        this.statusBarLabel.setText("Status: Loading ... done.");
    }

    String[] getBoneNames() {
        if (this.skeleton == null) {
            return new String[0];
        }
        ArrayList<String> names = new ArrayList<String>();
        this.getBoneNames2(this.skeleton.getRootBone(), names);
        return names.toArray(new String[0]);
    }

    void getBoneNames2(String bn, ArrayList<String> names) {
        names.add(bn);
        for (String nbn : this.skeleton.getChildBones(bn)) {
            this.getBoneNames2(nbn, names);
        }
    }

    void loadBVH(File f) throws Exception {
        this.urlTextField.setText(f.toURI().toURL().toString());
        Runnable r = new Runnable(){

            @Override
            public void run() {
                J3DBVH.this.loadBVH();
            }
        };
        this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
    }

    void ref() {
        int returnVal;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
        }
        if ((returnVal = this.fileChooser.showOpenDialog(this.frame)) != 0) {
            return;
        }
        File f = this.fileChooser.getSelectedFile();
        URL url = null;
        try {
            url = new URL(f.toURI().toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url == null) {
            return;
        }
        this.urlTextField.setText(url.toExternalForm());
        Runnable r = new Runnable(){

            @Override
            public void run() {
                J3DBVH.this.loadBVH();
            }
        };
        this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
    }

    void openHelp() {
        URL url = null;
        try {
            url = new URL("x-res:///jp/sourceforge/acerola3d/j3dbvh/resources/ja/help.html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.helpViewer.open(url);
    }

    void openAbout() {
        URL url = null;
        try {
            url = new URL("x-res:///jp/sourceforge/acerola3d/j3dbvh/resources/ja/about.html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.htmlViewer.open(url);
    }

    public static void main(String[] args) {
        System.setSecurityManager(null);
        final String[] argsCopy = args;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new J3DBVH(argsCopy);
            }
        });
    }
}

