/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;

public class PowerOfTwo
extends UnitGenerator {
    public UnitInputPort input = new UnitInputPort("Input");
    public UnitOutputPort output;
    private static double[] table = new double[2050];
    private static final int NUM_VALUES = 2048;
    private double lastInput = 0.0;
    private double lastOutput = 1.0;

    public PowerOfTwo() {
        this.addPort(this.input);
        this.input.setup(-8.0, 0.0, 8.0);
        this.output = new UnitOutputPort("Output");
        this.addPort(this.output);
    }

    @Override
    public void generate(int n, int n2) {
        double[] dArray = this.input.getValues();
        double[] dArray2 = this.output.getValues();
        for (int i = n; i < n2; ++i) {
            double d;
            double d2 = dArray[i];
            if (d2 == this.lastInput) {
                dArray2[i] = this.lastOutput;
                continue;
            }
            this.lastInput = d2;
            double d3 = this.adjustInput(d2);
            int n3 = (int)Math.floor(d3);
            double d4 = d3 - (double)n3;
            double d5 = d4 * 2048.0;
            int n4 = (int)d5;
            double d6 = d5 - (double)n4;
            double d7 = table[n4] + d6 * (table[n4 + 1] - table[n4]);
            while (n3 > 0) {
                --n3;
                d7 *= 2.0;
            }
            while (n3 < 0) {
                ++n3;
                d7 *= 0.5;
            }
            dArray2[i] = d = this.adjustOutput(d7);
            this.lastOutput = d;
        }
    }

    public double adjustInput(double d) {
        return d;
    }

    public double adjustOutput(double d) {
        return d;
    }

    static {
        for (int i = 0; i < table.length; ++i) {
            double d;
            PowerOfTwo.table[i] = d = Math.pow(2.0, (double)i / 2048.0);
        }
    }
}

