/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.swing.EnvelopePoints;
import com.jsyn.swing.XYController;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

public class EnvelopeEditorBox
extends XYController
implements MouseListener,
MouseMotionListener {
    EnvelopePoints points;
    ArrayList<EditListener> listeners = new ArrayList();
    int dragIndex = -1;
    double dragLowLimit;
    double dragHighLimit;
    double[] draggedPoint;
    double xBefore;
    double xPicked;
    double dragWX;
    double dragWY;
    int maxPoints = Integer.MAX_VALUE;
    int radius = 4;
    double verticalBarSpacing = 1.0;
    boolean verticalBarsEnabled = false;
    double maximumXRange = Double.MAX_VALUE;
    double minimumXRange = 0.1;
    int rangeStart = -1;
    int rangeEnd = -1;
    int mode = 0;
    public static final int EDIT_POINTS = 0;
    public static final int SELECT_SUSTAIN = 1;
    public static final int SELECT_RELEASE = 2;
    Color rangeColor = Color.RED;
    Color sustainColor = Color.BLUE;
    Color releaseColor = Color.YELLOW;
    Color overlapColor = Color.GREEN;
    Color firstLineColor = Color.GRAY;

    public EnvelopeEditorBox() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setMaximumXRange(double d) {
        this.maximumXRange = d;
    }

    public double getMaximumXRange() {
        return this.maximumXRange;
    }

    public void setMinimumXRange(double d) {
        this.minimumXRange = d;
    }

    public double getMinimumXRange() {
        return this.minimumXRange;
    }

    public void setSelection(int n, int n2) {
        switch (this.mode) {
            case 1: {
                this.points.setSustainLoop(n, n2);
                break;
            }
            case 2: {
                this.points.setReleaseLoop(n, n2);
            }
        }
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    public void addEditListener(EditListener editListener) {
        this.listeners.add(editListener);
    }

    public void removeEditListener(EditListener editListener) {
        this.listeners.remove(editListener);
    }

    public void fireObjectEdited() {
        for (EditListener editListener : this.listeners) {
            editListener.objectEdited(this, this.points);
        }
    }

    public void setMaxPoints(int n) {
        this.maxPoints = n;
    }

    public int getMaxPoints() {
        return this.maxPoints;
    }

    public int getNumPoints() {
        return this.points.size();
    }

    public void setPoints(EnvelopePoints envelopePoints) {
        this.points = envelopePoints;
        this.setMaxWorldY(envelopePoints.getMaximumValue());
    }

    public EnvelopePoints getPoints() {
        return this.points;
    }

    private int findPointBefore(double d) {
        int n = -1;
        double d2 = 0.0;
        this.xBefore = 0.0;
        int n2 = 0;
        while (n2 < this.points.size() && !((d2 += this.points.getDuration(n2)) > d)) {
            n = n2++;
            this.xBefore = d2;
        }
        return n;
    }

    private int pickPoint(double d, double d2, double d3, double d4) {
        double d5 = 0.0;
        double d6 = d - d2;
        double d7 = d + d2;
        double d8 = d3 - d4;
        double d9 = d3 + d4;
        double d10 = 1.0 / d2;
        double d11 = 1.0 / d4;
        int n = -1;
        double d12 = Double.MAX_VALUE;
        for (int i = 0; i < this.points.size(); ++i) {
            double d13;
            double d14;
            double d15;
            double[] dArray = this.points.getPoint(i);
            d5 += dArray[0];
            double d16 = dArray[1];
            if (!(d5 > d6) || !(d5 < d7) || !(d16 > d8) || !(d16 < d9) || !((d15 = (d14 = (d5 - d) * d10) * d14 + (d13 = (d16 - d3) * d11) * d13) < d12)) continue;
            n = i;
            d12 = d15;
            this.xPicked = d5;
        }
        return n;
    }

    private void clickDownRange(boolean bl, int n, int n2) {
        this.setSelection(-1, -1);
        this.rangeStart = this.rangeEnd = n;
        this.repaint();
    }

    private void dragRange(int n, int n2) {
        this.rangeEnd = n;
        this.repaint();
    }

    private void clickUpRange(int n, int n2) {
        this.dragRange(n, n2);
        if (this.rangeEnd < this.rangeStart) {
            int n3 = this.rangeEnd;
            this.rangeEnd = this.rangeStart;
            this.rangeStart = n3;
        }
        double d = this.convertGXtoWX(this.rangeStart);
        int n4 = this.findPointBefore(d);
        d = this.convertGXtoWX(this.rangeEnd);
        int n5 = this.findPointBefore(d);
        if (n5 == n4) {
            if (n < 0) {
                this.setSelection(0, 0);
            }
        } else if (n5 == n4 + 1) {
            this.setSelection(n5 + 1, n5 + 1);
        } else if (n5 > n4 + 1) {
            this.setSelection(n4 + 1, n5 + 1);
        }
        this.rangeStart = -1;
        this.rangeEnd = -1;
        this.fireObjectEdited();
    }

    private void clickDownPoints(boolean bl, int n, int n2) {
        this.dragIndex = -1;
        double d = this.convertGXtoWX(n);
        double d2 = this.convertGYtoWY(n2);
        double d3 = this.convertGXtoWX(this.radius + 2) - this.convertGXtoWX(0);
        double d4 = this.convertGYtoWY(0) - this.convertGYtoWY(this.radius + 2);
        int n3 = this.pickPoint(d, d3, d2, d4);
        if (bl) {
            if (n3 >= 0) {
                this.points.removePoint(n3);
                this.repaint();
            }
        } else if (n3 < 0) {
            if (this.points.size() < this.maxPoints) {
                n3 = this.findPointBefore(d);
                this.dragIndex = n3 + 1;
                if (n3 == this.points.size() - 1) {
                    this.points.add(d - this.xBefore, d2);
                } else {
                    this.points.insert(this.dragIndex, d - this.xBefore, d2);
                }
                this.dragLowLimit = this.xBefore;
                this.dragHighLimit = d + (this.maximumXRange - this.points.getTotalDuration());
                this.repaint();
            }
        } else {
            this.dragIndex = n3;
            this.dragLowLimit = this.dragIndex <= 0 ? 0.0 : this.xPicked - this.points.getPoint(this.dragIndex)[0];
            this.dragHighLimit = this.xPicked + (this.maximumXRange - this.points.getTotalDuration());
        }
        if (this.dragIndex >= 0) {
            this.draggedPoint = this.points.getPoint(this.dragIndex);
        }
    }

    private void dragPoint(int n, int n2) {
        if (this.dragIndex < 0) {
            return;
        }
        double d = this.convertGXtoWX(n);
        if (d < this.dragLowLimit) {
            d = this.dragLowLimit;
        } else if (d > this.dragHighLimit) {
            d = this.dragHighLimit;
        }
        this.draggedPoint[0] = d - this.dragLowLimit;
        double d2 = this.convertGYtoWY(n2);
        this.draggedPoint[1] = d2 = this.clipWorldY(d2);
        this.dragWY = d2;
        this.dragWX = d;
        this.points.setDirty(true);
        this.repaint();
    }

    private void clickUpPoints(int n, int n2) {
        this.dragPoint(n, n2);
        this.fireObjectEdited();
        this.dragIndex = -1;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.points == null) {
            return;
        }
        if (this.mode == 0) {
            this.dragPoint(n, n2);
        } else {
            this.dragRange(n, n2);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.points == null) {
            return;
        }
        if (this.mode == 0) {
            this.clickDownPoints(mouseEvent.isShiftDown(), n, n2);
        } else {
            this.clickDownRange(mouseEvent.isShiftDown(), n, n2);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.points == null) {
            return;
        }
        if (this.mode == 0) {
            this.clickUpPoints(n, n2);
        } else {
            this.clickUpRange(n, n2);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void drawRange(Graphics graphics) {
        if (this.rangeStart >= 0) {
            int n = this.getHeight();
            int n2 = 0;
            int n3 = 0;
            if (this.rangeEnd < this.rangeStart) {
                n2 = this.rangeEnd;
                n3 = this.rangeStart;
            } else {
                n2 = this.rangeStart;
                n3 = this.rangeEnd;
            }
            graphics.setColor(this.rangeColor);
            graphics.fillRect(n2, 0, n3 - n2, n);
        }
    }

    private void drawUnderSelection(Graphics graphics, int n, int n2) {
        if (n >= 0) {
            int n3 = this.getHeight();
            int n4 = 0;
            int n5 = this.radius;
            double d = 0.0;
            for (int i = 0; i <= n2 - 1; ++i) {
                double[] dArray = (double[])this.points.elementAt(i);
                d += dArray[0];
                if (n == i + 1) {
                    n4 = this.convertWXtoGX(d) + this.radius;
                }
                if (n2 != i + 1) continue;
                n5 = this.convertWXtoGX(d) + this.radius;
            }
            if (n4 == n5) {
                n4 -= this.radius;
            }
            graphics.fillRect(n4, 0, n5 - n4, n3);
        }
    }

    private void drawSelections(Graphics graphics) {
        int n = this.points.getSustainBegin();
        int n2 = this.points.getSustainEnd();
        int n3 = this.points.getReleaseBegin();
        int n4 = this.points.getReleaseEnd();
        graphics.setColor(this.sustainColor);
        this.drawUnderSelection(graphics, n, n2);
        graphics.setColor(this.releaseColor);
        this.drawUnderSelection(graphics, n3, n4);
        if (n2 >= n3) {
            int n5 = n4 < n2 ? n4 : n2;
            graphics.setColor(this.overlapColor);
            this.drawUnderSelection(graphics, n3, n5);
        }
    }

    public void drawUnderlay(Graphics graphics) {
        if (this.dragIndex < 0) {
            this.drawSelections(graphics);
            this.drawRange(graphics);
        }
        if (this.verticalBarsEnabled) {
            this.drawVerticalBars(graphics);
        }
    }

    public void setVerticalBarsEnabled(boolean bl) {
        this.verticalBarsEnabled = bl;
    }

    public boolean areVerticalBarsEnabled() {
        return this.verticalBarsEnabled;
    }

    public void setVerticalBarSpacing(double d) {
        this.verticalBarSpacing = d;
    }

    public double getVerticalBarSpacing() {
        return this.verticalBarSpacing;
    }

    private void drawVerticalBars(Graphics graphics) {
        int n;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        double d = this.verticalBarSpacing;
        graphics.setColor(Color.lightGray);
        while ((n = this.convertWXtoGX(d)) <= n2) {
            graphics.drawLine(n, 0, n, n3);
            d += this.verticalBarSpacing;
        }
    }

    public void drawPoints(Graphics graphics, Color color) {
        double d = 0.0;
        int n = 0;
        int n2 = this.getHeight();
        for (int i = 0; i < this.points.size(); ++i) {
            double[] dArray = (double[])this.points.elementAt(i);
            double d2 = dArray[1];
            int n3 = this.convertWXtoGX(d += dArray[0]);
            int n4 = this.convertWYtoGY(d2);
            if (i == 0) {
                graphics.setColor(this.isEnabled() ? this.firstLineColor : this.firstLineColor.darker());
                graphics.drawLine(n, n2, n3, n4);
                graphics.setColor(this.isEnabled() ? color : color.darker());
            } else if (i > 0) {
                graphics.drawLine(n, n2, n3, n4);
            }
            int n5 = 2 * this.radius + 1;
            graphics.fillOval(n3 - this.radius, n4 - this.radius, n5, n5);
            n = n3;
            n2 = n4;
        }
    }

    public void drawAllPoints(Graphics graphics) {
        this.drawPoints(graphics, this.getForeground());
    }

    @Override
    public void paint(Graphics graphics) {
        double d = 0.0;
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(this.isEnabled() ? this.getBackground() : this.getBackground().darker());
        graphics.fillRect(0, 0, n, n2);
        if (this.points == null) {
            graphics.setColor(this.getForeground());
            graphics.drawString("No EnvelopePoints", 10, 30);
            return;
        }
        if (this.points.size() > 0) {
            double d2;
            d = this.points.getTotalDuration();
            double d3 = d + (d2 = this.convertGXtoWX(this.radius) - this.getMinWorldX());
            if (d3 > this.getMaxWorldX()) {
                if (d > this.maximumXRange) {
                    d3 = this.maximumXRange;
                }
                this.setMaxWorldX(d3);
            } else if (d < this.getMaxWorldX() * 0.7) {
                double d4 = d / 0.7001;
                if (d4 < this.minimumXRange) {
                    d4 = this.minimumXRange;
                }
                this.setMaxWorldX(d4);
            }
        }
        this.drawUnderlay(graphics);
        this.drawAllPoints(graphics);
        graphics.drawString(this.points.getName() + ", len=" + String.format("%7.3f", d), 5, 15);
        if (this.draggedPoint != null && this.dragIndex >= 0) {
            String string = "i=" + this.dragIndex + ", dur=" + String.format("%7.3f", this.draggedPoint[0]) + ", y = " + String.format("%8.4f", this.draggedPoint[1]);
            graphics.drawString(string, 5, 30);
        }
    }

    public static interface EditListener {
        public void objectEdited(Object var1, Object var2);
    }
}

