/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.ports.PortBlockPart;
import com.jsyn.ports.UnitBlockPort;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.UnitGenerator;
import java.io.PrintStream;

public class InputMixingBlockPart
extends PortBlockPart {
    private double[] mixer = new double[8];
    private double current;
    private UnitInputPort unitInputPort;

    InputMixingBlockPart(UnitInputPort unitInputPort, double d) {
        super(unitInputPort, d);
        this.unitInputPort = unitInputPort;
    }

    @Override
    public double getValue() {
        return this.current;
    }

    @Override
    protected void setValue(double d) {
        this.current = d;
        super.setValue(d);
    }

    @Override
    public double[] getValues() {
        double[] dArray;
        int n = this.getConnectionCount();
        if (n == 0) {
            dArray = super.getValues();
        } else {
            int n2;
            PortBlockPart portBlockPart;
            double[] dArray2;
            int n3 = 0;
            if (this.unitInputPort.isValueAdded()) {
                dArray2 = super.getValues();
                n3 = 0;
            } else {
                portBlockPart = this.getConnection(n3);
                dArray2 = portBlockPart.getValues();
                n3 = 1;
            }
            for (n2 = 0; n2 < this.mixer.length; ++n2) {
                this.mixer[n2] = dArray2[n2];
            }
            while (n3 < n) {
                portBlockPart = this.getConnection(n3);
                dArray2 = portBlockPart.getValues();
                for (n2 = 0; n2 < this.mixer.length; ++n2) {
                    int n4 = n2;
                    this.mixer[n4] = this.mixer[n4] + dArray2[n2];
                }
                ++n3;
            }
            dArray = this.mixer;
        }
        this.current = dArray[0];
        return dArray;
    }

    private void printIndentation(PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            printStream.print("    ");
        }
    }

    private String portToString(UnitBlockPort unitBlockPort) {
        UnitGenerator unitGenerator = unitBlockPort.getUnitGenerator();
        return unitGenerator.getClass().getSimpleName() + "." + unitBlockPort.getName();
    }

    public void printConnections(PrintStream printStream, int n) {
        for (int i = 0; i < this.getConnectionCount(); ++i) {
            PortBlockPart portBlockPart = this.getConnection(i);
            this.printIndentation(printStream, n);
            printStream.println(this.portToString(this.getPort()) + " <--- " + this.portToString(portBlockPart.getPort()));
            portBlockPart.getPort().getUnitGenerator().printConnections(printStream, n + 1);
        }
    }
}

