/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTException;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JFrame;
import processing.awt.PSurfaceAWT;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PSurface;
import processing.data.Table;
import processing.data.TableRow;
import processing.event.MouseEvent;
import processing.sound.SoundFile;

public class AbilityTimer
extends PApplet {
    final String AppName = "AbilityTimer";
    final String AppVersion = "0.76";
    final String SaveFileName = "save.csv";
    final String ChimeFileName = "chime.mp3";
    final String JoinedFileName = "joined.mp3";
    ArrayList<GuiItem> timerModeItems = new ArrayList();
    ArrayList<GuiItem> checklistModeItems = new ArrayList();
    ArrayList<Mission> missions = new ArrayList();
    Scouter scouter;
    long prevEpochSecond = 0L;
    int toggle = 0;
    int prevMouseX = 0;
    int prevMouseY = 0;
    OcrEngine OcrEnhLv;
    OcrEngine OcrEnhNext;
    OcrEngine OcrInfoLv;
    OcrEngine OcrInfoNext;
    OcrEngine OcrPlayers;
    OcrEngine OcrV;
    OcrEngine OcrSkillLv;
    OcrEngine OcrSkillNext;
    static final short[] AccessoryNextExpTable;
    static final int[] AccessoryBaitExpTable;
    static final int[] TempoWeaponNextExpTable;
    static final float[] DmmGemTimeTable;
    static final float[] NutakuGemTimeTable;

    static {
        short[] sArray = new short[50];
        sArray[1] = 10;
        sArray[2] = 15;
        sArray[3] = 20;
        sArray[4] = 25;
        sArray[5] = 30;
        sArray[6] = 35;
        sArray[7] = 40;
        sArray[8] = 45;
        sArray[9] = 50;
        sArray[10] = 55;
        sArray[11] = 60;
        sArray[12] = 65;
        sArray[13] = 70;
        sArray[14] = 75;
        sArray[15] = 80;
        sArray[16] = 85;
        sArray[17] = 90;
        sArray[18] = 95;
        sArray[19] = 100;
        sArray[20] = 120;
        sArray[21] = 140;
        sArray[22] = 160;
        sArray[23] = 180;
        sArray[24] = 200;
        sArray[25] = 220;
        sArray[26] = 240;
        sArray[27] = 260;
        sArray[28] = 280;
        sArray[29] = 300;
        sArray[30] = 320;
        sArray[31] = 340;
        sArray[32] = 360;
        sArray[33] = 380;
        sArray[34] = 400;
        sArray[35] = 420;
        sArray[36] = 440;
        sArray[37] = 460;
        sArray[38] = 480;
        sArray[39] = 500;
        sArray[40] = 520;
        sArray[41] = 540;
        sArray[42] = 560;
        sArray[43] = 580;
        sArray[44] = 600;
        sArray[45] = 620;
        sArray[46] = 640;
        sArray[47] = 660;
        sArray[48] = 680;
        sArray[49] = 700;
        AccessoryNextExpTable = sArray;
        int[] nArray = new int[51];
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 5;
        nArray[6] = 7;
        nArray[7] = 9;
        nArray[8] = 12;
        nArray[9] = 15;
        nArray[10] = 18;
        nArray[11] = 22;
        nArray[12] = 26;
        nArray[13] = 30;
        nArray[14] = 35;
        nArray[15] = 40;
        nArray[16] = 45;
        nArray[17] = 57;
        nArray[18] = 69;
        nArray[19] = 81;
        nArray[20] = 95;
        nArray[21] = 109;
        nArray[22] = 123;
        nArray[23] = 139;
        nArray[24] = 155;
        nArray[25] = 171;
        nArray[26] = 189;
        nArray[27] = 207;
        nArray[28] = 225;
        nArray[29] = 245;
        nArray[30] = 265;
        nArray[31] = 285;
        nArray[32] = 318;
        nArray[33] = 351;
        nArray[34] = 384;
        nArray[35] = 420;
        nArray[36] = 456;
        nArray[37] = 492;
        nArray[38] = 531;
        nArray[39] = 570;
        nArray[40] = 609;
        nArray[41] = 651;
        nArray[42] = 693;
        nArray[43] = 735;
        nArray[44] = 780;
        nArray[45] = 825;
        nArray[46] = 870;
        nArray[47] = 934;
        nArray[48] = 998;
        nArray[49] = 1062;
        nArray[50] = 1130;
        AccessoryBaitExpTable = nArray;
        int[] nArray2 = new int[20];
        nArray2[1] = 30;
        nArray2[2] = 60;
        nArray2[3] = 90;
        nArray2[4] = 120;
        nArray2[5] = 160;
        nArray2[6] = 200;
        nArray2[7] = 250;
        nArray2[8] = 300;
        nArray2[9] = 360;
        nArray2[10] = 420;
        nArray2[11] = 490;
        nArray2[12] = 560;
        nArray2[13] = 640;
        nArray2[14] = 720;
        nArray2[15] = 810;
        nArray2[16] = 900;
        nArray2[17] = 1000;
        nArray2[18] = 1100;
        nArray2[19] = 1210;
        TempoWeaponNextExpTable = nArray2;
        DmmGemTimeTable = new float[]{12.0f, 20.0f, -1.0f, 12.5f, 21.0f, -1.0f, -1.0f, 18.0f, 21.0f, -1.0f, 19.0f, 22.0f, -1.0f, 20.0f, 23.0f, 12.0f, 18.0f, 22.0f, 12.5f, 19.0f, 23.0f};
        NutakuGemTimeTable = new float[]{12.0f, 19.0f, -1.0f, 12.5f, 19.5f, -1.0f, -1.0f, 18.0f, 22.5f, -1.0f, 19.0f, 23.0f, -1.0f, 19.5f, 23.5f, 12.0f, 18.0f, 22.0f, 12.5f, 19.0f, 23.0f};
    }

    public void settings() {
        this.size(240, 320);
    }

    public void setup() {
        this.surface.setAlwaysOnTop(true);
        PSurfaceAWT.SmoothCanvas smoothCanvas = (PSurfaceAWT.SmoothCanvas)this.surface.getNative();
        JFrame jframe = (JFrame)smoothCanvas.getFrame();
        jframe.dispose();
        jframe.setUndecorated(true);
        jframe.setVisible(true);
        this.surface.setResizable(true);
        this.smooth();
        this.xTableInitialize();
        TimerDisplay tmdisp = new TimerDisplay(20, 5);
        this.timerModeItems.add(tmdisp);
        this.timerModeItems.add(new CloseButton(110, 0));
        this.timerModeItems.add(new MinimizeButton(90, 0));
        TimerBar tmbar = new TimerBar(5, 5, tmdisp);
        this.checklistModeItems.add(tmbar);
        PFont font12 = this.loadFont("mplus-2p-bold-12.vlw");
        PFont font24 = this.loadFont("mplus-2m-bold-24.vlw");
        Glbl.setInstances(this.surface, jframe, font12, font24, new SoundFile((PApplet)this, "chime.mp3"), new SoundFile((PApplet)this, "joined.mp3"));
        Table savedTbl = this.loadTable("save.csv", "header");
        Table itemTbl = this.loadTable("Items.csv", "header");
        ZoneId zoneid = ZoneId.of("America/Los_Angeles");
        int i = 0;
        int missionNum = 0;
        for (TableRow itemRow : itemTbl.rows()) {
            String name;
            String kind = itemRow.getString("kind");
            if (kind.equals("mission")) {
                TableRow savedRow;
                name = itemRow.getString("name");
                int items = itemRow.getInt("value");
                int value = 0;
                if (savedTbl != null && i < savedTbl.getRowCount() && (savedRow = savedTbl.getRow(i)) != null) {
                    value = savedRow.getInt("value");
                    ++i;
                }
                Mission m = new Mission(5, 5 + missionNum * 29, name, items, value);
                ++missionNum;
                this.checklistModeItems.add(m);
                this.missions.add(m);
                continue;
            }
            if (!kind.equals("service") || !(name = itemRow.getString("name")).equals("DMM")) continue;
            zoneid = ZoneId.of("Asia/Tokyo");
            Glbl.setServiceProvider(ServiceProvider.Dmm);
        }
        WallClock wallc = new WallClock(zoneid);
        this.checklistModeItems.add(wallc);
        this.checklistModeItems.add(new TimerBarLabel(tmbar));
        this.checklistModeItems.add(new CloseButton(220, 0));
        this.checklistModeItems.add(new MinimizeButton(200, 0));
        this.scouter = new Scouter("AbilityTimer", "0.76");
        DrawerButton drawerb = new DrawerButton(220, 127, this.scouter);
        this.checklistModeItems.add(drawerb);
    }

    public void draw() {
        boolean changed;
        Glbl.setBgSelected(true);
        boolean bl = changed = Glbl.prevMode != Glbl.mode;
        if (changed) {
            this.background(224);
            Glbl.changeSize();
            Glbl.mustRedraw = true;
            this.prevEpochSecond = 0L;
            Glbl.prevMode = Glbl.mode;
            return;
        }
        boolean mustRedraw = false;
        ArrayList<GuiItem> gitems = this.timerModeItems;
        if (Glbl.isTimerMode()) {
            mustRedraw = true;
        } else {
            gitems = this.checklistModeItems;
            long currentEpochSecond = Instant.now().getEpochSecond();
            if (Glbl.scouterEnabled && (this.millis() & 0x200) == this.toggle) {
                this.scouter.findKamihimeWindow();
                mustRedraw = true;
                int n = this.toggle = this.toggle == 0 ? 512 : 0;
            }
            if (Glbl.mustRedraw || mustRedraw || this.mousePressed || this.pmouseX != this.mouseX || this.pmouseY != this.mouseY || Glbl.isLastOneMinute && currentEpochSecond != this.prevEpochSecond || currentEpochSecond / 60L != this.prevEpochSecond / 60L) {
                mustRedraw = true;
            }
            this.prevEpochSecond = currentEpochSecond;
        }
        Glbl.mustRedraw = false;
        if (mustRedraw) {
            this.background(224);
            for (GuiItem item : gitems) {
                item.render();
            }
        }
    }

    public void mousePressed() {
        this.prevMouseX = this.mouseX;
        this.prevMouseY = this.mouseY;
        ArrayList<GuiItem> gitems = this.timerModeItems;
        if (Glbl.isChecklistMode()) {
            gitems = this.checklistModeItems;
        }
        for (GuiItem item : gitems) {
            item.press();
        }
    }

    public void mouseReleased() {
    }

    public void mouseDragged() {
        if (Glbl.isBgSelected()) {
            Point mouse = MouseInfo.getPointerInfo().getLocation();
            this.surface.setLocation(mouse.x - this.prevMouseX, mouse.y - this.prevMouseY - 0);
        }
    }

    public void mouseWheel(MouseEvent event) {
        Glbl.mustRedraw = true;
        ArrayList<GuiItem> gitems = this.timerModeItems;
        if (Glbl.isChecklistMode()) {
            gitems = this.checklistModeItems;
        }
        for (GuiItem item : gitems) {
            item.wheel(event);
        }
    }

    public void exit() {
        Table tbl = new Table();
        tbl.addColumn("value");
        for (Mission m : this.missions) {
            TableRow row = tbl.addRow();
            row.setInt("value", m.getValue());
        }
        this.saveTable(tbl, "save.csv");
        super.exit();
    }

    public static int getR(int c) {
        return c >> 16 & 0xFF;
    }

    public static int getG(int c) {
        return c >> 8 & 0xFF;
    }

    public static int getB(int c) {
        return c & 0xFF;
    }

    public static String nfspc(int value, int width) {
        String str = AbilityTimer.nf((float)value);
        int i = str.length();
        while (i < width) {
            str = " " + str;
            ++i;
        }
        return str;
    }

    public void xTableInitialize() {
        short[][] EnhNumber = new short[][]{{60, 118, 99, 67, 67, 67, 67, 99, 102, 62}, {8, 60, 60, 12, 12, 12, 12, 12, 12, 62}, {62, 102, 3, 3, 2, 6, 12, 24, 56, 127}, {126, 102, 3, 2, 14, 30, 3, 3, 71, 126}, {6, 14, 30, 38, 38, 70, 127, 127, 6, 6}, {63, 112, 96, 96, 126, 7, 3, 3, 71, 126}, {30, 56, 32, 116, 127, 99, 99, 99, 115, 62}, {127, 3, 3, 6, 6, 12, 12, 24, 24, 48}, {62, 119, 67, 98, 62, 62, 67, 67, 99, 126}, {60, 118, 99, 67, 99, 127, 63, 2, 6, 60}};
        short[][] sArrayArray = new short[10][];
        sArrayArray[0] = new short[]{112, 508, 990, 910, 902, 775, 775, 775, 775, 775, 902, 910, 1022, 508};
        short[] sArray = new short[14];
        sArray[1] = 56;
        sArray[2] = 248;
        sArray[3] = 504;
        sArray[4] = 504;
        sArray[5] = 56;
        sArray[6] = 56;
        sArray[7] = 56;
        sArray[8] = 56;
        sArray[9] = 56;
        sArray[10] = 56;
        sArray[11] = 56;
        sArray[12] = 120;
        sArray[13] = 510;
        sArrayArray[1] = sArray;
        sArrayArray[2] = new short[]{248, 510, 414, 14, 14, 14, 14, 28, 60, 120, 224, 480, 1023, 1023};
        sArrayArray[3] = new short[]{248, 1022, 926, 14, 14, 14, 124, 124, 14, 6, 7, 526, 958, 1020};
        short[] sArray2 = new short[14];
        sArray2[1] = 60;
        sArray2[2] = 60;
        sArray2[3] = 124;
        sArray2[4] = 204;
        sArray2[5] = 140;
        sArray2[6] = 396;
        sArray2[7] = 780;
        sArray2[8] = 926;
        sArray2[9] = 1023;
        sArray2[10] = 1023;
        sArray2[11] = 12;
        sArray2[12] = 12;
        sArray2[13] = 12;
        sArrayArray[4] = sArray2;
        short[] sArray3 = new short[14];
        sArray3[1] = 510;
        sArray3[2] = 510;
        sArray3[3] = 384;
        sArray3[4] = 384;
        sArray3[5] = 448;
        sArray3[6] = 510;
        sArray3[7] = 510;
        sArray3[8] = 15;
        sArray3[9] = 7;
        sArray3[10] = 7;
        sArray3[11] = 526;
        sArray3[12] = 958;
        sArray3[13] = 1020;
        sArrayArray[5] = sArray3;
        sArrayArray[6] = new short[]{60, 254, 480, 960, 896, 896, 1022, 910, 903, 903, 903, 903, 974, 508};
        short[] sArray4 = new short[14];
        sArray4[1] = 1023;
        sArray4[2] = 1023;
        sArray4[3] = 14;
        sArray4[4] = 14;
        sArray4[5] = 28;
        sArray4[6] = 28;
        sArray4[7] = 56;
        sArray4[8] = 56;
        sArray4[9] = 112;
        sArray4[10] = 240;
        sArray4[11] = 224;
        sArray4[12] = 224;
        sArray4[13] = 448;
        sArrayArray[7] = sArray4;
        sArrayArray[8] = new short[]{120, 510, 911, 903, 903, 966, 508, 254, 927, 775, 775, 903, 975, 510};
        sArrayArray[9] = new short[]{240, 508, 926, 782, 774, 775, 903, 991, 510, 14, 14, 28, 892, 1016};
        short[][] InfoLvNumber = sArrayArray;
        short[][] InfoNextNumber = new short[][]{{124, 198, 199, 199, 199, 199, 199, 198, 126, 56}, {24, 120, 120, 24, 24, 24, 24, 24, 60, 126}, {252, 142, 6, 6, 12, 28, 48, 112, 255, 255}, {254, 142, 6, 12, 60, 6, 6, 6, 254, 120}, {12, 28, 60, 100, 196, 142, 255, 14, 4, 4}, {254, 224, 224, 224, 254, 7, 7, 135, 254, 120}, {62, 96, 192, 220, 238, 199, 199, 231, 126, 60}, {255, 7, 6, 14, 12, 28, 24, 48, 112, 96}, {126, 198, 198, 228, 124, 206, 199, 199, 254, 56}, {124, 198, 199, 199, 231, 127, 6, 6, 124, 112}};
        short[][] PlayersNumber = new short[][]{{56, 124, 198, 198, 198, 199, 199, 198, 198, 198, 124, 56}, {24, 56, 120, 24, 24, 24, 24, 24, 24, 24, 126, 126}, {56, 126, 6, 6, 6, 6, 12, 28, 56, 112, 255, 255}, {120, 254, 134, 6, 14, 60, 14, 6, 6, 134, 254, 120}, {14, 30, 30, 62, 110, 78, 206, 255, 255, 14, 14, 14}, {126, 126, 96, 96, 124, 126, 6, 7, 6, 134, 254, 120}, {30, 62, 96, 224, 252, 254, 199, 199, 199, 230, 126, 60}, {255, 255, 6, 6, 12, 12, 28, 24, 56, 48, 112, 96}, {60, 126, 198, 198, 230, 124, 126, 199, 199, 199, 254, 60}, {56, 126, 198, 198, 198, 199, 254, 118, 6, 14, 124, 112}};
        short[][] sArrayArray2 = new short[1][];
        short[] sArray5 = new short[8];
        sArray5[1] = 34;
        sArray5[2] = 34;
        sArray5[3] = 54;
        sArray5[4] = 20;
        sArray5[5] = 28;
        sArray5[6] = 28;
        sArrayArray2[0] = sArray5;
        short[][] CharV = sArrayArray2;
        short[][] sArrayArray3 = new short[10][];
        short[] sArray6 = new short[14];
        sArray6[1] = 248;
        sArray6[2] = 412;
        sArray6[3] = 780;
        sArray6[4] = 780;
        sArray6[5] = 772;
        sArray6[6] = 774;
        sArray6[7] = 774;
        sArray6[8] = 774;
        sArray6[9] = 780;
        sArray6[10] = 780;
        sArray6[11] = 780;
        sArray6[12] = 504;
        sArrayArray3[0] = sArray6;
        short[] sArray7 = new short[14];
        sArray7[1] = 48;
        sArray7[2] = 112;
        sArray7[3] = 240;
        sArray7[4] = 48;
        sArray7[5] = 48;
        sArray7[6] = 48;
        sArray7[7] = 48;
        sArray7[8] = 48;
        sArray7[9] = 48;
        sArray7[10] = 48;
        sArray7[11] = 48;
        sArray7[12] = 124;
        sArrayArray3[1] = sArray7;
        short[] sArray8 = new short[14];
        sArray8[1] = 504;
        sArray8[2] = 268;
        sArray8[3] = 6;
        sArray8[4] = 6;
        sArray8[5] = 6;
        sArray8[6] = 12;
        sArray8[7] = 12;
        sArray8[8] = 24;
        sArray8[9] = 48;
        sArray8[10] = 96;
        sArray8[11] = 448;
        sArray8[12] = 480;
        sArrayArray3[2] = sArray8;
        short[] sArray9 = new short[14];
        sArray9[1] = 508;
        sArray9[2] = 270;
        sArray9[3] = 6;
        sArray9[4] = 6;
        sArray9[5] = 12;
        sArray9[6] = 56;
        sArray9[7] = 28;
        sArray9[8] = 6;
        sArray9[9] = 6;
        sArray9[10] = 6;
        sArray9[11] = 14;
        sArray9[12] = 508;
        sArrayArray3[3] = sArray9;
        short[] sArray10 = new short[14];
        sArray10[1] = 28;
        sArray10[2] = 60;
        sArray10[3] = 60;
        sArray10[4] = 76;
        sArray10[5] = 140;
        sArray10[6] = 396;
        sArray10[7] = 268;
        sArray10[8] = 780;
        sArray10[9] = 1023;
        sArray10[10] = 12;
        sArray10[11] = 12;
        sArray10[12] = 12;
        sArrayArray3[4] = sArray10;
        short[] sArray11 = new short[14];
        sArray11[1] = 510;
        sArray11[2] = 384;
        sArray11[3] = 384;
        sArray11[4] = 384;
        sArray11[5] = 496;
        sArray11[6] = 412;
        sArray11[7] = 6;
        sArray11[8] = 6;
        sArray11[9] = 6;
        sArray11[10] = 6;
        sArray11[11] = 14;
        sArray11[12] = 508;
        sArrayArray3[5] = sArray11;
        short[] sArray12 = new short[14];
        sArray12[1] = 60;
        sArray12[2] = 192;
        sArray12[3] = 384;
        sArray12[4] = 384;
        sArray12[5] = 384;
        sArray12[6] = 478;
        sArray12[7] = 390;
        sArray12[8] = 262;
        sArray12[9] = 386;
        sArray12[10] = 390;
        sArray12[11] = 390;
        sArray12[12] = 252;
        sArrayArray3[6] = sArray12;
        short[] sArray13 = new short[14];
        sArray13[1] = 510;
        sArray13[2] = 6;
        sArray13[3] = 6;
        sArray13[4] = 12;
        sArray13[5] = 12;
        sArray13[6] = 24;
        sArray13[7] = 24;
        sArray13[8] = 48;
        sArray13[9] = 48;
        sArray13[10] = 96;
        sArray13[11] = 96;
        sArray13[12] = 192;
        sArrayArray3[7] = sArray13;
        short[] sArray14 = new short[14];
        sArray14[1] = 252;
        sArray14[2] = 390;
        sArray14[3] = 390;
        sArray14[4] = 390;
        sArray14[5] = 452;
        sArray14[6] = 252;
        sArray14[7] = 220;
        sArray14[8] = 262;
        sArray14[9] = 774;
        sArray14[10] = 774;
        sArray14[11] = 390;
        sArray14[12] = 508;
        sArrayArray3[8] = sArray14;
        short[] sArray15 = new short[14];
        sArray15[1] = 248;
        sArray15[2] = 396;
        sArray15[3] = 262;
        sArray15[4] = 774;
        sArray15[5] = 774;
        sArray15[6] = 902;
        sArray15[7] = 462;
        sArray15[8] = 254;
        sArray15[9] = 6;
        sArray15[10] = 4;
        sArray15[11] = 12;
        sArray15[12] = 504;
        sArrayArray3[9] = sArray15;
        short[][] SkillLvNumber = sArrayArray3;
        this.OcrEnhNext = this.OcrEnhLv = new OcrEngine(EnhNumber, 8, 10, 0.8f, 25);
        this.OcrInfoLv = new OcrEngine(InfoLvNumber, 10, 14, 0.8f, 15);
        this.OcrInfoNext = new OcrEngine(InfoNextNumber, 8, 10, 0.8f, 25);
        this.OcrPlayers = new OcrEngine(PlayersNumber, 9, 12, 0.8f, 25);
        this.OcrV = new OcrEngine(CharV, 8, 8, 0.8f, 21);
        this.OcrSkillLv = new OcrEngine(SkillLvNumber, 10, 14, 0.8f, 25);
        this.OcrSkillNext = new OcrEngine(EnhNumber, 8, 10, 0.8f, 34);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"AbilityTimer"};
        if (passedArgs != null) {
            PApplet.main((String[])AbilityTimer.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class AcceConstant {
        String str;
        int maxLv;
        int r;
        int g;
        int b;
        int exp;

        AcceConstant(String _str, int _maxLv, int _r, int _g, int _b, int _exp) {
            this.str = _str;
            this.maxLv = _maxLv;
            this.r = _r;
            this.g = _g;
            this.b = _b;
            this.exp = _exp;
        }
    }

    class AccePosition {
        int offsetX;
        int offsetY;
        int w;
        int h;
        int rarelityX;
        int rarelityY;
        int levelX;
        int levelY;
        int between;
        int nextX;
        int nextY;

        AccePosition(int _offsetX, int _offsetY, int _w, int _h, int _rarelityX, int _rarelityY, int _levelX, int _levelY, int _between, int _nextX, int _nextY) {
            this.offsetX = _offsetX;
            this.offsetY = _offsetY;
            this.w = _w;
            this.h = _h;
            this.rarelityX = _rarelityX;
            this.rarelityY = _rarelityY;
            this.levelX = _levelX;
            this.levelY = _levelY;
            this.between = _between;
            this.nextX = _nextX;
            this.nextY = _nextY;
        }
    }

    class AcceRow
    extends GuiItem {
        StrValuebox elemBox;
        StrValuebox rareBox;
        Valuebox lvBox;
        Valuebox numBox;
        ArrayList<GuiItem> gitems;
        int x;
        int y;
        final int delta_y = 29;

        AcceRow(int _x, int _y, int _initialElem, int _initialRare) {
            this.delta_y = 29;
            this.x = _x;
            this.y = _y;
            String[] elem = new String[]{"Same", "Diff"};
            String[] rare = new String[]{"N", "R", "SR", "SSR"};
            int[] lvThresholds = new int[]{20, 30, 40, 50};
            this.elemBox = new StrValuebox(this.x + 0, this.y, elem, _initialElem);
            this.lvBox = new Valuebox(this.x + 90, this.y, 1, 99, 50);
            this.rareBox = new StrValuebox(this.x + 45, this.y, rare, _initialRare, this.lvBox, lvThresholds);
            this.numBox = new Valuebox(this.x + 170, this.y, 0, 20, 99);
            this.gitems = new ArrayList();
            this.gitems.add(this.elemBox);
            this.gitems.add(this.rareBox);
            this.gitems.add(this.lvBox);
            this.gitems.add(this.numBox);
        }

        public boolean isCurrent() {
            for (GuiItem item : this.gitems) {
                if (!item.isOver()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void render() {
            for (GuiItem item : this.gitems) {
                item.render();
            }
            AbilityTimer.this.textFont(Glbl.font24);
            AbilityTimer.this.textSize(16.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text(AbilityTimer.nfspc(this.getExp(), 5), this.x + 245, this.y + 16);
        }

        @Override
        public void press() {
            for (GuiItem item : this.gitems) {
                item.press();
            }
        }

        @Override
        public void wheel(MouseEvent event) {
            for (GuiItem item : this.gitems) {
                item.wheel(event);
            }
        }

        public int getItems() {
            return this.numBox.getValue();
        }

        public int getExp() {
            int exp = 400;
            exp >>= 3 - this.rareBox.getValue();
            exp += AccessoryBaitExpTable[this.lvBox.getValue()];
            if (this.elemBox.getValue() == 0) {
                exp += exp + 1 >> 1;
            }
            return exp * this.numBox.getValue();
        }
    }

    class AcceTotal {
        final int[] initialElem;
        final int[] initialRare;
        AcceRow[] ar;
        AllClearButton ac;

        AcceTotal() {
            int[] nArray = new int[8];
            nArray[4] = 1;
            nArray[5] = 1;
            nArray[6] = 1;
            nArray[7] = 1;
            this.initialElem = nArray;
            int[] nArray2 = new int[8];
            nArray2[0] = 3;
            nArray2[1] = 2;
            nArray2[2] = 1;
            nArray2[4] = 3;
            nArray2[5] = 2;
            nArray2[6] = 1;
            this.initialRare = nArray2;
            this.ar = new AcceRow[this.initialElem.length];
            this.ac = new AllClearButton(480, 275);
            this.allClear();
        }

        public void allClear() {
            int i = 0;
            while (i < this.initialElem.length) {
                this.ar[i] = new AcceRow(470, 102 + i * 21, this.initialElem[i], this.initialRare[i]);
                ++i;
            }
        }

        public void render(AcceConstant acce, int level, int nextExp) {
            int expToMax = Glbl.calculateExpToMax(acce.maxLv, level, nextExp);
            int piledExp = Glbl.calculatePiledExp(level, nextExp, acce.maxLv);
            AbilityTimer.this.textFont(Glbl.font24);
            AbilityTimer.this.textSize(16.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text(acce.str, 470.0f, 20.0f);
            AbilityTimer.this.text("Lv   " + AbilityTimer.nfspc(level, 3), 470.0f, 35.0f);
            AbilityTimer.this.text("NEXT " + AbilityTimer.nfspc(nextExp, 3), 470.0f, 50.0f);
            AbilityTimer.this.text("to  Lv" + AbilityTimer.nf((float)acce.maxLv) + ": " + (expToMax > 0 ? String.valueOf(AbilityTimer.nfspc(expToMax, 5)) + "exp" : "-"), 470.0f, 65.0f);
            int exp = acce.exp;
            exp += AccessoryBaitExpTable[level];
            exp += exp + 1 >> 1;
            AbilityTimer.this.text("as a bait: " + AbilityTimer.nfspc(exp, 4) + "exp", 470.0f, 80.0f);
            AbilityTimer.this.textFont(Glbl.font12);
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.text("Elem    Rare    Lv                Items", 475.0f, 97.0f);
            int items = 0;
            int total = 0;
            AcceRow[] acceRowArray = this.ar;
            int n = this.ar.length;
            int n2 = 0;
            while (n2 < n) {
                AcceRow row = acceRowArray[n2];
                row.render();
                items += row.getItems();
                total += row.getExp();
                ++n2;
            }
            this.ac.render();
            if (total > 0) {
                AbilityTimer.this.stroke(0.0f, 255.0f, 0.0f);
                AbilityTimer.this.strokeWeight(2.0f);
                AbilityTimer.this.fill(224);
                AbilityTimer.this.triangle(617.0f, 38.0f, 635.0f, 50.0f, 617.0f, 62.0f);
                int[] enhanced = Glbl.calculateLvFromExp(piledExp + total * 2);
                int enhancedLv = enhanced[0];
                int enhancedNext = enhanced[1];
                if (enhancedLv >= acce.maxLv) {
                    enhancedLv = acce.maxLv;
                    enhancedNext = 0;
                }
                AbilityTimer.this.fill(96);
                AbilityTimer.this.textFont(Glbl.font24);
                AbilityTimer.this.textSize(16.0f);
                AbilityTimer.this.text("  Super Lv   " + AbilityTimer.nfspc(enhancedLv, 3), 640.0f, 20.0f);
                AbilityTimer.this.textSize(14.0f);
                AbilityTimer.this.text("NEXT " + AbilityTimer.nfspc(enhancedNext, 4), 705.0f, 35.0f);
                enhanced = Glbl.calculateLvFromExp(piledExp + total);
                enhancedLv = enhanced[0];
                enhancedNext = enhanced[1];
                if (enhancedLv >= acce.maxLv) {
                    enhancedLv = acce.maxLv;
                    enhancedNext = 0;
                }
                AbilityTimer.this.fill(0);
                AbilityTimer.this.textSize(16.0f);
                AbilityTimer.this.text("Success Lv   ", 640.0f, 50.0f);
                AbilityTimer.this.fill(0.0f, enhancedLv == acce.maxLv ? 255 : 0, 0.0f);
                AbilityTimer.this.text("             " + AbilityTimer.nfspc(enhancedLv, 3), 640.0f, 50.0f);
                AbilityTimer.this.textSize(14.0f);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text("NEXT " + AbilityTimer.nfspc(enhancedNext, 4), 705.0f, 65.0f);
                exp = acce.exp;
                exp += AccessoryBaitExpTable[enhancedLv];
                exp += exp + 1 >> 1;
                AbilityTimer.this.textSize(16.0f);
                AbilityTimer.this.text("as a bait: " + AbilityTimer.nfspc(exp, 4) + "exp", 648.0f, 80.0f);
            }
            AbilityTimer.this.textFont(Glbl.font12);
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text("Total", 594.0f, 286.0f);
            AbilityTimer.this.textFont(Glbl.font24);
            AbilityTimer.this.textSize(16.0f);
            AbilityTimer.this.fill(items > 20 ? 255 : 0, 0.0f, 0.0f);
            AbilityTimer.this.text(AbilityTimer.nfspc(items, 2), 645.0f, 286.0f);
            AbilityTimer.this.fill(0.0f, total >= expToMax ? 255 : 0, 0.0f);
            AbilityTimer.this.text(AbilityTimer.nfspc(total, 5), 715.0f, 286.0f);
        }

        public void press() {
            AcceRow[] acceRowArray = this.ar;
            int n = this.ar.length;
            int n2 = 0;
            while (n2 < n) {
                AcceRow row = acceRowArray[n2];
                row.press();
                ++n2;
            }
            if (this.ac.isOver()) {
                this.allClear();
            }
        }

        public void wheel(MouseEvent event) {
            AcceRow[] acceRowArray = this.ar;
            int n = this.ar.length;
            int n2 = 0;
            while (n2 < n) {
                AcceRow row = acceRowArray[n2];
                row.wheel(event);
                ++n2;
            }
        }
    }

    class AllClearButton
    extends GuiItem {
        static final int W = 30;
        static final int H = 20;

        AllClearButton(int _x, int _y) {
            super(_x, _y, 30, 20);
        }

        @Override
        public void render() {
            AbilityTimer.this.strokeWeight(1.0f);
            if (this.isOver()) {
                AbilityTimer.this.fill(255.0f, 32.0f, 32.0f);
            } else {
                AbilityTimer.this.fill(255.0f, 96.0f, 96.0f);
            }
            AbilityTimer.this.rect(this.x, this.y, 29.0f, 19.0f);
            AbilityTimer.this.fill(255.0f, 255.0f, 255.0f);
            AbilityTimer.this.textFont(Glbl.font24);
            AbilityTimer.this.textSize(16.0f);
            AbilityTimer.this.text("AC", this.x + 7, this.y + 16);
        }
    }

    static enum AppMode {
        Checklist,
        Timer;

    }

    class Checkbox
    extends GuiItem {
        boolean checked;
        static final int W = 20;
        static final int H = 20;

        Checkbox(int _x, int _y, boolean _checked) {
            super(_x, _y, 20, 20);
            this.checked = _checked;
        }

        @Override
        public void render() {
            AbilityTimer.this.stroke(0);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(this.isOver() ? 224 : 255);
            AbilityTimer.this.rect(this.x, this.y, 19.0f, 19.0f);
            if (this.checked) {
                AbilityTimer.this.stroke(255.0f, 0.0f, 0.0f);
                AbilityTimer.this.strokeWeight(2.0f);
                AbilityTimer.this.line(this.x + 2, this.y + 10, this.x + 10, this.y + 15);
                AbilityTimer.this.line(this.x + 10, this.y + 15, this.x + 17, this.y + 3);
            }
        }

        @Override
        public void press() {
            if (this.isOver()) {
                this.checked = !this.checked;
            }
        }

        public boolean get() {
            return this.checked;
        }

        public void set() {
            this.checked = true;
        }

        public void reset() {
            this.checked = false;
        }
    }

    class CloseButton
    extends GuiItem {
        static final int W = 20;
        static final int H = 20;

        CloseButton(int _x, int _y) {
            super(_x, _y, 20, 20);
        }

        @Override
        public void render() {
            AbilityTimer.this.noStroke();
            AbilityTimer.this.fill(this.isOver() ? 255 : 224);
            AbilityTimer.this.rect(this.x, this.y, 19.0f, 19.0f);
            AbilityTimer.this.stroke(this.isOver() ? 0 : 64);
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.line(this.x + 3, this.y + 3, this.x + 16, this.y + 16);
            AbilityTimer.this.line(this.x + 3, this.y + 16, this.x + 16, this.y + 3);
        }

        @Override
        public void press() {
            if (this.isOver()) {
                AbilityTimer.this.exit();
            }
        }
    }

    class DrawerButton
    extends GuiItem {
        Scouter scouter;
        static final int W = 20;
        static final int H = 40;

        DrawerButton(int _x, int _y, Scouter _scouter) {
            super(_x, _y, 20, 40);
            this.scouter = _scouter;
        }

        @Override
        public void render() {
            AbilityTimer.this.noStroke();
            AbilityTimer.this.fill(this.isOver() ? 64 : 0);
            AbilityTimer.this.rect(this.x, this.y, 19.0f, 39.0f);
            AbilityTimer.this.stroke(this.isOver() ? 0 : 64);
            AbilityTimer.this.strokeWeight(2.0f);
            if (Glbl.scouterEnabled) {
                AbilityTimer.this.line(this.x + 16, this.y + 3, this.x + 3, this.y + 19);
                AbilityTimer.this.line(this.x + 3, this.y + 20, this.x + 16, this.y + 36);
                this.scouter.render();
            } else {
                AbilityTimer.this.line(this.x + 3, this.y + 3, this.x + 16, this.y + 19);
                AbilityTimer.this.line(this.x + 16, this.y + 20, this.x + 3, this.y + 36);
            }
        }

        @Override
        public void press() {
            if (this.isOver()) {
                if (!Glbl.scouterEnabled) {
                    if (this.scouter.initialize()) {
                        Glbl.scouterEnabled = true;
                        Glbl.changeSize();
                    }
                } else {
                    Glbl.scouterEnabled = false;
                    Glbl.changeSize();
                }
            }
            if (Glbl.scouterEnabled) {
                this.scouter.press();
            }
        }

        @Override
        public void wheel(MouseEvent event) {
            if (Glbl.scouterEnabled) {
                this.scouter.wheel(event);
            }
        }
    }

    static class Glbl {
        static final int W = 240;
        static final int H = 320;
        static final int TimerW = 130;
        static final int TimerH = 100;
        static AppMode mode = AppMode.Checklist;
        static AppMode prevMode = AppMode.Timer;
        static ServiceProvider provider = ServiceProvider.Nutaku;
        static boolean isLastOneMinute = false;
        static boolean scouterEnabled = false;
        static boolean bgSelected = false;
        static boolean mustRedraw = false;
        static PSurface ps;
        static JFrame jf;
        static PFont font12;
        static PFont font24;
        static SoundFile chime;
        static SoundFile joined;
        static boolean DebugOcr;
        static boolean DebugHp;

        static {
            DebugOcr = false;
            DebugHp = false;
        }

        Glbl() {
        }

        public static void setInstances(PSurface _ps, JFrame _jf, PFont _f12, PFont _f24, SoundFile _chime, SoundFile _joined) {
            ps = _ps;
            jf = _jf;
            font12 = _f12;
            font24 = _f24;
            chime = _chime;
            joined = _joined;
        }

        public static boolean isTimerMode() {
            return mode == AppMode.Timer;
        }

        public static boolean isChecklistMode() {
            return mode == AppMode.Checklist;
        }

        public static void setServiceProvider(ServiceProvider _provider) {
            provider = _provider;
        }

        public static boolean isDmm() {
            return provider == ServiceProvider.Dmm;
        }

        public static void changeSize() {
            if (Glbl.isTimerMode()) {
                jf.setOpacity(0.5f);
                ps.setSize(130, 100);
            } else if (scouterEnabled) {
                jf.setOpacity(1.0f);
                ps.setSize(840, 320);
            } else {
                jf.setOpacity(0.75f);
                ps.setSize(240, 320);
            }
        }

        public static void setBgSelected(boolean value) {
            bgSelected = value;
        }

        public static boolean isBgSelected() {
            return bgSelected;
        }

        public static int countHotbits(int value) {
            int result = 0;
            while (value > 0) {
                if ((value & 1) == 1) {
                    ++result;
                }
                value >>>= 1;
            }
            return result;
        }

        public static int calculateExpToMax(int maxLevel, int level, int nextExp) {
            int result = 0;
            if (level != maxLevel) {
                int lv = level + 1;
                while (lv <= maxLevel - 1) {
                    result += AccessoryNextExpTable[lv];
                    ++lv;
                }
                result += nextExp;
            }
            return result;
        }

        public static int calculatePiledExp(int nowLevel, int nextExp, int maxLv) {
            int result = 0;
            int lv = 1;
            while (lv <= nowLevel - 1) {
                result += AccessoryNextExpTable[lv];
                ++lv;
            }
            if (nowLevel < maxLv) {
                result += AccessoryNextExpTable[nowLevel] - nextExp;
            }
            return result;
        }

        public static int[] calculateLvFromExp(int exp) {
            int total = 0;
            int lv = 1;
            while (lv < AccessoryNextExpTable.length) {
                if (exp < (total += AccessoryNextExpTable[lv])) break;
                ++lv;
            }
            int next = total - exp;
            if (next < 0) {
                next = 0;
            }
            int[] tmp = new int[]{lv, next};
            return tmp;
        }

        public static int calcWeaponExp(int rare, int level) {
            int exp = 0;
            switch (rare) {
                case 0: {
                    exp = 10;
                    break;
                }
                case 1: {
                    exp = 35;
                    break;
                }
                case 2: {
                    exp = 100;
                    break;
                }
                case 3: {
                    exp = 20;
                    break;
                }
                case 4: {
                    exp = 50;
                    break;
                }
                case 5: {
                    exp = 0;
                    break;
                }
            }
            exp *= level;
            switch (rare) {
                case 2: {
                    exp += 250;
                    break;
                }
                case 5: {
                    exp += 1500;
                    break;
                }
            }
            return exp;
        }

        public static int calcWeaponExpToMax(WeaponConstant weap, int nowLevel, int nextExp) {
            int result = 0;
            if (nowLevel != weap.maxLv) {
                int lv = nowLevel + 1;
                while (lv <= weap.maxLv - 1) {
                    int exp = 0;
                    switch (weap.rare) {
                        case 0: {
                            exp = 5;
                            break;
                        }
                        case 1: {
                            exp = 10;
                            break;
                        }
                        case 2: {
                            exp = 20;
                            break;
                        }
                    }
                    result += exp * lv;
                    ++lv;
                }
                result += nextExp;
            }
            return result;
        }

        public static int calcWeaponPiledExp(WeaponConstant weap, int nowLevel, int nextExp) {
            int result = 0;
            int lv = 1;
            while (lv <= nowLevel) {
                int exp = 0;
                switch (weap.rare) {
                    case 0: {
                        exp = 5;
                        break;
                    }
                    case 1: {
                        exp = 10;
                        break;
                    }
                    case 2: {
                        exp = 20;
                        break;
                    }
                }
                result += exp * lv;
                ++lv;
            }
            return result -= nextExp;
        }

        public static int[] calcWeaponLvFromExp(WeaponConstant weap, int exp) {
            int total = 0;
            int lv = 1;
            while (lv <= 30) {
                int tmp = 0;
                switch (weap.rare) {
                    case 0: {
                        tmp = 5;
                        break;
                    }
                    case 1: {
                        tmp = 10;
                        break;
                    }
                    case 2: {
                        tmp = 20;
                        break;
                    }
                }
                if (exp < (total += tmp * lv)) break;
                ++lv;
            }
            int next = total - exp;
            if (next < 0) {
                next = 0;
            }
            int[] tmp = new int[]{lv, next};
            return tmp;
        }

        public static int averageOfImage(PImage img) {
            int r = 0;
            int g = 0;
            int b = 0;
            int w = img.width;
            int h = img.height;
            int i = 0;
            while (i < w * h) {
                int c = img.pixels[i];
                r += AbilityTimer.getR(c);
                g += AbilityTimer.getG(c);
                b += AbilityTimer.getB(c);
                ++i;
            }
            return ((r /= w * h) << 16) + ((g /= w * h) << 8) + (b /= w * h);
        }
    }

    class GuiItem {
        int x;
        int y;
        int itemWidth;
        int itemHeight;

        GuiItem(int _x, int _y, int _itemWidth, int _itemHeight) {
            this.x = _x;
            this.y = _y;
            this.itemWidth = _itemWidth;
            this.itemHeight = _itemHeight;
        }

        GuiItem(int _x, int _y) {
            this(_x, _y, 0, 0);
        }

        GuiItem() {
            this(0, 0, 0, 0);
        }

        public void render() {
        }

        public void press() {
        }

        public void wheel(MouseEvent event) {
        }

        public boolean isOver() {
            int windowX = Glbl.jf.getX();
            int windowY = Glbl.jf.getY();
            int maxX = windowX + 240 + (Glbl.scouterEnabled ? 600 : 0);
            int maxY = windowY + 320;
            boolean rc = false;
            PointerInfo info = MouseInfo.getPointerInfo();
            if (info != null) {
                Point mouse = info.getLocation();
                if (windowX <= mouse.x && mouse.x < maxX && windowY <= mouse.y && mouse.y < maxY) {
                    int mx = AbilityTimer.this.mouseX;
                    int my = AbilityTimer.this.mouseY;
                    boolean bl = rc = this.x <= mx && mx < this.x + this.itemWidth && this.y <= my && my < this.y + this.itemHeight;
                }
            }
            if (rc) {
                Glbl.setBgSelected(false);
            }
            return rc;
        }
    }

    class LabeledButton
    extends GuiItem {
        static final int W = 20;
        static final int H = 20;
        String label;
        Valuebox box;

        LabeledButton(int _x, int _y, String _label, Valuebox _box) {
            super(_x, _y, 20, 20);
            this.label = _label;
            this.box = _box;
        }

        @Override
        public void render() {
            AbilityTimer.this.stroke(64);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(this.isOver() ? 180 : 200);
            AbilityTimer.this.rect(this.x, this.y, 19.0f, 19.0f);
            AbilityTimer.this.textFont(Glbl.font24);
            AbilityTimer.this.textSize(24.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text(this.label, this.x + 4, this.y + 16);
        }
    }

    class MinimizeButton
    extends GuiItem {
        static final int W = 20;
        static final int H = 20;

        MinimizeButton(int _x, int _y) {
            super(_x, _y, 20, 20);
        }

        @Override
        public void render() {
            AbilityTimer.this.noStroke();
            AbilityTimer.this.fill(this.isOver() ? 255 : 224);
            AbilityTimer.this.rect(this.x, this.y, 19.0f, 19.0f);
            AbilityTimer.this.stroke(this.isOver() ? 0 : 64);
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.line(this.x + 3, this.y + 12, this.x + 16, this.y + 12);
        }

        @Override
        public void press() {
            if (this.isOver()) {
                Glbl.jf.setExtendedState(Glbl.jf.getExtendedState() | 1);
            }
        }
    }

    class Mission
    extends GuiItem {
        String name;
        Checkbox[] boxes;

        Mission(int _x, int _y, String _name, int _items, int _value) {
            this.name = _name;
            this.boxes = new Checkbox[_items];
            this.x = _x;
            this.y = _y;
            int i = 0;
            while (i < this.boxes.length) {
                this.boxes[i] = new Checkbox(this.x + 110 + 25 * i, this.y, i < _value);
                ++i;
            }
        }

        @Override
        public boolean isOver() {
            return false;
        }

        @Override
        public void render() {
            boolean isCurrent = false;
            Checkbox[] checkboxArray = this.boxes;
            int n = this.boxes.length;
            int n2 = 0;
            while (n2 < n) {
                Checkbox box = checkboxArray[n2];
                box.render();
                isCurrent = isCurrent ? true : box.isOver();
                ++n2;
            }
            AbilityTimer.this.textFont(Glbl.font12);
            AbilityTimer.this.textSize(12.0f);
            if (isCurrent) {
                AbilityTimer.this.fill(128);
                AbilityTimer.this.text(this.name, this.x, this.y + 15);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text(this.name, this.x - 1, this.y + 15 - 1);
            } else {
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text(this.name, this.x, this.y + 15);
            }
        }

        @Override
        public void press() {
            int i = 0;
            while (i < this.boxes.length) {
                int j;
                this.boxes[i].press();
                if (this.boxes[i].get()) {
                    j = i - 1;
                    while (j >= 0) {
                        this.boxes[j].set();
                        --j;
                    }
                } else {
                    j = i + 1;
                    while (j < this.boxes.length) {
                        this.boxes[j].reset();
                        ++j;
                    }
                }
                ++i;
            }
        }

        public int getValue() {
            int i = this.boxes.length - 1;
            while (i >= 0) {
                if (this.boxes[i].get()) break;
                --i;
            }
            return i + 1;
        }
    }

    class OcrEngine {
        short[][] table;
        int w;
        int h;
        float binThreshold;
        int errorThreshold;

        OcrEngine(short[][] _table, int _w, int _h, float _binThreshold, int _errorThreshold) {
            this.table = _table;
            this.w = _w;
            this.h = _h;
            this.binThreshold = _binThreshold;
            this.errorThreshold = _errorThreshold;
        }

        public int ocr(PImage img) {
            img.filter(16, this.binThreshold);
            short[] line = new short[this.h];
            int py = 0;
            while (py < this.h) {
                line[py] = 0;
                int px = 0;
                while (px < this.w) {
                    int c = img.pixels[this.w * py + px];
                    c = AbilityTimer.getG(c);
                    int n = py;
                    line[n] = (short)(line[n] << 1);
                    int n2 = py;
                    line[n2] = (short)(line[n2] | (c > 0 ? (short)1 : 0));
                    ++px;
                }
                if (Glbl.DebugOcr) {
                    AbilityTimer.println((String)("y" + AbilityTimer.nf((int)py, (int)2) + ": " + AbilityTimer.hex((int)line[py], (int)3) + " : " + AbilityTimer.binary((int)line[py], (int)this.w)));
                }
                ++py;
            }
            if (Glbl.DebugOcr) {
                AbilityTimer.print((String)"OCR diff ");
            }
            int minDiff = this.w * this.h;
            int minDiffNum = 0;
            int[] totalDiff = new int[this.table.length + 2];
            int num = 0;
            while (num < totalDiff.length) {
                int[] diff = new int[2];
                int sft = 0;
                while (sft < diff.length) {
                    int i = 0;
                    while (i < this.h) {
                        int tmp = 0;
                        tmp = num < this.table.length ? this.table[num][i] << sft ^ line[i] : (num == this.table.length ? line[i] : (1 << this.w) - 1 ^ line[i]);
                        int bits = Glbl.countHotbits(tmp);
                        if (bits >= 3) {
                            bits *= 2;
                        }
                        int n = sft;
                        diff[n] = diff[n] + bits;
                        ++i;
                    }
                    ++sft;
                }
                int n = totalDiff[num] = diff[0] < diff[1] ? diff[0] : diff[1];
                if (totalDiff[num] < minDiff) {
                    minDiff = totalDiff[num];
                    minDiffNum = num;
                }
                if (Glbl.DebugOcr) {
                    AbilityTimer.print((String)(String.valueOf(AbilityTimer.nf((float)num)) + ":" + AbilityTimer.nf((float)totalDiff[num]) + " "));
                }
                ++num;
            }
            if (Glbl.DebugOcr) {
                AbilityTimer.println((String)"");
            }
            if (minDiff < this.errorThreshold) {
                if (Glbl.DebugOcr) {
                    AbilityTimer.println((String)("OCR success " + AbilityTimer.nf((float)minDiffNum) + " diff:" + AbilityTimer.nf((float)totalDiff[minDiffNum])));
                }
                return minDiffNum;
            }
            if (Glbl.DebugOcr) {
                AbilityTimer.println((String)"OCR fail:");
            }
            return -1;
        }
    }

    class OcrPosition {
        int lvX;
        int lvY;
        int hpX;
        int hpY;
        int hpPix;

        OcrPosition(int _lvX, int _lvY, int _hpX, int _hpY, int _hpPix) {
            this.lvX = _lvX;
            this.lvY = _lvY + (Glbl.isDmm() ? 1 : 0);
            this.hpX = _hpX;
            this.hpY = _hpY;
            this.hpPix = _hpPix;
        }
    }

    class Scouter {
        static final int W = 600;
        Robot bot;
        Rectangle area;
        PImage fullImg;
        PImage windowImg;
        WritableRaster wr;
        PImage hpImg;
        int hpDisplayHysteresis;
        String name;
        String ver;
        AcceTotal accetotal;
        WeaponTotal weapontotal;
        boolean acceFound;
        boolean weaponFound;
        boolean isKamihimeWindowFound;
        int prevPlayers;
        Valuebox playersBox;
        boolean playersBoxVisible;
        final OcrPosition[] ocrpos;
        final AccePosition[] accepos;
        final AcceConstant[] acceconst;
        final WeaponPosition weaponpos;
        final WeaponConstant[] weaponconst;
        int[] hppos;
        int[] hp;

        Scouter(String _name, String _ver) {
            this.ocrpos = new OcrPosition[]{new OcrPosition(215, 16, 205, 32, 358), new OcrPosition(165, 31, 155, 47, 177), new OcrPosition(466, 31, 455, 47, 177), new OcrPosition(291, 16, 280, 32, 177), new OcrPosition(116, 66, 105, 82, 177), new OcrPosition(466, 66, 455, 82, 177)};
            this.accepos = new AccePosition[]{new AccePosition(687, 103, 220, 349, 152, 135, 196, 3, 2, 111, 301), new AccePosition(264, 15, 355, 300, 41, 11, 49, 280, 3, 301, 284)};
            this.acceconst = new AcceConstant[]{new AcceConstant("SSR", 50, 183, 131, 75, 400), new AcceConstant("SR", 40, 117, 133, 148, 200), new AcceConstant("R", 30, 152, 82, 51, 100), new AcceConstant("N", 20, 132, 117, 103, 50)};
            this.weaponpos = new WeaponPosition(753, 258, 152, 135, 795, 412);
            this.weaponconst = new WeaponConstant[]{new WeaponConstant("R", 20, 152, 82, 51, 0), new WeaponConstant("SR", 20, 117, 133, 148, 1), new WeaponConstant("SSR", 20, 183, 131, 75, 2)};
            this.name = _name;
            this.ver = _ver;
            this.isKamihimeWindowFound = false;
            this.accetotal = new AcceTotal();
            this.weapontotal = new WeaponTotal();
            this.acceFound = false;
            this.weaponFound = false;
            this.prevPlayers = 0;
            this.playersBox = new Valuebox(327, 132, 0, 99, 30);
            this.playersBoxVisible = false;
        }

        public boolean initialize() {
            boolean result = false;
            this.hpDisplayHysteresis = 0;
            this.hppos = new int[this.ocrpos.length];
            this.hp = new int[this.ocrpos.length];
            try {
                this.bot = new Robot();
                this.area = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
                result = true;
            }
            catch (AWTException aWTException) {}
            return result;
        }

        public void findKamihimeWindow() {
            this.isKamihimeWindowFound = false;
            BufferedImage bimg = this.bot.createScreenCapture(this.area);
            if (this.fullImg == null) {
                this.fullImg = new PImage((Image)bimg);
                DataBufferInt dbi = new DataBufferInt(this.fullImg.pixels, this.fullImg.pixels.length);
                this.wr = Raster.createWritableRaster(bimg.getSampleModel(), dbi, new Point(0, 0));
                this.fullImg.loadPixels();
            } else {
                bimg.copyData(this.wr);
                this.fullImg.updatePixels();
            }
            int maxX = this.fullImg.width - 1;
            int maxY = this.fullImg.height - 8;
            int px = 0;
            int py = 0;
            px = 0;
            while (px <= maxX) {
                py = 0;
                while (py <= maxY) {
                    int[] g = new int[8];
                    int i = 0;
                    while (i < 8) {
                        int c = this.fullImg.pixels[this.fullImg.width * (py + i) + px];
                        g[i] = AbilityTimer.getG(c);
                        if (i == 0 && (g[0] >= 40 || g[0] == 0)) break;
                        ++i;
                    }
                    if (g[0] < 40 && g[0] != 0 && g[1] > 200 && g[2] < 40 && g[3] > 200 && g[4] < 40 && g[5] > 200 && g[6] > 200 && g[7] < 40) {
                        this.windowImg = this.fullImg.get(px - 142, py + 8, 960, 640);
                        this.isKamihimeWindowFound = true;
                        return;
                    }
                    ++py;
                }
                ++px;
            }
        }

        public boolean searchHpBar() {
            int lvCount = 0;
            boolean[] found = new boolean[this.ocrpos.length];
            int i = 0;
            while (i < this.ocrpos.length) {
                boolean rc;
                PImage lvImg = this.windowImg.get(this.ocrpos[i].lvX, this.ocrpos[i].lvY, AbilityTimer.this.OcrV.w, AbilityTimer.this.OcrV.h);
                boolean bl = rc = AbilityTimer.this.OcrV.ocr(lvImg) == 0;
                if (Glbl.DebugOcr) {
                    AbilityTimer.this.image(lvImg, 640 + AbilityTimer.this.OcrV.w * 2 * i, 120.0f);
                }
                if (rc) {
                    found[i] = true;
                    ++lvCount;
                    if (i == 0) break;
                }
                ++i;
            }
            if (lvCount > 0) {
                i = 0;
                while (i < this.hp.length) {
                    this.hp[i] = 0;
                    ++i;
                }
            }
            i = 0;
            while (i < this.ocrpos.length) {
                if (found[i]) {
                    int x = this.ocrpos[i].hpPix - 1;
                    while (x >= 0) {
                        int c = this.windowImg.pixels[this.windowImg.width * this.ocrpos[i].hpY + this.ocrpos[i].hpX + x];
                        int r = AbilityTimer.getR(c);
                        int g = AbilityTimer.getG(c);
                        int b = AbilityTimer.getB(c);
                        if (r > 240 && g < 40 && b < 90) {
                            double tmp = (double)(x * 100) / (double)(this.ocrpos[i].hpPix - 1);
                            this.hp[i] = (int)Math.ceil(tmp);
                            this.hppos[i] = x;
                            if (!Glbl.DebugHp) break;
                            AbilityTimer.println((String)("hp:" + this.hp[i] + " x:" + x));
                            break;
                        }
                        --x;
                    }
                }
                ++i;
            }
            if (lvCount > 0) {
                this.hpDisplayHysteresis = 5;
                this.hpImg = this.windowImg.get(48, 10, 600, 116);
                this.hpImg.filter(12);
                AbilityTimer.this.image(this.hpImg, 240.0f, 0.0f);
            } else if (this.hpDisplayHysteresis > 0) {
                --this.hpDisplayHysteresis;
                AbilityTimer.this.image(this.hpImg, 240.0f, 0.0f);
            } else {
                return false;
            }
            i = 0;
            while (i < this.ocrpos.length) {
                if (this.hp[i] > 0) {
                    AbilityTimer.this.strokeWeight(1.0f);
                    int orgX = 240 + this.ocrpos[i].hpX - 48;
                    int orgY = this.ocrpos[i].hpY - 10;
                    int hpPix = this.ocrpos[i].hpPix;
                    if (Glbl.DebugHp) {
                        AbilityTimer.this.stroke(255.0f, 0.0f, 0.0f);
                        AbilityTimer.this.line(orgX, orgY, orgX + hpPix - 1, orgY);
                    }
                    AbilityTimer.this.stroke(0.0f, 255.0f, 0.0f);
                    AbilityTimer.this.line(orgX + this.hppos[i], orgY, orgX + this.hppos[i], orgY + 12);
                    AbilityTimer.this.line(orgX, orgY + 4, orgX, orgY + 9);
                    AbilityTimer.this.line(orgX, orgY + 6, orgX + hpPix - 1, orgY + 6);
                    AbilityTimer.this.line(orgX + hpPix - 1, orgY + 4, orgX + hpPix - 1, orgY + 9);
                    AbilityTimer.this.line(orgX + hpPix / 2, orgY + 4, orgX + hpPix / 2, orgY + 9);
                    AbilityTimer.this.line((float)orgX + (float)hpPix * 0.3f, orgY + 4, (float)orgX + (float)hpPix * 0.3f, orgY + 9);
                    AbilityTimer.this.textFont(Glbl.font12);
                    AbilityTimer.this.textSize(12.0f);
                    AbilityTimer.this.fill(0);
                    AbilityTimer.this.text(String.valueOf(AbilityTimer.nf((float)this.hp[i])) + "%", orgX + hpPix - 25 + 1, orgY + 3);
                    AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                    AbilityTimer.this.text(String.valueOf(AbilityTimer.nf((float)this.hp[i])) + "%", orgX + hpPix - 25 + 0, orgY + 2);
                }
                ++i;
            }
            int players = 0;
            this.playersBoxVisible = false;
            int i2 = 0;
            while (i2 < 2) {
                int num;
                PImage playersImg = this.windowImg.get(723 + (AbilityTimer.this.OcrPlayers.w + 1) * i2, 10, AbilityTimer.this.OcrPlayers.w, AbilityTimer.this.OcrPlayers.h);
                if (Glbl.DebugOcr) {
                    AbilityTimer.this.image(playersImg, 290 + 10 * i2, 200.0f);
                }
                if ((num = AbilityTimer.this.OcrPlayers.ocr(playersImg)) < 0) break;
                if (num < 10) {
                    players = players * 10 + num;
                }
                ++i2;
            }
            if (players > 0) {
                int threshold;
                this.playersBoxVisible = true;
                AbilityTimer.this.textFont(Glbl.font12);
                AbilityTimer.this.textSize(12.0f);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text("Bells when", 260.0f, 150.0f);
                AbilityTimer.this.text("or more participants joined.", 405.0f, 150.0f);
                this.playersBox.render();
                if (Glbl.DebugOcr) {
                    AbilityTimer.println((String)("players : " + players));
                }
                if (players >= (threshold = this.playersBox.getValue()) && threshold > this.prevPlayers) {
                    Glbl.joined.play();
                }
                this.prevPlayers = players;
            }
            return true;
        }

        public boolean searchAccessory() {
            int view = 0;
            while (view < this.accepos.length) {
                AccePosition apos = this.accepos[view];
                PImage acImg = this.windowImg.get(apos.offsetX, apos.offsetY, apos.w, apos.h);
                OcrEngine engine = view == 0 ? AbilityTimer.this.OcrEnhLv : AbilityTimer.this.OcrInfoLv;
                int w = engine.w;
                int h = engine.h;
                int level = 0;
                int i = 0;
                while (i < 2) {
                    int num;
                    PImage numImg = acImg.get(apos.levelX + i * (w + apos.between), apos.levelY, w, h);
                    if (Glbl.DebugOcr) {
                        AbilityTimer.this.image(numImg, 640 + i * (w + 2 + apos.between), 135 + 15 * view);
                    }
                    if ((num = engine.ocr(numImg)) < 0) break;
                    if (num < 10) {
                        level = level * 10 + num;
                    }
                    ++i;
                }
                if (view == 0 && level == 0) {
                    int num;
                    PImage numImg = acImg.get(201, 3, w, h);
                    if (Glbl.DebugOcr) {
                        AbilityTimer.this.image(numImg, 640 + 2 * (w + 2 + apos.between), 135.0f);
                    }
                    if ((num = engine.ocr(numImg)) >= 0 && num < 10) {
                        level = num;
                    }
                }
                engine = view == 0 ? AbilityTimer.this.OcrEnhNext : AbilityTimer.this.OcrInfoNext;
                w = engine.w;
                h = engine.h;
                int nextExp = 0;
                int i2 = 0;
                while (i2 < 4) {
                    int num;
                    PImage numImg = acImg.get(apos.nextX + i2 * (w + 2), apos.nextY, w, h);
                    if (Glbl.DebugOcr) {
                        AbilityTimer.this.image(numImg, 640 + i2 * (w + 4), 170.0f);
                    }
                    if ((num = engine.ocr(numImg)) < 0) break;
                    if (num < 10) {
                        nextExp = nextExp * 10 + num;
                    }
                    ++i2;
                }
                AcceConstant acce = this.acceconst[0];
                PImage iconImg = acImg.get(apos.rarelityX, apos.rarelityY, 15, 15);
                int c = Glbl.averageOfImage(iconImg);
                int r = AbilityTimer.getR(c);
                int g = AbilityTimer.getG(c);
                int b = AbilityTimer.getB(c);
                int i3 = 0;
                while (i3 < this.acceconst.length) {
                    if (this.acceconst[i3].r - 10 <= r && r <= this.acceconst[i3].r + 10 && this.acceconst[i3].g - 10 <= g && g <= this.acceconst[i3].g + 10 && this.acceconst[i3].b - 10 <= b && b <= this.acceconst[i3].b + 10) {
                        acce = this.acceconst[i3];
                        break;
                    }
                    ++i3;
                }
                if (level == acce.maxLv || level > 0 && nextExp > 0) {
                    acImg.filter(12);
                    if (view == 0) {
                        AbilityTimer.this.image(acImg, 240.0f, 0.0f);
                    } else {
                        PImage trimImg = acImg.get(105, 0, this.accepos[0].w, apos.h);
                        PImage lvImg = acImg.get(27, apos.h - 24, this.accepos[0].w, 24);
                        PImage nextImg = acImg.get(251, apos.h - 24, 320, 24);
                        AbilityTimer.this.image(trimImg, 240.0f, 0.0f);
                        AbilityTimer.this.image(lvImg, 240.0f, apos.h - 24);
                        AbilityTimer.this.image(nextImg, 355.0f, apos.h - 24);
                    }
                    this.accetotal.render(acce, level, nextExp);
                    if (Glbl.DebugOcr) {
                        AbilityTimer.println((String)("Rarelity icon RGB: " + AbilityTimer.nf((float)r) + " " + AbilityTimer.nf((float)g) + " " + AbilityTimer.nf((float)b)));
                        AbilityTimer.this.strokeWeight(1.0f);
                        AbilityTimer.this.stroke(255.0f, 0.0f, 0.0f);
                        AbilityTimer.this.line(240 + apos.rarelityX, apos.rarelityY, 240 + apos.rarelityX + 10, apos.rarelityY + 10);
                        AbilityTimer.this.image(iconImg, 250.0f, 10.0f);
                    }
                    return true;
                }
                ++view;
            }
            return false;
        }

        public boolean searchWeapon() {
            int level = 0;
            int w = AbilityTimer.this.OcrSkillLv.w;
            int h = AbilityTimer.this.OcrSkillLv.h;
            int i = 0;
            while (i < 2) {
                int num;
                PImage numImg = this.windowImg.get(this.weaponpos.slX + (w + 2) * i, this.weaponpos.slY, w, h);
                if (Glbl.DebugOcr) {
                    AbilityTimer.this.image(numImg, 640 + i * (w + 2), 150.0f);
                }
                if ((num = AbilityTimer.this.OcrSkillLv.ocr(numImg)) < 0) break;
                if (num < 10) {
                    level = level * 10 + num;
                }
                ++i;
            }
            w = AbilityTimer.this.OcrSkillNext.w;
            h = AbilityTimer.this.OcrSkillNext.h;
            int nextExp = 0;
            int i2 = 0;
            while (i2 < 4) {
                int num;
                PImage numImg = this.windowImg.get(this.weaponpos.nextX + i2 * (w + 2), this.weaponpos.nextY, w, h);
                if (Glbl.DebugOcr) {
                    AbilityTimer.this.image(numImg, 640 + i2 * (w + 4), 170.0f);
                }
                if ((num = AbilityTimer.this.OcrSkillNext.ocr(numImg)) < 0) break;
                if (num < 10) {
                    nextExp = nextExp * 10 + num;
                }
                ++i2;
            }
            if (Glbl.DebugOcr) {
                AbilityTimer.println((String)("SLv " + level + " Next " + nextExp));
            }
            AccePosition apos = this.accepos[0];
            PImage acImg = this.windowImg.get(apos.offsetX, apos.offsetY, apos.w, apos.h);
            WeaponConstant weap = this.weaponconst[0];
            PImage iconImg = acImg.get(apos.rarelityX + 2, apos.rarelityY + 15, 15, 15);
            int c = Glbl.averageOfImage(iconImg);
            int r = AbilityTimer.getR(c);
            int g = AbilityTimer.getG(c);
            int b = AbilityTimer.getB(c);
            int i3 = 0;
            while (i3 < this.weaponconst.length) {
                if (this.weaponconst[i3].r - 10 <= r && r <= this.weaponconst[i3].r + 10 && this.weaponconst[i3].g - 10 <= g && g <= this.weaponconst[i3].g + 10 && this.weaponconst[i3].b - 10 <= b && b <= this.weaponconst[i3].b + 10) {
                    weap = this.weaponconst[i3];
                    break;
                }
                ++i3;
            }
            if (level == 20 || level > 0 && nextExp > 0) {
                acImg.filter(12);
                AbilityTimer.this.image(acImg, 240.0f, 0.0f);
                this.weapontotal.render(weap, level, nextExp);
                if (Glbl.DebugOcr) {
                    AbilityTimer.println((String)("Rarelity icon RGB: " + AbilityTimer.nf((float)r) + " " + AbilityTimer.nf((float)g) + " " + AbilityTimer.nf((float)b)));
                    AbilityTimer.this.strokeWeight(1.0f);
                    AbilityTimer.this.stroke(255.0f, 0.0f, 0.0f);
                    AbilityTimer.this.line(240 + apos.rarelityX + 2, apos.rarelityY + 15, 240 + apos.rarelityX + 12, apos.rarelityY + 25);
                    AbilityTimer.this.image(iconImg, 250.0f, 10.0f);
                    AbilityTimer.println((String)("Weapon Rarelity : " + weap.str));
                }
                return true;
            }
            return false;
        }

        public void render() {
            boolean found;
            this.acceFound = false;
            this.weaponFound = false;
            if (this.isKamihimeWindowFound && !(found = this.searchHpBar())) {
                this.acceFound = this.searchAccessory();
                if (!this.acceFound) {
                    this.weaponFound = this.searchWeapon();
                }
            }
            AbilityTimer.this.textFont(Glbl.font12);
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text(String.valueOf(this.name) + " version " + this.ver, 670.0f, 312.0f);
        }

        public void press() {
            if (this.acceFound) {
                this.accetotal.press();
            }
            if (this.weaponFound) {
                this.weapontotal.press();
            }
            if (this.playersBoxVisible) {
                this.playersBox.press();
            }
        }

        public void wheel(MouseEvent event) {
            if (this.acceFound) {
                this.accetotal.wheel(event);
            }
            if (this.weaponFound) {
                this.weapontotal.wheel(event);
            }
            if (this.playersBoxVisible) {
                this.playersBox.wheel(event);
            }
        }
    }

    static enum ServiceProvider {
        Nutaku,
        Dmm;

    }

    class StrValuebox
    extends GuiItem {
        static final int H = 20;
        String[] strs;
        int value;
        int limit;
        Valuebox vbox;
        int[] thresholds;
        int width;

        StrValuebox(int _x, int _y, String[] _strs, int _value, Valuebox _vbox, int[] _thresholds, int _width) {
            super(_x, _y, _width, 20);
            this.strs = _strs;
            this.value = _value;
            this.limit = _strs.length - 1;
            this.vbox = _vbox;
            this.thresholds = _thresholds;
            this.width = _width;
            if (this.vbox != null) {
                this.vbox.setThreshold(this.thresholds[this.value]);
            }
        }

        StrValuebox(int _x, int _y, String[] _strs, int _value) {
            this(_x, _y, _strs, _value, null, null, 40);
        }

        StrValuebox(int _x, int _y, String[] _strs, int _value, Valuebox _vbox, int[] _thresholds) {
            this(_x, _y, _strs, _value, _vbox, _thresholds, 40);
        }

        @Override
        public void render() {
            AbilityTimer.this.stroke(0);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(this.isOver() ? 224 : 255);
            AbilityTimer.this.rect(this.x, this.y, this.width - 1, 19.0f);
            AbilityTimer.this.textFont(Glbl.font24);
            AbilityTimer.this.textSize(16.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text(this.strs[this.value], this.x + 6, this.y + 16);
        }

        public void up() {
            ++this.value;
            if (this.value > this.limit) {
                this.value = 0;
            }
            if (this.vbox != null) {
                this.vbox.setThreshold(this.thresholds[this.value]);
            }
        }

        public void down() {
            --this.value;
            if (this.value < 0) {
                this.value = this.limit;
            }
            if (this.vbox != null) {
                this.vbox.setThreshold(this.thresholds[this.value]);
            }
        }

        @Override
        public void press() {
            if (this.isOver()) {
                if (AbilityTimer.this.mouseButton == 37) {
                    this.up();
                } else if (AbilityTimer.this.mouseButton == 39) {
                    this.down();
                }
            }
        }

        @Override
        public void wheel(MouseEvent event) {
            if (this.isOver()) {
                float count = event.getCount();
                if (count < 0.0f) {
                    this.up();
                } else if (count > 0.0f) {
                    this.down();
                }
            }
        }

        public void setValue(int _value) {
            this.value = _value;
        }

        public int getValue() {
            return this.value;
        }
    }

    class TimerBar
    extends GuiItem {
        TimerDisplay td;
        static final int W = 64;
        static final int H = 310;

        TimerBar(int _x, int _y, TimerDisplay _td) {
            super(_x, _y, 64, 310);
            this.td = _td;
        }

        @Override
        public void render() {
            AbilityTimer.this.stroke(224);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(255);
            AbilityTimer.this.triangle(this.x, this.y, this.x, this.y + 310, this.x + 64 - 1, this.y + 310 - 1);
            AbilityTimer.this.fill(240);
            AbilityTimer.this.triangle(this.x, this.y, this.x + 64, this.y, this.x + 64 - 1, this.y + 310 - 1);
            if (this.isOver()) {
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                AbilityTimer.this.triangle(this.x, this.y, this.x, AbilityTimer.this.mouseY, this.x + AbilityTimer.this.mouseY / 5, AbilityTimer.this.mouseY);
            }
        }

        public int computeSeconds() {
            return (AbilityTimer.this.mouseY - this.y) / 7 * 5 + 25;
        }

        @Override
        public void press() {
            if (this.isOver()) {
                this.td.start(this.computeSeconds());
            }
        }
    }

    class TimerBarLabel
    extends GuiItem {
        TimerBar tb;

        TimerBarLabel(TimerBar _tb) {
            this.tb = _tb;
        }

        @Override
        public void render() {
            if (this.tb.isOver()) {
                String msg = String.valueOf(AbilityTimer.str((int)this.tb.computeSeconds())) + "sec";
                int y = AbilityTimer.this.mouseY;
                if (y < 20) {
                    y = 20;
                }
                AbilityTimer.this.textFont(Glbl.font24);
                AbilityTimer.this.textSize(24.0f);
                AbilityTimer.this.fill(64);
                AbilityTimer.this.text(msg, this.tb.x + 15 + AbilityTimer.this.mouseY / 5 + 2, y + 2);
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                AbilityTimer.this.text(msg, this.tb.x + 15 + AbilityTimer.this.mouseY / 5, y);
            }
        }
    }

    class TimerDisplay
    extends GuiItem {
        int endTime;
        static final int W = 70;
        static final int H = 30;

        TimerDisplay(int _x, int _y) {
            super(_x, _y, 70, 30);
            this.endTime = 0;
        }

        public void start(int seconds) {
            this.endTime = AbilityTimer.this.millis() + 1000 * seconds;
            Glbl.mode = AppMode.Timer;
        }

        @Override
        public void render() {
            int currentTime = AbilityTimer.this.millis();
            int remainTime = this.endTime - currentTime;
            if (remainTime <= 0) {
                Glbl.mode = AppMode.Checklist;
                Glbl.chime.play();
            } else {
                AbilityTimer.this.strokeWeight(2.0f);
                AbilityTimer.this.stroke(128);
                AbilityTimer.this.fill(this.isOver() ? 64 : 0);
                AbilityTimer.this.rect(this.x, this.y, 69.0f, 29.0f);
                String msg = "000.0";
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                int sec = remainTime / 1000;
                int decimal = remainTime / 100 % 10;
                msg = String.valueOf(AbilityTimer.nf((int)sec, (int)3)) + "." + AbilityTimer.str((int)decimal);
                AbilityTimer.this.textFont(Glbl.font24);
                AbilityTimer.this.textSize(24.0f);
                AbilityTimer.this.text(msg, this.x + 5, this.y + 22);
            }
        }

        @Override
        public void press() {
            if (this.isOver()) {
                Glbl.mode = AppMode.Checklist;
            }
        }
    }

    class Valuebox
    extends GuiItem {
        static final int W = 30;
        static final int H = 20;
        int value;
        int lowerLimit;
        int threshold;
        int upperLimit;
        LabeledButton plusB;
        LabeledButton minusB;

        Valuebox(int _x, int _y, int _lowerLimit, int _threshold, int _upperLimit) {
            super(_x, _y, 30, 20);
            this.value = _lowerLimit;
            this.lowerLimit = _lowerLimit;
            this.threshold = _threshold;
            this.upperLimit = _upperLimit;
            this.plusB = new LabeledButton(_x + 30, _y, "+", this);
            this.minusB = new LabeledButton(_x + 30 + 20, _y, "-", this);
        }

        Valuebox(int _x, int _y, int _lowerLimit, int _threshold, int _upperLimit, int _value) {
            super(_x, _y, 30, 20);
            this.value = _value;
            this.lowerLimit = _lowerLimit;
            this.threshold = _threshold;
            this.upperLimit = _upperLimit;
            this.plusB = new LabeledButton(_x + 30, _y, "+", this);
            this.minusB = new LabeledButton(_x + 30 + 20, _y, "-", this);
        }

        @Override
        public void render() {
            this.plusB.render();
            this.minusB.render();
            AbilityTimer.this.stroke(0);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(this.isOver() ? 224 : 255);
            AbilityTimer.this.rect(this.x, this.y, 29.0f, 19.0f);
            AbilityTimer.this.textFont(Glbl.font24);
            AbilityTimer.this.textSize(16.0f);
            if (this.value > this.threshold) {
                AbilityTimer.this.fill(255.0f, 0.0f, 0.0f);
            } else {
                AbilityTimer.this.fill(0);
            }
            AbilityTimer.this.text(AbilityTimer.nfspc(this.value, 2), this.x + 6, this.y + 16);
        }

        @Override
        public void press() {
            if (this.plusB.isOver()) {
                this.up();
            } else if (this.minusB.isOver()) {
                this.down();
            }
        }

        public void up() {
            ++this.value;
            if (this.value > this.upperLimit) {
                this.value = this.upperLimit;
            }
        }

        public void down() {
            --this.value;
            if (this.value < this.lowerLimit) {
                this.value = this.lowerLimit;
            }
        }

        @Override
        public void wheel(MouseEvent event) {
            if (this.isOver() || this.plusB.isOver() || this.minusB.isOver()) {
                float count = event.getCount();
                if (count < 0.0f) {
                    this.up();
                } else if (count > 0.0f) {
                    this.down();
                }
            }
        }

        public void setValue(int _value) {
            this.value = _value;
        }

        public int getValue() {
            return this.value;
        }

        public void setThreshold(int _threshold) {
            this.threshold = _threshold;
        }
    }

    class WallClock
    extends GuiItem {
        ZoneId zid;
        int[] gemTimeTable;
        static final int W = 82;
        static final int H = 20;

        WallClock(ZoneId _zid) {
            super(157, 299, 82, 20);
            this.zid = _zid;
            this.gemTimeTable = new int[DmmGemTimeTable.length];
            float[] tbl = DmmGemTimeTable;
            if (this.zid.equals(ZoneId.of("America/Los_Angeles"))) {
                tbl = NutakuGemTimeTable;
            }
            int i = 0;
            while (i < DmmGemTimeTable.length) {
                this.gemTimeTable[i] = PApplet.parseInt((float)(tbl[i] * 100.0f));
                ++i;
            }
        }

        @Override
        public void render() {
            Instant currentTime = Instant.now();
            ZonedDateTime zoneTime = currentTime.atZone(this.zid);
            int w = zoneTime.getDayOfWeek().getValue();
            int hour = zoneTime.getHour();
            int minute = zoneTime.getMinute();
            boolean isGemTime = false;
            if (!Glbl.isDmm()) {
                int nowHour = hour * 100 + minute * 100 / 60;
                Glbl.isLastOneMinute = false;
                int i = 0;
                while (i < 3) {
                    int gemHour = this.gemTimeTable[(w - 1) * 3 + i];
                    if (gemHour <= nowHour && nowHour < gemHour + 50) {
                        isGemTime = true;
                        if (minute != 29 && minute != 59) break;
                        Glbl.isLastOneMinute = true;
                        break;
                    }
                    ++i;
                }
            }
            if (this.isOver()) {
                zoneTime = currentTime.atZone(ZoneId.systemDefault());
                hour = zoneTime.getHour();
                minute = zoneTime.getMinute();
            }
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.stroke(128);
            if (isGemTime) {
                AbilityTimer.this.fill(255.0f, 255.0f, 0.0f);
            } else {
                AbilityTimer.this.fill(0);
            }
            AbilityTimer.this.rect(this.x, this.y, 81.0f, 19.0f);
            if (isGemTime) {
                AbilityTimer.this.fill(0);
            } else {
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
            }
            AbilityTimer.this.textFont(Glbl.font24);
            AbilityTimer.this.textSize(12.0f);
            String dow = zoneTime.getDayOfWeek().getDisplayName(TextStyle.SHORT, Locale.US);
            int day = zoneTime.getDayOfMonth();
            String msg = dow;
            if (!Glbl.isLastOneMinute) {
                msg = String.valueOf(msg) + " " + (day < 10 ? " " : "") + AbilityTimer.str((int)day);
                msg = String.valueOf(msg) + " " + AbilityTimer.nf((int)hour, (int)2) + ":" + AbilityTimer.nf((int)minute, (int)2);
                AbilityTimer.this.text(msg, this.x + 4, this.y + 14);
            } else {
                int second = zoneTime.getSecond();
                msg = String.valueOf(msg) + " " + AbilityTimer.nf((int)hour, (int)2) + ":" + AbilityTimer.nf((int)minute, (int)2) + ":" + AbilityTimer.nf((int)second, (int)2);
                AbilityTimer.this.text(msg, this.x + 4, this.y + 14);
            }
            if (!Glbl.isDmm() && this.isOver()) {
                this.putGemQuestTable(currentTime);
            } else {
                AbilityTimer.this.textFont(Glbl.font12);
                AbilityTimer.this.textSize(12.0f);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.textAlign(39);
                AbilityTimer.this.text(this.zid.toString(), this.x - 2, 312.0f);
                AbilityTimer.this.textAlign(37);
            }
        }

        @Override
        public void press() {
        }

        public void putGemQuestTable(Instant currentTime) {
            ZonedDateTime zoneTime = currentTime.atZone(this.zid);
            int m = zoneTime.getMinute();
            if (m % 15 > 0) {
                zoneTime = zoneTime.plusMinutes(15 - m % 15);
            }
            AbilityTimer.this.stroke(128);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.rect(6.0f, 86.0f, 231.0f, 201.0f);
            AbilityTimer.this.fill(255);
            AbilityTimer.this.rect(5.0f, 85.0f, 230.0f, 200.0f);
            int msgY = 100;
            boolean first = true;
            int[] localGemTimeTable = new int[28];
            int i = 0;
            while (i < 28) {
                localGemTimeTable[i] = Integer.MAX_VALUE;
                ++i;
            }
            i = 0;
            while (i < 672) {
                int w = zoneTime.getDayOfWeek().getValue();
                int hour = zoneTime.getHour();
                int minute = zoneTime.getMinute();
                int nowHour = hour * 100 + minute * 100 / 60;
                int j = 0;
                while (j < 3) {
                    int gemHour = this.gemTimeTable[(w - 1) * 3 + j];
                    if (gemHour == nowHour) {
                        Instant t = Instant.from(zoneTime);
                        ZonedDateTime local = t.atZone(ZoneId.systemDefault());
                        int lw = local.getDayOfWeek().getValue();
                        int lh = local.getHour();
                        int lm = local.getMinute();
                        int found = lh * 100 + lm * 100 / 60;
                        if (first) {
                            first = false;
                        }
                        int index = (lw - 1) * 4;
                        int[] part = new int[]{++found, localGemTimeTable[index + 0], localGemTimeTable[index + 1], localGemTimeTable[index + 2], localGemTimeTable[index + 3]};
                        Arrays.sort(part);
                        System.arraycopy(part, 0, localGemTimeTable, index, 4);
                    }
                    ++j;
                }
                zoneTime = zoneTime.plusMinutes(15L);
                ++i;
            }
            AbilityTimer.this.textFont(Glbl.font12);
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text("Gem Quest on your Timezone", 10.0f, msgY);
            msgY = (int)((float)msgY + 30.0f);
            int w = 1;
            while (w <= 7) {
                String msg = DayOfWeek.of(w).getDisplayName(TextStyle.SHORT, Locale.US);
                msg = String.valueOf(msg) + " ";
                int i2 = 0;
                while (i2 < 4) {
                    int index = (w - 1) * 4 + i2;
                    int value = localGemTimeTable[index];
                    if (value != Integer.MAX_VALUE) {
                        int lh = value / 100;
                        int lm = value % 100 * 60 / 100;
                        msg = value % 10 == 1 ? String.valueOf(msg) + ">" + AbilityTimer.nf((int)lh, (int)2) + ":" + AbilityTimer.nf((int)lm, (int)2) + "<" : String.valueOf(msg) + " " + AbilityTimer.nf((int)lh, (int)2) + ":" + AbilityTimer.nf((int)lm, (int)2) + " ";
                    }
                    ++i2;
                }
                AbilityTimer.this.textFont(Glbl.font24);
                AbilityTimer.this.textSize(12.0f);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text(msg, 15.0f, msgY);
                msgY += 20;
                ++w;
            }
            AbilityTimer.this.textFont(Glbl.font12);
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text(ZoneId.systemDefault().toString(), this.x - 55, this.y - 20);
            AbilityTimer.this.stroke(0);
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.line(this.x - 10, this.y - 15, this.x, this.y - 3);
        }
    }

    class WeaponConstant {
        String str;
        int maxLv;
        int r;
        int g;
        int b;
        int rare;

        WeaponConstant(String _str, int _maxLv, int _r, int _g, int _b, int _rare) {
            this.str = _str;
            this.maxLv = _maxLv;
            this.r = _r;
            this.g = _g;
            this.b = _b;
            this.rare = _rare;
        }
    }

    class WeaponPosition {
        int slX;
        int slY;
        int rarelityX;
        int rarelityY;
        int nextX;
        int nextY;

        WeaponPosition(int _slX, int _slY, int _rarelityX, int _rarelityY, int _nextX, int _nextY) {
            this.slX = _slX;
            this.slY = _slY;
            this.rarelityX = _rarelityX;
            this.rarelityY = _rarelityY;
            this.nextX = _nextX;
            this.nextY = _nextY;
        }
    }

    class WeaponRow
    extends GuiItem {
        StrValuebox rareBox;
        Valuebox lvBox;
        Valuebox numBox;
        ArrayList<GuiItem> gitems;
        int x;
        int y;
        final int delta_y = 29;

        WeaponRow(int _x, int _y, int _initialRare, int _initialLv) {
            this.x = _x;
            this.y = _y;
            String[] rare = new String[]{"R", "SR", "SSR", "Grail", "FalseG", "HolyG"};
            int[] lvThresholds = new int[]{20, 20, 20, 20, 20, 1};
            this.lvBox = new Valuebox(this.x + 65, this.y, 1, 20, 20, _initialLv);
            this.rareBox = new StrValuebox(this.x + 0, this.y, rare, _initialRare, this.lvBox, lvThresholds, 60);
            this.numBox = new Valuebox(this.x + 145, this.y, 0, 20, 99);
            this.gitems = new ArrayList();
            this.gitems.add(this.rareBox);
            this.gitems.add(this.lvBox);
            this.gitems.add(this.numBox);
        }

        public boolean isCurrent() {
            for (GuiItem item : this.gitems) {
                if (!item.isOver()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void render() {
            for (GuiItem item : this.gitems) {
                item.render();
            }
            AbilityTimer.this.textFont(Glbl.font24);
            AbilityTimer.this.textSize(16.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text(AbilityTimer.nfspc(this.getExp(), 5), this.x + 220, this.y + 16);
        }

        @Override
        public void press() {
            for (GuiItem item : this.gitems) {
                item.press();
            }
        }

        @Override
        public void wheel(MouseEvent event) {
            for (GuiItem item : this.gitems) {
                item.wheel(event);
            }
        }

        public int getItems() {
            return this.numBox.getValue();
        }

        public int getExp() {
            int exp = Glbl.calcWeaponExp(this.rareBox.getValue(), this.lvBox.getValue());
            return exp * this.numBox.getValue();
        }
    }

    class WeaponTotal {
        final int[] initialRare;
        final int[] initialLv;
        WeaponRow[] wr;
        AllClearButton ac;

        WeaponTotal() {
            int[] nArray = new int[6];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            nArray[5] = 5;
            this.initialRare = nArray;
            this.initialLv = new int[]{1, 4, 5, 4, 5, 1};
            this.wr = new WeaponRow[this.initialRare.length];
            this.ac = new AllClearButton(480, 235);
            this.allClear();
        }

        public void allClear() {
            int i = 0;
            while (i < this.initialRare.length) {
                this.wr[i] = new WeaponRow(470, 102 + i * 21, this.initialRare[i], this.initialLv[i]);
                ++i;
            }
        }

        public void render(WeaponConstant weap, int level, int nextExp) {
            int expToMax = Glbl.calcWeaponExpToMax(weap, level, nextExp);
            int piledExp = Glbl.calcWeaponPiledExp(weap, level, nextExp);
            AbilityTimer.this.textFont(Glbl.font24);
            AbilityTimer.this.textSize(16.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text(weap.str, 470.0f, 20.0f);
            AbilityTimer.this.text("SL   " + AbilityTimer.nfspc(level, 3), 470.0f, 35.0f);
            AbilityTimer.this.text("NEXT " + AbilityTimer.nfspc(nextExp, 3), 470.0f, 50.0f);
            AbilityTimer.this.text("to  SL" + AbilityTimer.nf((float)weap.maxLv) + ": " + (expToMax > 0 ? String.valueOf(AbilityTimer.nfspc(expToMax, 5)) + "exp" : "-"), 470.0f, 65.0f);
            AbilityTimer.this.textFont(Glbl.font12);
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.text("Rare          Lv                Items", 470.0f, 97.0f);
            int items = 0;
            int total = 0;
            WeaponRow[] weaponRowArray = this.wr;
            int n = this.wr.length;
            int n2 = 0;
            while (n2 < n) {
                WeaponRow row = weaponRowArray[n2];
                row.render();
                items += row.getItems();
                total += row.getExp();
                ++n2;
            }
            this.ac.render();
            if (total > 0) {
                AbilityTimer.this.stroke(0.0f, 255.0f, 0.0f);
                AbilityTimer.this.strokeWeight(2.0f);
                AbilityTimer.this.fill(224);
                AbilityTimer.this.triangle(617.0f, 38.0f, 635.0f, 50.0f, 617.0f, 62.0f);
                int[] enhanced = Glbl.calcWeaponLvFromExp(weap, piledExp + total);
                int enhancedLv = enhanced[0];
                int enhancedNext = enhanced[1];
                if (enhancedLv >= weap.maxLv) {
                    enhancedLv = weap.maxLv;
                    enhancedNext = 0;
                }
                AbilityTimer.this.fill(0);
                AbilityTimer.this.textSize(16.0f);
                AbilityTimer.this.text("Success Lv   ", 640.0f, 50.0f);
                AbilityTimer.this.fill(0.0f, enhancedLv == weap.maxLv ? 255 : 0, 0.0f);
                AbilityTimer.this.text("             " + AbilityTimer.nfspc(enhancedLv, 3), 640.0f, 50.0f);
                AbilityTimer.this.textSize(14.0f);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text("NEXT " + AbilityTimer.nfspc(enhancedNext, 4), 705.0f, 65.0f);
            }
            AbilityTimer.this.textFont(Glbl.font12);
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text("Total", 569.0f, 244.0f);
            AbilityTimer.this.textFont(Glbl.font24);
            AbilityTimer.this.textSize(16.0f);
            AbilityTimer.this.fill(items > 20 ? 255 : 0, 0.0f, 0.0f);
            AbilityTimer.this.text(AbilityTimer.nfspc(items, 2), 620.0f, 244.0f);
            AbilityTimer.this.fill(0.0f, total >= expToMax ? 255 : 0, 0.0f);
            AbilityTimer.this.text(AbilityTimer.nfspc(total, 5), 690.0f, 244.0f);
        }

        public void press() {
            WeaponRow[] weaponRowArray = this.wr;
            int n = this.wr.length;
            int n2 = 0;
            while (n2 < n) {
                WeaponRow row = weaponRowArray[n2];
                row.press();
                ++n2;
            }
            if (this.ac.isOver()) {
                this.allClear();
            }
        }

        public void wheel(MouseEvent event) {
            WeaponRow[] weaponRowArray = this.wr;
            int n = this.wr.length;
            int n2 = 0;
            while (n2 < n) {
                WeaponRow row = weaponRowArray[n2];
                row.wheel(event);
                ++n2;
            }
        }
    }
}

