////////////////////////////////////////////////////////////////
// aaoh.kaze
//   Copyright (C) 2008 - 2012 AAOh inc.
// 
// Licensed under the MIT license
//   http://www.opensource.org/licenses/mit-license.php
////////////////////////////////////////////////////////////////

/**
 * @fileOverview aaoh.kaze
 * @author       $Author: fujishiro $
 */

(function () {
	try {
		if (!aaoh) {
			/**
			 * aaoh。
			 *
			 * @namespace
			 */
			aaoh = {};
		}
	} catch(ex) {
		aaoh = {};
	}
})();

(function () {
/**
 * aaoh.kaze。
 *
 * @namespace
 */
aaoh.kaze = {
	VERSION:   "1.0.0",
	FLG_WINDOW: 0, // 0: default, 1: Google, 2: Yahoo

	/**
	 * 初期化処理。
	 *
	 * @static
	 */
	load: function() {
		// 読込むライブラリリスト
		var loadList = new Array();
		var baseUrl  = '';
		loadList.push('../localizedStrings.js');
		loadList.push('miniajax.js');
		loadList.push('json2.js');
		loadList.push('aaoh.kaze-core.js');
		loadList.push('aaoh.kaze-animation.js');

		// Google
		if (aaoh.kaze.FLG_WINDOW == 1) {
			//loadList.shift(); // localizedStrings.js削除
			//loadList.push('anything.js');

		// Yahoo
		} else if (aaoh.kaze.FLG_WINDOW == 2) {
			//loadList.shift(); // localizedStrings.js削除
			//baseUrl = 'Resources/';

		// その他
		} else {
			// iGoogle
			if (!!window._IG_Prefs) {
				loadList.shift(); // localizedStrings.js削除
				loadList.shift(); // lib/miniajax.js削除
			}

			var scriptVals = document.getElementsByTagName('script');
			for (var cnt = 0; cnt < scriptVals.length; cnt++) {
				var srcVal = scriptVals[cnt].src;

				var index = srcVal.indexOf('aaoh.kaze.js');
				if (index >= 0) {
					baseUrl = srcVal.substring(0, index);
					break;
				}
			}
		} // if (aaoh.kaze.FLG_WINDOW == 1)

		// ライブラリを追加
		for (var cnt = 0; cnt < loadList.length; cnt++) {
			// Google
			if (aaoh.kaze.FLG_WINDOW == 1) {
				//view.appendElement(libSrc);

			// Yahoo
			} else if (aaoh.kaze.FLG_WINDOW == 2) {
				//var doc    = XMLDOM.createDocument();
				//var libObj = doc.createElement('script');
				//libObj.src = baseUrl + loadList[cnt];
				//widget.appendChild(libObj);

			// その他
			} else {
				var libSrc = '<script src="' + baseUrl + loadList[cnt] + '"'
					+ ' type="text/javascript"></script>';
				document.write(libSrc);
			}
		} // for (var cnt = 0; cnt < loadList.length; cnt++)
	}
}

// windowオブジェクトがあるかの判定
if (!this.window) {
	try {
		if (!!options) {
			aaoh.kaze.FLG_WINDOW = 1;
		}
	} catch(ex) {
	}
	try {
		if (!!widget) {
			aaoh.kaze.FLG_WINDOW = 2;
		}
	} catch(ex) {
	}
}
aaoh.kaze.load();
})();
