# -*- coding: utf-8 -*-
# Copyright 2021 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function

__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# cli_rm_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the module docstring and re-run
# cli_rm_builder.
#
#############################################

"""
The arg spec for the iosxr_bgp_global module
"""


class Bgp_globalArgs(object):  # pylint: disable=R0903
    """The arg spec for the iosxr_bgp_global module
    """

    def __init__(self, **kwargs):
        pass

    argument_spec = {
        "config": {
            "type": "dict",
            "options": {
                "as_number": {"type": "str"},
                "bfd": {
                    "type": "dict",
                    "options": {
                        "minimum_interval": {"type": "int"},
                        "multiplier": {"type": "int"},
                    },
                },
                "bgp": {
                    "type": "dict",
                    "options": {
                        "as_path_loopcheck": {"type": "bool"},
                        "auto_policy_soft_reset": {
                            "type": "dict",
                            "options": {"disable": {"type": "bool"}},
                        },
                        "bestpath": {
                            "type": "dict",
                            "options": {
                                "as_path": {
                                    "type": "dict",
                                    "options": {
                                        "ignore": {"type": "bool"},
                                        "multipath_relax": {"type": "bool"},
                                    },
                                },
                                "aigp": {
                                    "type": "dict",
                                    "options": {"ignore": {"type": "bool"}},
                                },
                                "med": {
                                    "type": "dict",
                                    "options": {
                                        "always": {"type": "bool"},
                                        "confed": {"type": "bool"},
                                        "missing_as_worst": {"type": "bool"},
                                    },
                                },
                                "compare_routerid": {"type": "bool"},
                                "cost_community": {
                                    "type": "dict",
                                    "options": {"ignore": {"type": "bool"}},
                                },
                                "origin_as": {
                                    "type": "dict",
                                    "options": {
                                        "use": {
                                            "type": "dict",
                                            "options": {
                                                "validity": {"type": "bool"}
                                            },
                                        },
                                        "allow": {
                                            "type": "dict",
                                            "options": {
                                                "invalid": {"type": "bool"}
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "cluster_id": {"type": "str"},
                        "confederation": {
                            "type": "dict",
                            "options": {
                                "identifier": {"type": "int"},
                                "peers": {"type": "list", "elements": "int"},
                            },
                        },
                        "default": {
                            "type": "dict",
                            "options": {"local_preference": {"type": "int"}},
                        },
                        "enforce_first_as": {
                            "type": "dict",
                            "options": {"disable": {"type": "bool"}},
                        },
                        "fast_external_fallover": {
                            "type": "dict",
                            "options": {"disable": {"type": "bool"}},
                        },
                        "graceful_restart": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "graceful_reset": {"type": "bool"},
                                "restart_time": {"type": "int"},
                                "purge_time": {"type": "int"},
                                "stalepath_time": {"type": "int"},
                            },
                        },
                        "install": {
                            "type": "dict",
                            "options": {"diversion": {"type": "bool"}},
                        },
                        "log": {
                            "type": "dict",
                            "options": {
                                "log_message": {
                                    "type": "dict",
                                    "options": {"disable": {"type": "bool"}},
                                },
                                "neighbor": {
                                    "type": "dict",
                                    "options": {
                                        "changes": {
                                            "type": "dict",
                                            "options": {
                                                "detail": {"type": "bool"},
                                                "disable": {"type": "bool"},
                                            },
                                        }
                                    },
                                },
                            },
                        },
                        "maximum": {
                            "type": "dict",
                            "options": {"neighbor": {"type": "int"}},
                        },
                        "multipath": {
                            "type": "dict",
                            "options": {
                                "as_path": {
                                    "type": "dict",
                                    "options": {
                                        "ignore": {
                                            "type": "dict",
                                            "options": {
                                                "onwards": {"type": "bool"}
                                            },
                                        }
                                    },
                                }
                            },
                        },
                        "origin_as": {
                            "type": "dict",
                            "options": {
                                "validation": {
                                    "type": "dict",
                                    "options": {
                                        "disable": {"type": "bool"},
                                        "signal": {
                                            "type": "dict",
                                            "options": {
                                                "ibgp": {"type": "bool"}
                                            },
                                        },
                                        "time": {
                                            "type": "dict",
                                            "options": {
                                                "time_off": {"type": "bool"},
                                                "time_in_second": {
                                                    "type": "int"
                                                },
                                            },
                                        },
                                    },
                                }
                            },
                        },
                        "redistribute_internal": {"type": "bool"},
                        "router_id": {"type": "str"},
                        "scan_time": {"type": "int"},
                        "unsafe_ebgp_policy": {"type": "bool"},
                        "update_delay": {"type": "int"},
                    },
                },
                "default_information": {
                    "type": "dict",
                    "options": {"originate": {"type": "bool"}},
                },
                "default_metric": {"type": "int"},
                "graceful_maintenance": {
                    "type": "dict",
                    "options": {
                        "activate": {
                            "type": "str",
                            "choices": [
                                "all-neighbors",
                                "retain-routes",
                                "all-neighbors retain-routes",
                                "",
                            ],
                        }
                    },
                },
                "ibgp": {
                    "type": "dict",
                    "options": {
                        "policy": {
                            "type": "dict",
                            "options": {
                                "out": {
                                    "type": "dict",
                                    "options": {
                                        "enforce_modifications": {
                                            "type": "bool"
                                        }
                                    },
                                }
                            },
                        }
                    },
                },
                "mpls": {
                    "type": "dict",
                    "options": {
                        "activate": {
                            "type": "dict",
                            "options": {"interface": {"type": "str"}},
                        }
                    },
                },
                "mvpn": {"type": "bool"},
                "neighbors": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "neighbor": {"type": "str", "required": True},
                        "advertisement_interval": {"type": "int"},
                        "bfd": {
                            "type": "dict",
                            "options": {
                                "fast_detect": {
                                    "type": "dict",
                                    "options": {
                                        "disable": {"type": "bool"},
                                        "strict_mode": {"type": "bool"},
                                    },
                                },
                                "multiplier": {"type": "int"},
                                "minimum_interval": {"type": "int"},
                            },
                        },
                        "bmp_activate": {
                            "type": "dict",
                            "options": {"server": {"type": "int"}},
                        },
                        "capability": {
                            "type": "dict",
                            "options": {
                                "additional_paths": {
                                    "type": "dict",
                                    "options": {
                                        "send": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "disable": {"type": "bool"},
                                            },
                                        },
                                        "receive": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "disable": {"type": "bool"},
                                            },
                                        },
                                    },
                                },
                                "suppress": {
                                    "type": "dict",
                                    "options": {
                                        "four_byte_AS": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"}
                                            },
                                        },
                                        "all": {
                                            "type": "dict",
                                            "options": {
                                                "inheritance_disable": {
                                                    "type": "bool"
                                                },
                                                "set": {"type": "bool"},
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "cluster_id": {"type": "str"},
                        "description": {"type": "str"},
                        "dmz_link_bandwidth": {
                            "type": "dict",
                            "options": {
                                "inheritance_disable": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                        },
                        "dscp": {"type": "str"},
                        "ebgp_multihop": {
                            "type": "dict",
                            "options": {
                                "value": {"type": "int"},
                                "mpls": {"type": "bool"},
                            },
                        },
                        "ebgp_recv_extcommunity_dmz": {
                            "type": "dict",
                            "options": {
                                "inheritance_disable": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                        },
                        "ebgp_send_extcommunity_dmz": {
                            "type": "dict",
                            "options": {
                                "inheritance_disable": {"type": "bool"},
                                "cumulatie": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                        },
                        "egress_engineering": {
                            "type": "dict",
                            "options": {
                                "inheritance_disable": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                        },
                        "enforce_first_as": {
                            "type": "dict",
                            "options": {"disable": {"type": "bool"}},
                        },
                        "graceful_maintenance": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "activate": {
                                    "type": "dict",
                                    "options": {
                                        "inheritance_disable": {
                                            "type": "bool"
                                        },
                                        "set": {"type": "bool"},
                                    },
                                },
                                "as_prepends": {
                                    "type": "dict",
                                    "options": {
                                        "inheritance_disable": {
                                            "type": "bool"
                                        },
                                        "value": {"type": "int"},
                                    },
                                },
                                "local_preference": {
                                    "type": "dict",
                                    "options": {
                                        "value": {"type": "int"},
                                        "inheritance_disable": {
                                            "type": "bool"
                                        },
                                    },
                                },
                            },
                        },
                        "graceful_restart": {
                            "type": "dict",
                            "options": {
                                "restart_time": {"type": "int"},
                                "stalepath_time": {"type": "int"},
                            },
                        },
                        "ignore_connected_check": {
                            "type": "dict",
                            "options": {
                                "inheritance_disable": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                        },
                        "keychain": {
                            "type": "dict",
                            "no_log": False,
                            "options": {
                                "name": {"type": "str"},
                                "inheritance_disable": {"type": "bool"},
                            },
                        },
                        "local": {
                            "type": "dict",
                            "options": {
                                "address": {
                                    "type": "dict",
                                    "options": {
                                        "ipv4_address": {"type": "str"},
                                        "inheritance_disable": {
                                            "type": "bool"
                                        },
                                    },
                                }
                            },
                        },
                        "local_as": {
                            "type": "dict",
                            "options": {
                                "value": {"type": "int"},
                                "inheritance_disable": {"type": "bool"},
                            },
                        },
                        "log": {
                            "type": "dict",
                            "options": {
                                "log_message": {
                                    "type": "dict",
                                    "options": {
                                        "in": {
                                            "type": "dict",
                                            "options": {
                                                "value": {"type": "int"},
                                                "disable": {"type": "bool"},
                                                "inheritance_disable": {
                                                    "type": "bool"
                                                },
                                            },
                                        },
                                        "out": {
                                            "type": "dict",
                                            "options": {
                                                "value": {"type": "int"},
                                                "disable": {"type": "bool"},
                                                "inheritance_disable": {
                                                    "type": "bool"
                                                },
                                            },
                                        },
                                    },
                                }
                            },
                        },
                        "origin_as": {
                            "type": "dict",
                            "options": {
                                "validation": {
                                    "type": "dict",
                                    "options": {"disable": {"type": "bool"}},
                                }
                            },
                        },
                        "receive_buffer_size": {"type": "int"},
                        "remote_as": {"type": "int"},
                        "send_buffer_size": {"type": "int"},
                        "session_open_mode": {
                            "type": "str",
                            "choices": ["active-only", "both", "passive-only"],
                        },
                        "shutdown": {
                            "type": "dict",
                            "options": {
                                "inheritance_disable": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                        },
                        "tcp": {
                            "type": "dict",
                            "options": {
                                "mss": {
                                    "type": "dict",
                                    "options": {
                                        "value": {"type": "int"},
                                        "inheritance_disable": {
                                            "type": "bool"
                                        },
                                    },
                                }
                            },
                        },
                        "timers": {
                            "type": "dict",
                            "options": {
                                "keepalive_time": {"type": "int"},
                                "holdtime": {"type": "int"},
                            },
                        },
                        "ttl_security": {
                            "type": "dict",
                            "options": {
                                "inheritance_disable": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                        },
                        "update": {
                            "type": "dict",
                            "options": {
                                "in": {
                                    "type": "dict",
                                    "options": {
                                        "filtering": {
                                            "type": "dict",
                                            "options": {
                                                "attribute_filter": {
                                                    "type": "dict",
                                                    "options": {
                                                        "group": {
                                                            "type": "str"
                                                        }
                                                    },
                                                },
                                                "logging": {
                                                    "type": "dict",
                                                    "options": {
                                                        "disable": {
                                                            "type": "bool"
                                                        }
                                                    },
                                                },
                                                "update_message": {
                                                    "type": "dict",
                                                    "options": {
                                                        "buffers": {
                                                            "type": "int"
                                                        }
                                                    },
                                                },
                                            },
                                        }
                                    },
                                }
                            },
                        },
                        "update_source": {"type": "str"},
                    },
                },
                "nsr": {
                    "type": "dict",
                    "options": {
                        "set": {"type": "bool"},
                        "disable": {"type": "bool"},
                    },
                },
                "socket": {
                    "type": "dict",
                    "options": {
                        "receive_buffer_size": {"type": "int"},
                        "send_buffer_size": {"type": "int"},
                    },
                },
                "timers": {
                    "type": "dict",
                    "options": {
                        "keepalive_time": {"type": "int"},
                        "holdtime": {"type": "int"},
                    },
                },
                "update": {
                    "type": "dict",
                    "options": {
                        "in": {
                            "type": "dict",
                            "options": {
                                "error_handling": {
                                    "type": "dict",
                                    "options": {
                                        "basic": {
                                            "type": "dict",
                                            "options": {
                                                "ebgp": {
                                                    "type": "dict",
                                                    "options": {
                                                        "disable": {
                                                            "type": "bool"
                                                        }
                                                    },
                                                },
                                                "ibgp": {
                                                    "type": "dict",
                                                    "options": {
                                                        "disable": {
                                                            "type": "bool"
                                                        }
                                                    },
                                                },
                                            },
                                        },
                                        "extended": {
                                            "type": "dict",
                                            "options": {
                                                "ebgp": {"type": "bool"},
                                                "ibgp": {"type": "bool"},
                                            },
                                        },
                                    },
                                }
                            },
                        },
                        "out": {
                            "type": "dict",
                            "options": {"logging": {"type": "bool"}},
                        },
                        "limit": {"type": "int"},
                    },
                },
                "rpki": {
                    "type": "dict",
                    "options": {
                        "route": {
                            "type": "dict",
                            "options": {
                                "value": {"type": "str"},
                                "max": {"type": "int"},
                                "origin": {"type": "int"},
                            },
                        },
                        "servers": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "name": {"type": "str"},
                                "purge_time": {"type": "int"},
                                "refresh_time": {
                                    "type": "dict",
                                    "options": {
                                        "value": {"type": "int"},
                                        "time_off": {"type": "bool"},
                                    },
                                },
                                "response_time": {
                                    "type": "dict",
                                    "options": {
                                        "value": {"type": "int"},
                                        "time_off": {"type": "bool"},
                                    },
                                },
                                "shutdown": {"type": "bool"},
                                "transport": {
                                    "type": "dict",
                                    "options": {
                                        "ssh": {
                                            "type": "dict",
                                            "options": {
                                                "port": {"type": "int"}
                                            },
                                        },
                                        "tcp": {
                                            "type": "dict",
                                            "options": {
                                                "port": {"type": "int"}
                                            },
                                        },
                                    },
                                },
                            },
                        },
                    },
                },
                "vrfs": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "vrf": {"type": "str"},
                        "bfd": {
                            "type": "dict",
                            "options": {
                                "minimum_interval": {"type": "int"},
                                "multiplier": {"type": "int"},
                            },
                        },
                        "bgp": {
                            "type": "dict",
                            "options": {
                                "auto_policy_soft_reset": {
                                    "type": "dict",
                                    "options": {"disable": {"type": "bool"}},
                                },
                                "bestpath": {
                                    "type": "dict",
                                    "options": {
                                        "as_path": {
                                            "type": "dict",
                                            "options": {
                                                "ignore": {"type": "bool"},
                                                "multipath_relax": {
                                                    "type": "bool"
                                                },
                                            },
                                        },
                                        "aigp": {
                                            "type": "dict",
                                            "options": {
                                                "ignore": {"type": "bool"}
                                            },
                                        },
                                        "med": {
                                            "type": "dict",
                                            "options": {
                                                "always": {"type": "bool"},
                                                "confed": {"type": "bool"},
                                                "missing_as_worst": {
                                                    "type": "bool"
                                                },
                                            },
                                        },
                                        "compare_routerid": {"type": "bool"},
                                        "cost_community": {
                                            "type": "dict",
                                            "options": {
                                                "ignore": {"type": "bool"}
                                            },
                                        },
                                        "origin_as": {
                                            "type": "dict",
                                            "options": {
                                                "use": {
                                                    "type": "dict",
                                                    "options": {
                                                        "validity": {
                                                            "type": "bool"
                                                        }
                                                    },
                                                },
                                                "allow": {
                                                    "type": "dict",
                                                    "options": {
                                                        "invalid": {
                                                            "type": "bool"
                                                        }
                                                    },
                                                },
                                            },
                                        },
                                    },
                                },
                                "default": {
                                    "type": "dict",
                                    "options": {
                                        "local_preference": {"type": "int"}
                                    },
                                },
                                "enforce_first_as": {
                                    "type": "dict",
                                    "options": {"disable": {"type": "bool"}},
                                },
                                "fast_external_fallover": {
                                    "type": "dict",
                                    "options": {"disable": {"type": "bool"}},
                                },
                                "log": {
                                    "type": "dict",
                                    "options": {
                                        "log_message": {
                                            "type": "dict",
                                            "options": {
                                                "disable": {"type": "bool"}
                                            },
                                        },
                                        "neighbor": {
                                            "type": "dict",
                                            "options": {
                                                "changes": {
                                                    "type": "dict",
                                                    "options": {
                                                        "detail": {
                                                            "type": "bool"
                                                        },
                                                        "disable": {
                                                            "type": "bool"
                                                        },
                                                    },
                                                }
                                            },
                                        },
                                    },
                                },
                                "multipath": {
                                    "type": "dict",
                                    "options": {
                                        "as_path": {
                                            "type": "dict",
                                            "options": {
                                                "ignore": {
                                                    "type": "dict",
                                                    "options": {
                                                        "onwards": {
                                                            "type": "bool"
                                                        }
                                                    },
                                                }
                                            },
                                        }
                                    },
                                },
                                "redistribute_internal": {"type": "bool"},
                                "router_id": {"type": "str"},
                                "unsafe_ebgp_policy": {"type": "bool"},
                            },
                        },
                        "default_information": {
                            "type": "dict",
                            "options": {"originate": {"type": "bool"}},
                        },
                        "default_metric": {"type": "int"},
                        "mpls": {
                            "type": "dict",
                            "options": {
                                "activate": {
                                    "type": "dict",
                                    "options": {"interface": {"type": "str"}},
                                }
                            },
                        },
                        "neighbors": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "neighbor": {"type": "str", "required": True},
                                "advertisement_interval": {"type": "int"},
                                "bfd": {
                                    "type": "dict",
                                    "options": {
                                        "fast_detect": {
                                            "type": "dict",
                                            "options": {
                                                "disable": {"type": "bool"},
                                                "strict_mode": {
                                                    "type": "bool"
                                                },
                                            },
                                        },
                                        "multiplier": {"type": "int"},
                                        "minimum_interval": {"type": "int"},
                                    },
                                },
                                "bmp_activate": {
                                    "type": "dict",
                                    "options": {"server": {"type": "int"}},
                                },
                                "capability": {
                                    "type": "dict",
                                    "options": {
                                        "additional_paths": {
                                            "type": "dict",
                                            "options": {
                                                "send": {
                                                    "type": "dict",
                                                    "options": {
                                                        "set": {
                                                            "type": "bool"
                                                        },
                                                        "disable": {
                                                            "type": "bool"
                                                        },
                                                    },
                                                },
                                                "receive": {
                                                    "type": "dict",
                                                    "options": {
                                                        "set": {
                                                            "type": "bool"
                                                        },
                                                        "disable": {
                                                            "type": "bool"
                                                        },
                                                    },
                                                },
                                            },
                                        },
                                        "suppress": {
                                            "type": "dict",
                                            "options": {
                                                "four_byte_AS": {
                                                    "type": "dict",
                                                    "options": {
                                                        "set": {"type": "bool"}
                                                    },
                                                },
                                                "all": {
                                                    "type": "dict",
                                                    "options": {
                                                        "inheritance_disable": {
                                                            "type": "bool"
                                                        },
                                                        "set": {
                                                            "type": "bool"
                                                        },
                                                    },
                                                },
                                            },
                                        },
                                    },
                                },
                                "cluster_id": {"type": "str"},
                                "description": {"type": "str"},
                                "dmz_link_bandwidth": {
                                    "type": "dict",
                                    "options": {
                                        "inheritance_disable": {
                                            "type": "bool"
                                        },
                                        "set": {"type": "bool"},
                                    },
                                },
                                "dscp": {"type": "str"},
                                "ebgp_multihop": {
                                    "type": "dict",
                                    "options": {
                                        "value": {"type": "int"},
                                        "mpls": {"type": "bool"},
                                    },
                                },
                                "ebgp_recv_extcommunity_dmz": {
                                    "type": "dict",
                                    "options": {
                                        "inheritance_disable": {
                                            "type": "bool"
                                        },
                                        "set": {"type": "bool"},
                                    },
                                },
                                "ebgp_send_extcommunity_dmz": {
                                    "type": "dict",
                                    "options": {
                                        "inheritance_disable": {
                                            "type": "bool"
                                        },
                                        "cumulatie": {"type": "bool"},
                                        "set": {"type": "bool"},
                                    },
                                },
                                "egress_engineering": {
                                    "type": "dict",
                                    "options": {
                                        "inheritance_disable": {
                                            "type": "bool"
                                        },
                                        "set": {"type": "bool"},
                                    },
                                },
                                "enforce_first_as": {
                                    "type": "dict",
                                    "options": {"disable": {"type": "bool"}},
                                },
                                "graceful_maintenance": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "activate": {
                                            "type": "dict",
                                            "options": {
                                                "inheritance_disable": {
                                                    "type": "bool"
                                                },
                                                "set": {"type": "bool"},
                                            },
                                        },
                                        "as_prepends": {
                                            "type": "dict",
                                            "options": {
                                                "inheritance_disable": {
                                                    "type": "bool"
                                                },
                                                "value": {"type": "int"},
                                            },
                                        },
                                        "local_preference": {
                                            "type": "dict",
                                            "options": {
                                                "value": {"type": "int"},
                                                "inheritance_disable": {
                                                    "type": "bool"
                                                },
                                            },
                                        },
                                    },
                                },
                                "graceful_restart": {
                                    "type": "dict",
                                    "options": {
                                        "restart_time": {"type": "int"},
                                        "stalepath_time": {"type": "int"},
                                    },
                                },
                                "ignore_connected_check": {
                                    "type": "dict",
                                    "options": {
                                        "inheritance_disable": {
                                            "type": "bool"
                                        },
                                        "set": {"type": "bool"},
                                    },
                                },
                                "keychain": {
                                    "type": "dict",
                                    "no_log": False,
                                    "options": {
                                        "name": {"type": "str"},
                                        "inheritance_disable": {
                                            "type": "bool"
                                        },
                                    },
                                },
                                "local": {
                                    "type": "dict",
                                    "options": {
                                        "address": {
                                            "type": "dict",
                                            "options": {
                                                "ipv4_address": {
                                                    "type": "str"
                                                },
                                                "inheritance_disable": {
                                                    "type": "bool"
                                                },
                                            },
                                        }
                                    },
                                },
                                "local_as": {
                                    "type": "dict",
                                    "options": {
                                        "value": {"type": "int"},
                                        "inheritance_disable": {
                                            "type": "bool"
                                        },
                                    },
                                },
                                "log": {
                                    "type": "dict",
                                    "options": {
                                        "log_message": {
                                            "type": "dict",
                                            "options": {
                                                "in": {
                                                    "type": "dict",
                                                    "options": {
                                                        "value": {
                                                            "type": "int"
                                                        },
                                                        "disable": {
                                                            "type": "bool"
                                                        },
                                                        "inheritance_disable": {
                                                            "type": "bool"
                                                        },
                                                    },
                                                },
                                                "out": {
                                                    "type": "dict",
                                                    "options": {
                                                        "value": {
                                                            "type": "int"
                                                        },
                                                        "disable": {
                                                            "type": "bool"
                                                        },
                                                        "inheritance_disable": {
                                                            "type": "bool"
                                                        },
                                                    },
                                                },
                                            },
                                        }
                                    },
                                },
                                "origin_as": {
                                    "type": "dict",
                                    "options": {
                                        "validation": {
                                            "type": "dict",
                                            "options": {
                                                "disable": {"type": "bool"}
                                            },
                                        }
                                    },
                                },
                                "receive_buffer_size": {"type": "int"},
                                "remote_as": {"type": "int"},
                                "send_buffer_size": {"type": "int"},
                                "session_open_mode": {
                                    "type": "str",
                                    "choices": [
                                        "active-only",
                                        "both",
                                        "passive-only",
                                    ],
                                },
                                "shutdown": {
                                    "type": "dict",
                                    "options": {
                                        "inheritance_disable": {
                                            "type": "bool"
                                        },
                                        "set": {"type": "bool"},
                                    },
                                },
                                "tcp": {
                                    "type": "dict",
                                    "options": {
                                        "mss": {
                                            "type": "dict",
                                            "options": {
                                                "value": {"type": "int"},
                                                "inheritance_disable": {
                                                    "type": "bool"
                                                },
                                            },
                                        }
                                    },
                                },
                                "timers": {
                                    "type": "dict",
                                    "options": {
                                        "keepalive_time": {"type": "int"},
                                        "holdtime": {"type": "int"},
                                    },
                                },
                                "ttl_security": {
                                    "type": "dict",
                                    "options": {
                                        "inheritance_disable": {
                                            "type": "bool"
                                        },
                                        "set": {"type": "bool"},
                                    },
                                },
                                "update": {
                                    "type": "dict",
                                    "options": {
                                        "in": {
                                            "type": "dict",
                                            "options": {
                                                "filtering": {
                                                    "type": "dict",
                                                    "options": {
                                                        "attribute_filter": {
                                                            "type": "dict",
                                                            "options": {
                                                                "group": {
                                                                    "type": "str"
                                                                }
                                                            },
                                                        },
                                                        "logging": {
                                                            "type": "dict",
                                                            "options": {
                                                                "disable": {
                                                                    "type": "bool"
                                                                }
                                                            },
                                                        },
                                                        "update_message": {
                                                            "type": "dict",
                                                            "options": {
                                                                "buffers": {
                                                                    "type": "int"
                                                                }
                                                            },
                                                        },
                                                    },
                                                }
                                            },
                                        }
                                    },
                                },
                                "update_source": {"type": "str"},
                            },
                        },
                        "rd": {
                            "type": "dict",
                            "options": {"auto": {"type": "bool"}},
                        },
                        "socket": {
                            "type": "dict",
                            "options": {
                                "receive_buffer_size": {"type": "int"},
                                "send_buffer_size": {"type": "int"},
                            },
                        },
                        "timers": {
                            "type": "dict",
                            "options": {
                                "keepalive_time": {"type": "int"},
                                "holdtime": {"type": "int"},
                            },
                        },
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "type": "str",
            "choices": [
                "deleted",
                "merged",
                "replaced",
                "gathered",
                "rendered",
                "parsed",
                "purged",
            ],
            "default": "merged",
        },
    }  # pylint: disable=C0301
