#!/usr/local/bin/python3.8
# -*- coding: utf-8 -*-
# Copyright 2019 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for vyos_lag_interfaces
"""

from __future__ import absolute_import, division, print_function

__metaclass__ = type


DOCUMENTATION = """
module: vyos_lag_interfaces
short_description: LAG interfaces resource module
description: This module manages attributes of link aggregation groups on VyOS network
  devices.
version_added: 1.0.0
notes:
- Tested against VyOS 1.1.8 (helium).
- This module works with connection C(network_cli). See L(the VyOS OS Platform Options,../network/user_guide/platform_vyos.html).
author: Rohit Thakur (@rohitthakur2590)
options:
  config:
    description: A list of link aggregation group configurations.
    type: list
    elements: dict
    suboptions:
      name:
        description:
        - Name of the link aggregation group (LAG) or bond.
        type: str
        required: true
      mode:
        description:
        - LAG or bond mode.
        type: str
        choices:
        - 802.3ad
        - active-backup
        - broadcast
        - round-robin
        - transmit-load-balance
        - adaptive-load-balance
        - xor-hash
      members:
        description:
        - List of member interfaces for the LAG (bond).
        type: list
        elements: dict
        suboptions:
          member:
            description:
            - Name of the member interface.
            type: str
      primary:
        description:
        - Primary device interfaces for the LAG (bond).
        type: str
      hash_policy:
        description:
        - LAG or bonding transmit hash policy.
        type: str
        choices:
        - layer2
        - layer2+3
        - layer3+4
      arp_monitor:
        description:
        - ARP Link monitoring parameters.
        type: dict
        suboptions:
          interval:
            description:
            - ARP link monitoring frequency in milliseconds.
            type: int
          target:
            description:
            - IP address to use for ARP monitoring.
            type: list
            elements: str
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the VyOS device
      by executing the command B(show configuration commands | grep bond).
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result.
    type: str
  state:
    description:
    - The state of the configuration after module completion.
    type: str
    choices:
    - merged
    - replaced
    - overridden
    - deleted
    - parsed
    - gathered
    - rendered
    default: merged
"""
EXAMPLES = """
# Using merged
#
# Before state:
# -------------
#
# vyos@vyos:~$ show configuration  commands | grep bond
# set interfaces bonding bond2
# set interfaces bonding bond3
#
- name: Merge provided configuration with device configuration
  vyos.vyos.vyos_lag_interfaces:
    config:
    - name: bond2
      mode: active-backup
      members:
      - member: eth2
      - member: eth1
      hash_policy: layer2
      primary: eth2

    - name: bond3
      mode: active-backup
      hash_policy: layer2+3
      members:
      - member: eth3
      primary: eth3
    state: merged
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#    "before": [
#        {
#            "name": "bond2"
#        },
#        {
#            "name": "bond3"
#        }
#    ],
#
# "commands": [
#        "set interfaces bonding bond2 hash-policy 'layer2'",
#        "set interfaces bonding bond2 mode 'active-backup'",
#        "set interfaces ethernet eth2 bond-group bond2",
#        "set interfaces ethernet eth1 bond-group bond2",
#        "set interfaces bonding bond2 primary 'eth2'",
#        "set interfaces bonding bond3 hash-policy 'layer2+3'",
#        "set interfaces bonding bond3 mode 'active-backup'",
#        "set interfaces ethernet eth3 bond-group bond3",
#        "set interfaces bonding bond3 primary 'eth3'"
#    ]
#
#     "after": [
#        {
#            "hash_policy": "layer2",
#            "members": [
#                {
#                    "member": "eth1"
#                },
#                {
#                    "member": "eth2"
#                }
#            ],
#            "mode": "active-backup",
#            "name": "bond2",
#            "primary": "eth2"
#        },
#        {
#            "hash_policy": "layer2+3",
#            "members": [
#                {
#                    "member": "eth3"
#                }
#            ],
#            "mode": "active-backup",
#            "name": "bond3",
#            "primary": "eth3"
#        }
#    ]
#
# After state:
# -------------
#
# vyos@vyos:~$ show configuration  commands | grep bond
# set interfaces bonding bond2 hash-policy 'layer2'
# set interfaces bonding bond2 mode 'active-backup'
# set interfaces bonding bond2 primary 'eth2'
# set interfaces bonding bond3 hash-policy 'layer2+3'
# set interfaces bonding bond3 mode 'active-backup'
# set interfaces bonding bond3 primary 'eth3'
# set interfaces ethernet eth1 bond-group 'bond2'
# set interfaces ethernet eth2 bond-group 'bond2'
# set interfaces ethernet eth3 bond-group 'bond3'


# Using replaced
#
# Before state:
# -------------
#
# vyos@vyos:~$ show configuration  commands | grep bond
# set interfaces bonding bond2 hash-policy 'layer2'
# set interfaces bonding bond2 mode 'active-backup'
# set interfaces bonding bond2 primary 'eth2'
# set interfaces bonding bond3 hash-policy 'layer2+3'
# set interfaces bonding bond3 mode 'active-backup'
# set interfaces bonding bond3 primary 'eth3'
# set interfaces ethernet eth1 bond-group 'bond2'
# set interfaces ethernet eth2 bond-group 'bond2'
# set interfaces ethernet eth3 bond-group 'bond3'
#
- name: Replace device configurations of listed LAGs with provided configurations
  vyos.vyos.vyos_lag_interfaces:
    config:
    - name: bond3
      mode: 802.3ad
      hash_policy: layer2
      members:
      - member: eth3
    state: replaced
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#    "before": [
#        {
#            "hash_policy": "layer2",
#            "members": [
#                {
#                    "member": "eth1"
#                },
#                {
#                    "member": "eth2"
#                }
#            ],
#            "mode": "active-backup",
#            "name": "bond2",
#            "primary": "eth2"
#        },
#        {
#            "hash_policy": "layer2+3",
#            "members": [
#                {
#                    "member": "eth3"
#                }
#            ],
#            "mode": "active-backup",
#            "name": "bond3",
#            "primary": "eth3"
#        }
#    ],
#
# "commands": [
#        "delete interfaces bonding bond3 primary",
#        "set interfaces bonding bond3 hash-policy 'layer2'",
#        "set interfaces bonding bond3 mode '802.3ad'"
#    ],
#
# "after": [
#        {
#            "hash_policy": "layer2",
#            "members": [
#                {
#                    "member": "eth1"
#                },
#                {
#                    "member": "eth2"
#                }
#            ],
#            "mode": "active-backup",
#            "name": "bond2",
#            "primary": "eth2"
#        },
#        {
#            "hash_policy": "layer2",
#            "members": [
#                {
#                    "member": "eth3"
#                }
#            ],
#            "mode": "802.3ad",
#            "name": "bond3"
#        }
#    ],
#
# After state:
# -------------
#
# vyos@vyos:~$ show configuration  commands | grep bond
# set interfaces bonding bond2 hash-policy 'layer2'
# set interfaces bonding bond2 mode 'active-backup'
# set interfaces bonding bond2 primary 'eth2'
# set interfaces bonding bond3 hash-policy 'layer2'
# set interfaces bonding bond3 mode '802.3ad'
# set interfaces ethernet eth1 bond-group 'bond2'
# set interfaces ethernet eth2 bond-group 'bond2'
# set interfaces ethernet eth3 bond-group 'bond3'


# Using overridden
#
# Before state
# --------------
#
# vyos@vyos:~$ show configuration  commands | grep bond
# set interfaces bonding bond2 hash-policy 'layer2'
# set interfaces bonding bond2 mode 'active-backup'
# set interfaces bonding bond2 primary 'eth2'
# set interfaces bonding bond3 hash-policy 'layer2'
# set interfaces bonding bond3 mode '802.3ad'
# set interfaces ethernet eth1 bond-group 'bond2'
# set interfaces ethernet eth2 bond-group 'bond2'
# set interfaces ethernet eth3 bond-group 'bond3'
#
- name: Overrides all device configuration with provided configuration
  vyos.vyos.vyos_lag_interfaces:
    config:
    - name: bond3
      mode: active-backup
      members:
      - member: eth1
      - member: eth2
      - member: eth3
      primary: eth3
      hash_policy: layer2
    state: overridden
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#    "before": [
#        {
#            "hash_policy": "layer2",
#            "members": [
#                {
#                    "member": "eth1"
#                },
#                {
#                    "member": "eth2"
#                }
#            ],
#            "mode": "active-backup",
#            "name": "bond2",
#            "primary": "eth2"
#        },
#        {
#            "hash_policy": "layer2",
#            "members": [
#                {
#                    "member": "eth3"
#                }
#            ],
#            "mode": "802.3ad",
#            "name": "bond3"
#        }
#    ],
#
#    "commands": [
#        "delete interfaces bonding bond2 hash-policy",
#        "delete interfaces ethernet eth1 bond-group bond2",
#        "delete interfaces ethernet eth2 bond-group bond2",
#        "delete interfaces bonding bond2 mode",
#        "delete interfaces bonding bond2 primary",
#        "set interfaces bonding bond3 mode 'active-backup'",
#        "set interfaces ethernet eth1 bond-group bond3",
#        "set interfaces ethernet eth2 bond-group bond3",
#        "set interfaces bonding bond3 primary 'eth3'"
#    ],
#
# "after": [
#        {
#            "name": "bond2"
#        },
#        {
#            "hash_policy": "layer2",
#            "members": [
#                {
#                    "member": "eth1"
#                },
#                {
#                    "member": "eth2"
#                },
#                {
#                    "member": "eth3"
#                }
#            ],
#            "mode": "active-backup",
#            "name": "bond3",
#            "primary": "eth3"
#        }
#    ],
#
#
# After state
# ------------
#
# vyos@vyos:~$ show configuration  commands | grep bond
# set interfaces bonding bond2
# set interfaces bonding bond3 hash-policy 'layer2'
# set interfaces bonding bond3 mode 'active-backup'
# set interfaces bonding bond3 primary 'eth3'
# set interfaces ethernet eth1 bond-group 'bond3'
# set interfaces ethernet eth2 bond-group 'bond3'
# set interfaces ethernet eth3 bond-group 'bond3'


# Using deleted
#
# Before state
# -------------
#
# vyos@vyos:~$ show configuration  commands | grep bond
# set interfaces bonding bond2 hash-policy 'layer2'
# set interfaces bonding bond2 mode 'active-backup'
# set interfaces bonding bond2 primary 'eth2'
# set interfaces bonding bond3 hash-policy 'layer2+3'
# set interfaces bonding bond3 mode 'active-backup'
# set interfaces bonding bond3 primary 'eth3'
# set interfaces ethernet eth1 bond-group 'bond2'
# set interfaces ethernet eth2 bond-group 'bond2'
# set interfaces ethernet eth3 bond-group 'bond3'
#
- name: Delete LAG attributes of given interfaces (Note This won't delete the interface
    itself)
  vyos.vyos.vyos_lag_interfaces:
    config:
    - name: bond2
    - name: bond3
    state: deleted
#
#
# ------------------------
# Module Execution Results
# ------------------------
#
# "before": [
#        {
#            "hash_policy": "layer2",
#            "members": [
#                {
#                    "member": "eth1"
#                },
#                {
#                    "member": "eth2"
#                }
#            ],
#            "mode": "active-backup",
#            "name": "bond2",
#            "primary": "eth2"
#        },
#        {
#            "hash_policy": "layer2+3",
#            "members": [
#                {
#                    "member": "eth3"
#                }
#            ],
#            "mode": "active-backup",
#            "name": "bond3",
#            "primary": "eth3"
#        }
#    ],
# "commands": [
#        "delete interfaces bonding bond2 hash-policy",
#        "delete interfaces ethernet eth1 bond-group bond2",
#        "delete interfaces ethernet eth2 bond-group bond2",
#        "delete interfaces bonding bond2 mode",
#        "delete interfaces bonding bond2 primary",
#        "delete interfaces bonding bond3 hash-policy",
#        "delete interfaces ethernet eth3 bond-group bond3",
#        "delete interfaces bonding bond3 mode",
#        "delete interfaces bonding bond3 primary"
#    ],
#
# "after": [
#        {
#            "name": "bond2"
#        },
#        {
#            "name": "bond3"
#        }
#    ],
#
# After state
# ------------
# vyos@vyos:~$ show configuration  commands | grep bond
# set interfaces bonding bond2
# set interfaces bonding bond3


# Using gathered
#
# Before state:
# -------------
#
# vyos@192# run show configuration commands | grep bond
# set interfaces bonding bond0 hash-policy 'layer2'
# set interfaces bonding bond0 mode 'active-backup'
# set interfaces bonding bond0 primary 'eth1'
# set interfaces bonding bond1 hash-policy 'layer2+3'
# set interfaces bonding bond1 mode 'active-backup'
# set interfaces bonding bond1 primary 'eth2'
# set interfaces ethernet eth1 bond-group 'bond0'
# set interfaces ethernet eth2 bond-group 'bond1'
#
- name: Gather listed  lag interfaces with provided configurations
  vyos.vyos.vyos_lag_interfaces:
    config:
    state: gathered
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#    "gathered": [
#        {
#            "afi": "ipv6",
#            "rule_sets": [
#                {
#                    "default_action": "accept",
#                    "description": "This is ipv6 specific rule-set",
#                    "name": "UPLINK",
#                    "rules": [
#                        {
#                            "action": "accept",
#                            "description": "Fwipv6-Rule 1 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 1
#                        },
#                        {
#                            "action": "accept",
#                            "description": "Fwipv6-Rule 2 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 2
#                        }
#                    ]
#                }
#            ]
#        },
#        {
#            "afi": "ipv4",
#            "rule_sets": [
#                {
#                    "default_action": "accept",
#                    "description": "IPv4 INBOUND rule set",
#                    "name": "INBOUND",
#                    "rules": [
#                        {
#                            "action": "accept",
#                            "description": "Rule 101 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 101
#                        },
#                        {
#                            "action": "reject",
#                            "description": "Rule 102 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 102
#                        },
#                        {
#                            "action": "accept",
#                            "description": "Rule 103 is configured by Ansible",
#                            "destination": {
#                                "group": {
#                                    "address_group": "inbound"
#                                }
#                            },
#                            "number": 103,
#                            "source": {
#                                "address": "192.0.2.0"
#                            },
#                            "state": {
#                                "established": true,
#                                "invalid": false,
#                                "new": false,
#                                "related": true
#                            }
#                        }
#                    ]
#                }
#            ]
#        }
#    ]
#
#
# After state:
# -------------
#
# vyos@192# run show configuration commands | grep bond
# set interfaces bonding bond0 hash-policy 'layer2'
# set interfaces bonding bond0 mode 'active-backup'
# set interfaces bonding bond0 primary 'eth1'
# set interfaces bonding bond1 hash-policy 'layer2+3'
# set interfaces bonding bond1 mode 'active-backup'
# set interfaces bonding bond1 primary 'eth2'
# set interfaces ethernet eth1 bond-group 'bond0'
# set interfaces ethernet eth2 bond-group 'bond1'


# Using rendered
#
#
- name: Render the commands for provided  configuration
  vyos.vyos.vyos_lag_interfaces:
    config:
    - name: bond0
      hash_policy: layer2
      members:
      - member: eth1
      mode: active-backup
      primary: eth1
    - name: bond1
      hash_policy: layer2+3
      members:
      - member: eth2
      mode: active-backup
      primary: eth2
    state: rendered
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "rendered": [
#        "set interfaces bonding bond0 hash-policy 'layer2'",
#        "set interfaces ethernet eth1 bond-group 'bond0'",
#        "set interfaces bonding bond0 mode 'active-backup'",
#        "set interfaces bonding bond0 primary 'eth1'",
#        "set interfaces bonding bond1 hash-policy 'layer2+3'",
#        "set interfaces ethernet eth2 bond-group 'bond1'",
#        "set interfaces bonding bond1 mode 'active-backup'",
#        "set interfaces bonding bond1 primary 'eth2'"
#    ]


# Using parsed
#
#
- name: Parsed the commands for provided  configuration
  vyos.vyos.vyos_l3_interfaces:
    running_config:
      "set interfaces bonding bond0 hash-policy 'layer2'
       set interfaces bonding bond0 mode 'active-backup'
       set interfaces bonding bond0 primary 'eth1'
       set interfaces bonding bond1 hash-policy 'layer2+3'
       set interfaces bonding bond1 mode 'active-backup'
       set interfaces bonding bond1 primary 'eth2'
       set interfaces ethernet eth1 bond-group 'bond0'
       set interfaces ethernet eth2 bond-group 'bond1'"
    state: parsed
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "parsed": [
#         {
#             "hash_policy": "layer2",
#             "members": [
#                 {
#                     "member": "eth1"
#                 }
#             ],
#             "mode": "active-backup",
#             "name": "bond0",
#             "primary": "eth1"
#         },
#         {
#             "hash_policy": "layer2+3",
#             "members": [
#                 {
#                     "member": "eth2"
#                 }
#             ],
#             "mode": "active-backup",
#             "name": "bond1",
#             "primary": "eth2"
#         }
#     ]


"""
RETURN = """
before:
  description: The configuration as structured data prior to module invocation.
  returned: always
  type: list
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
after:
  description: The configuration as structured data after module completion.
  returned: when changed
  type: list
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample:
    - 'set interfaces bonding bond2'
    - 'set interfaces bonding bond2 hash-policy layer2'
"""


from ansible.module_utils.basic import AnsibleModule
from ansible_collections.vyos.vyos.plugins.module_utils.network.vyos.argspec.lag_interfaces.lag_interfaces import (
    Lag_interfacesArgs,
)
from ansible_collections.vyos.vyos.plugins.module_utils.network.vyos.config.lag_interfaces.lag_interfaces import (
    Lag_interfaces,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]
    mutually_exclusive = [("config", "running_config")]

    module = AnsibleModule(
        argument_spec=Lag_interfacesArgs.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
        mutually_exclusive=mutually_exclusive,
    )

    result = Lag_interfaces(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
