require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_Z_UTIL_H)) {
    eval 'sub _Z_UTIL_H () {1;}' unless defined(&_Z_UTIL_H);
    eval 'sub ZEXPORT () {1;}' unless defined(&ZEXPORT);
    if(defined(&_KERNEL)) {
	require 'sys/zlib.ph';
    } else {
	require 'sys/zlib.ph';
    }
    if(defined(&_KERNEL)) {
	require 'sys/types.ph';
	require 'sys/time.ph';
	require 'sys/systm.ph';
	require 'sys/module.ph';
	require 'sys/errno.ph';
	require 'sys/param.ph';
	require 'sys/kernel.ph';
	eval 'sub HAVE_MEMCPY () {1;}' unless defined(&HAVE_MEMCPY);
	eval 'sub memcpy {
	    my($d, $s, $n) = @_;
    	    eval q( &bcopy(($s), ($d), ($n)));
	}' unless defined(&memcpy);
	eval 'sub memset {
	    my($d, $v, $n) = @_;
    	    eval q( &bzero(($d), ($n)));
	}' unless defined(&memset);
	eval 'sub memcmp () { &bcmp;}' unless defined(&memcmp);
    } else {
	if(defined(&__KERNEL__)) {
	    require 'linux/string.ph';
	    eval 'sub HAVE_MEMCPY () {1;}' unless defined(&HAVE_MEMCPY);
	} else {
	    if(defined(&MSDOS)||defined(&VMS)||defined(&CRAY)||defined(&WIN32)||defined(&RISCOS)) {
		require 'stddef.ph';
		require 'errno.ph';
	    } else {
	    }
	    if(defined(&STDC)) {
		require 'string.ph';
		require 'stdlib.ph';
	    }
	}
    }
    unless(defined(&local)) {
	eval 'sub local () { &static;}' unless defined(&local);
    }
    eval 'sub ERR_MSG {
        my($err) = @_;
	    eval q( $z_errmsg[ &Z_NEED_DICT-($err)]);
    }' unless defined(&ERR_MSG);
    eval 'sub ERR_RETURN {
        my($strm,$err) = @_;
	    eval q( &return ( ($strm->{msg}) = ( &const \'char\'*) &ERR_MSG($err), ($err)));
    }' unless defined(&ERR_RETURN);
    unless(defined(&DEF_WBITS)) {
	eval 'sub DEF_WBITS () { &MAX_WBITS;}' unless defined(&DEF_WBITS);
    }
    if((defined(&MAX_MEM_LEVEL) ? &MAX_MEM_LEVEL : undef) >= 8) {
	eval 'sub DEF_MEM_LEVEL () {8;}' unless defined(&DEF_MEM_LEVEL);
    } else {
	eval 'sub DEF_MEM_LEVEL () { &MAX_MEM_LEVEL;}' unless defined(&DEF_MEM_LEVEL);
    }
    eval 'sub STORED_BLOCK () {0;}' unless defined(&STORED_BLOCK);
    eval 'sub STATIC_TREES () {1;}' unless defined(&STATIC_TREES);
    eval 'sub DYN_TREES () {2;}' unless defined(&DYN_TREES);
    eval 'sub MIN_MATCH () {3;}' unless defined(&MIN_MATCH);
    eval 'sub MAX_MATCH () {258;}' unless defined(&MAX_MATCH);
    eval 'sub PRESET_DICT () {0x20;}' unless defined(&PRESET_DICT);
    if(defined(&MSDOS)) {
	eval 'sub OS_CODE () {0x;}' unless defined(&OS_CODE);
	if(defined(&__TURBOC__)) {
	    require 'alloc.ph';
	} else {
	    require 'malloc.ph';
	}
    }
    if(defined(&OS2)) {
	eval 'sub OS_CODE () {0x6;}' unless defined(&OS_CODE);
    }
    if(defined(&WIN32)) {
	eval 'sub OS_CODE () {0xb;}' unless defined(&OS_CODE);
    }
    if(defined(&VAXC) || defined(&VMS)) {
	eval 'sub OS_CODE () {0x2;}' unless defined(&OS_CODE);
	eval 'sub FOPEN {
	    my($name, $mode) = @_;
    	    eval q( &fopen(($name), ($mode), \\"mbc=60\\", \\"ctx=stm\\", \\"rfm=fix\\", \\"mrs=512\\"));
	}' unless defined(&FOPEN);
    }
    if(defined(&AMIGA)) {
	eval 'sub OS_CODE () {0x1;}' unless defined(&OS_CODE);
    }
    if(defined(&ATARI) || defined(&atarist)) {
	eval 'sub OS_CODE () {0x5;}' unless defined(&OS_CODE);
    }
    if(defined(&MACOS)) {
	eval 'sub OS_CODE () {0x7;}' unless defined(&OS_CODE);
    }
    if(defined(&__50SERIES)) {
	eval 'sub OS_CODE () {0xf;}' unless defined(&OS_CODE);
    }
    if(defined(&TOPS20)) {
	eval 'sub OS_CODE () {0xa;}' unless defined(&OS_CODE);
    }
    if(defined(&_BEOS_) || defined(&RISCOS)) {
	eval 'sub fdopen {
	    my($fd,$mode) = @_;
    	    eval q( &NULL);
	}' unless defined(&fdopen);
    }
    unless(defined(&OS_CODE)) {
	eval 'sub OS_CODE () {0x3;}' unless defined(&OS_CODE);
    }
    unless(defined(&FOPEN)) {
	eval 'sub FOPEN {
	    my($name, $mode) = @_;
    	    eval q( &fopen(($name), ($mode)));
	}' unless defined(&FOPEN);
    }
    if(defined(&HAVE_STRERROR)) {
	eval 'sub zstrerror {
	    my($errnum) = @_;
    	    eval q( &strerror($errnum));
	}' unless defined(&zstrerror);
    } else {
	eval 'sub zstrerror {
	    my($errnum) = @_;
    	    eval q(\\"\\");
	}' unless defined(&zstrerror);
    }
    if(defined(&pyr)) {
	eval 'sub NO_MEMCPY () {1;}' unless defined(&NO_MEMCPY);
    }
    if((defined(&M_I86SM) || defined(&M_I86MM))  && !defined(&_MSC_VER)) {
	eval 'sub NO_MEMCPY () {1;}' unless defined(&NO_MEMCPY);
    }
    if(defined(&STDC)  && !defined(&HAVE_MEMCPY)  && !defined(&NO_MEMCPY)) {
	eval 'sub HAVE_MEMCPY () {1;}' unless defined(&HAVE_MEMCPY);
    }
    if(defined(&HAVE_MEMCPY)) {
	if(defined(&SMALL_MEDIUM)) {
	    eval 'sub zmemcpy () { &_fmemcpy;}' unless defined(&zmemcpy);
	    eval 'sub zmemcmp () { &_fmemcmp;}' unless defined(&zmemcmp);
	    eval 'sub zmemzero {
	        my($dest, $len) = @_;
    		eval q( &_fmemset($dest, 0, $len));
	    }' unless defined(&zmemzero);
	} else {
	    eval 'sub zmemcpy () { &memcpy;}' unless defined(&zmemcpy);
	    eval 'sub zmemcmp () { &memcmp;}' unless defined(&zmemcmp);
	    eval 'sub zmemzero {
	        my($dest, $len) = @_;
    		eval q( &memset($dest, 0, $len));
	    }' unless defined(&zmemzero);
	}
    } else {
    }
    if(defined(&DEBUG_ZLIB)) {
	require 'stdio.ph';
	unless(defined(&verbose)) {
	    eval 'sub verbose () {0;}' unless defined(&verbose);
	}
	eval 'sub Assert {
	    my($cond,$msg) = @_;
    	    eval q({ &if(!($cond))  &z_error($msg);});
	}' unless defined(&Assert);
	eval 'sub Trace {
	    my($x) = @_;
    	    eval q( &fprintf $x);
	}' unless defined(&Trace);
	eval 'sub Tracev {
	    my($x) = @_;
    	    eval q({ &if ( &verbose)  &fprintf $x ;});
	}' unless defined(&Tracev);
	eval 'sub Tracevv {
	    my($x) = @_;
    	    eval q({ &if ( &verbose>1)  &fprintf $x ;});
	}' unless defined(&Tracevv);
	eval 'sub Tracec {
	    my($c,$x) = @_;
    	    eval q({ &if ( &verbose  && ($c))  &fprintf $x ;});
	}' unless defined(&Tracec);
	eval 'sub Tracecv {
	    my($c,$x) = @_;
    	    eval q({ &if ( &verbose>1 && ($c))  &fprintf $x ;});
	}' unless defined(&Tracecv);
    } else {
	eval 'sub Assert {
	    my($cond,$msg) = @_;
    	    eval q();
	}' unless defined(&Assert);
	eval 'sub Trace {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&Trace);
	eval 'sub Tracev {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&Tracev);
	eval 'sub Tracevv {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&Tracevv);
	eval 'sub Tracec {
	    my($c,$x) = @_;
    	    eval q();
	}' unless defined(&Tracec);
	eval 'sub Tracecv {
	    my($c,$x) = @_;
    	    eval q();
	}' unless defined(&Tracecv);
    }
    eval 'sub ZALLOC {
        my($strm, $items, $size) = @_;
	    eval q((*(($strm)-> &zalloc))(($strm)-> &opaque, ($items), ($size)));
    }' unless defined(&ZALLOC);
    eval 'sub ZFREE {
        my($strm, $addr) = @_;
	    eval q((*(($strm)-> &zfree))(($strm)-> &opaque, ( &voidpf)($addr)));
    }' unless defined(&ZFREE);
    eval 'sub TRY_FREE {
        my($s, $p) = @_;
	    eval q({ &if ($p)  &ZFREE($s, $p);});
    }' unless defined(&TRY_FREE);
}
1;
