/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream;

import com.sun.xml.stream.FileBufferManager;
import com.sun.xml.stream.StreamBufferManager;
import com.sun.xml.stream.xerces.xni.parser.XMLInputSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.CharBuffer;

public abstract class BufferManager {
    protected boolean endOfStream = false;
    static boolean DEBUG = false;

    public abstract void close() throws IOException;

    public boolean endOfStream() {
        return this.endOfStream;
    }

    public abstract boolean getMore() throws IOException;

    public abstract boolean arrangeCapacity(int var1) throws IOException;

    protected Object[] getEncodingName(byte[] byArray, int n) {
        if (n < 2) {
            return new Object[]{"UTF-8", null};
        }
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray[1] & 0xFF;
        if (n2 == 254 && n3 == 255) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (n2 == 255 && n3 == 254) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (n < 3) {
            return new Object[]{"UTF-8", null};
        }
        int n4 = byArray[2] & 0xFF;
        if (n2 == 239 && n3 == 187 && n4 == 191) {
            return new Object[]{"UTF-8", null};
        }
        if (n < 4) {
            return new Object[]{"UTF-8", null};
        }
        int n5 = byArray[3] & 0xFF;
        if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 60) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(true)};
        }
        if (n2 == 60 && n3 == 0 && n4 == 0 && n5 == 0) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(false)};
        }
        if (n2 == 0 && n3 == 0 && n4 == 60 && n5 == 0) {
            return new Object[]{"ISO-10646-UCS-4", null};
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 0) {
            return new Object[]{"ISO-10646-UCS-4", null};
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 63) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (n2 == 60 && n3 == 0 && n4 == 63 && n5 == 0) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (n2 == 76 && n3 == 111 && n4 == 167 && n5 == 148) {
            return new Object[]{"CP037", null};
        }
        return new Object[]{"UTF-8", null};
    }

    public abstract void setEncoding(String var1) throws IOException;

    public static void main(String[] stringArray) {
        try {
            File file = new File(stringArray[0]);
            System.out.println("url parameter = " + file.toURI().toString());
            URL uRL = new URL(file.toURI().toString());
            XMLInputSource xMLInputSource = new XMLInputSource(null, null, null, new FileInputStream(file), "UTF-8");
            BufferManager bufferManager = BufferManager.getBufferManager(xMLInputSource);
            CharBuffer charBuffer = bufferManager.getCharBuffer();
            int n = 0;
            while (bufferManager.getMore()) {
                System.out.println("Loop " + n++ + " = " + bufferManager.getCharBuffer());
            }
            System.out.println("End of stream reached = " + bufferManager.endOfStream());
            System.out.println("Total no. of loops required = " + n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public abstract CharBuffer getCharBuffer();

    public static BufferManager getBufferManager(XMLInputSource xMLInputSource) throws IOException {
        InputStream inputStream = xMLInputSource.getByteStream();
        if (inputStream instanceof FileInputStream) {
            if (DEBUG) {
                System.out.println("Using FileBufferManager");
            }
            return new FileBufferManager((FileInputStream)inputStream, xMLInputSource.getEncoding());
        }
        if (DEBUG) {
            System.out.println("Using StreamBufferManager");
        }
        return new StreamBufferManager(inputStream, xMLInputSource.getEncoding());
    }
}

