/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDIImageDescriptor;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.LibraryContentProvider;
import org.eclipse.jdt.internal.debug.ui.jres.LibraryStandin;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class LibraryLabelProvider
extends LabelProvider {
    private ImageDescriptorRegistry fRegistry = JavaPlugin.getImageDescriptorRegistry();

    public Image getImage(Object element) {
        if (element instanceof LibraryStandin) {
            LibraryStandin library = (LibraryStandin)element;
            IPath sourcePath = library.getSystemLibrarySourcePath();
            String key = null;
            key = sourcePath != null && !Path.EMPTY.equals((Object)sourcePath) ? "org.eclipse.jdt.ui.jar_lsrc_obj.gif" : "org.eclipse.jdt.ui.jar_l_obj.gif";
            IStatus status = library.validate();
            if (!status.isOK()) {
                ImageDescriptor base = JavaUI.getSharedImages().getImageDescriptor(key);
                JDIImageDescriptor descriptor = new JDIImageDescriptor(base, 1);
                return JDIDebugUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)descriptor);
            }
            return JavaUI.getSharedImages().getImage(key);
        }
        if (element instanceof LibraryContentProvider.SubElement) {
            if (((LibraryContentProvider.SubElement)element).getType() == 2) {
                return this.fRegistry.get(JavaPluginImages.DESC_OBJS_SOURCE_ATTACH_ATTRIB);
            }
            return this.fRegistry.get(JavaPluginImages.DESC_OBJS_JAVADOC_LOCATION_ATTRIB);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof LibraryStandin) {
            return ((LibraryStandin)element).getSystemLibraryPath().toOSString();
        }
        if (element instanceof LibraryContentProvider.SubElement) {
            LibraryContentProvider.SubElement subElement = (LibraryContentProvider.SubElement)element;
            StringBuffer text = new StringBuffer();
            if (subElement.getType() == 2) {
                text.append(JREMessages.VMLibraryBlock_0);
                IPath systemLibrarySourcePath = subElement.getParent().getSystemLibrarySourcePath();
                if (systemLibrarySourcePath != null && !Path.EMPTY.equals((Object)systemLibrarySourcePath)) {
                    text.append(systemLibrarySourcePath.toOSString());
                } else {
                    text.append(JREMessages.VMLibraryBlock_1);
                }
            } else {
                text.append(JREMessages.VMLibraryBlock_2);
                URL javadocLocation = subElement.getParent().getJavadocLocation();
                if (javadocLocation != null) {
                    text.append(javadocLocation.toExternalForm());
                } else {
                    text.append(JREMessages.VMLibraryBlock_1);
                }
            }
            return text.toString();
        }
        return null;
    }
}

