"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTarget = exports.getTrustedRoot = void 0;
/*
Copyright 2023 The Sigstore Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const tuf_js_1 = require("tuf-js");
const sigstore = __importStar(require("../types/sigstore"));
const util_1 = require("../util");
const target_1 = require("./target");
const TRUSTED_ROOT_TARGET = 'trusted_root.json';
const DEFAULT_CACHE_DIR = util_1.appdata.appDataPath('sigstore-js');
const DEFAULT_MIRROR_URL = 'https://tuf-repo-cdn.sigstore.dev';
const DEFAULT_TUF_ROOT_PATH = '../../store/public-good-instance-root.json';
async function getTrustedRoot(options = {}) {
    const trustedRoot = await getTarget(TRUSTED_ROOT_TARGET, options);
    return sigstore.TrustedRoot.fromJSON(JSON.parse(trustedRoot));
}
exports.getTrustedRoot = getTrustedRoot;
async function getTarget(targetName, options = {}) {
    const cachePath = options.cachePath || DEFAULT_CACHE_DIR;
    const tufRootPath = options.rootPath || require.resolve(DEFAULT_TUF_ROOT_PATH);
    const mirrorURL = options.mirrorURL || DEFAULT_MIRROR_URL;
    initTufCache(cachePath, tufRootPath);
    const remote = initRemoteConfig(cachePath, mirrorURL);
    const repoClient = initClient(cachePath, remote);
    return (0, target_1.readTarget)(repoClient, targetName);
}
exports.getTarget = getTarget;
// Initializes the TUF cache directory structure including the initial
// root.json file. If the cache directory does not exist, it will be
// created. If the targets directory does not exist, it will be created.
// If the root.json file does not exist, it will be copied from the
// rootPath argument.
function initTufCache(cachePath, tufRootPath) {
    const targetsPath = path_1.default.join(cachePath, 'targets');
    const cachedRootPath = path_1.default.join(cachePath, 'root.json');
    if (!fs_1.default.existsSync(cachePath)) {
        fs_1.default.mkdirSync(cachePath, { recursive: true });
    }
    if (!fs_1.default.existsSync(targetsPath)) {
        fs_1.default.mkdirSync(targetsPath);
    }
    if (!fs_1.default.existsSync(cachedRootPath)) {
        fs_1.default.copyFileSync(tufRootPath, cachedRootPath);
    }
    return cachePath;
}
// Initializes the remote.json file, which contains the URL of the TUF
// repository. If the file does not exist, it will be created. If the file
// exists, it will be parsed and returned.
function initRemoteConfig(rootDir, mirrorURL) {
    let remoteConfig;
    const remoteConfigPath = path_1.default.join(rootDir, 'remote.json');
    if (fs_1.default.existsSync(remoteConfigPath)) {
        const data = fs_1.default.readFileSync(remoteConfigPath, 'utf-8');
        remoteConfig = JSON.parse(data);
    }
    if (!remoteConfig) {
        remoteConfig = { mirror: mirrorURL };
        fs_1.default.writeFileSync(remoteConfigPath, JSON.stringify(remoteConfig));
    }
    return remoteConfig;
}
function initClient(cachePath, remote) {
    const baseURL = remote.mirror;
    return new tuf_js_1.Updater({
        metadataBaseUrl: baseURL,
        targetBaseUrl: `${baseURL}/targets`,
        metadataDir: cachePath,
        targetDir: path_1.default.join(cachePath, 'targets'),
    });
}
