/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.JvmTestSuitePlugin;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.internal.JavaPluginHelper;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.internal.JvmFeatureInternal;
import org.gradle.api.plugins.scala.ScalaBasePlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.idea.GenerateIdeaModule;
import org.gradle.plugins.ide.idea.GenerateIdeaProject;
import org.gradle.plugins.ide.idea.GenerateIdeaWorkspace;
import org.gradle.plugins.ide.idea.internal.IdeaModuleInternal;
import org.gradle.plugins.ide.idea.internal.IdeaModuleMetadata;
import org.gradle.plugins.ide.idea.internal.IdeaModuleSupport;
import org.gradle.plugins.ide.idea.internal.IdeaProjectInternal;
import org.gradle.plugins.ide.idea.internal.IdeaScalaConfigurer;
import org.gradle.plugins.ide.idea.model.IdeaLanguageLevel;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.IdeaModuleIml;
import org.gradle.plugins.ide.idea.model.IdeaProject;
import org.gradle.plugins.ide.idea.model.IdeaWorkspace;
import org.gradle.plugins.ide.idea.model.PathFactory;
import org.gradle.plugins.ide.idea.model.internal.GeneratedIdeaScope;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.IdePlugin;
import org.gradle.plugins.ide.internal.IdeProjectMetadata;
import org.gradle.plugins.ide.internal.configurer.UniqueProjectNameProvider;
import org.gradle.testing.base.TestingExtension;

public abstract class IdeaPlugin
extends IdePlugin {
    private static final Predicate<Project> HAS_IDEA_AND_JAVA_PLUGINS = new Predicate<Project>(){

        public boolean apply(Project project) {
            return project.getPlugins().hasPlugin(IdeaPlugin.class) && project.getPlugins().hasPlugin(JavaBasePlugin.class);
        }
    };
    public static final Function<Project, JavaVersion> SOURCE_COMPATIBILITY = new Function<Project, JavaVersion>(){

        public JavaVersion apply(Project p) {
            return ((JavaPluginExtension)p.getExtensions().getByType(JavaPluginExtension.class)).getSourceCompatibility();
        }
    };
    public static final Function<Project, JavaVersion> TARGET_COMPATIBILITY = new Function<Project, JavaVersion>(){

        public JavaVersion apply(Project p) {
            return ((JavaPluginExtension)p.getExtensions().getByType(JavaPluginExtension.class)).getTargetCompatibility();
        }
    };
    private static final String IDEA_MODULE_TASK_NAME = "ideaModule";
    private static final String IDEA_PROJECT_TASK_NAME = "ideaProject";
    private static final String IDEA_WORKSPACE_TASK_NAME = "ideaWorkspace";
    private final Instantiator instantiator;
    private IdeaModel ideaModel;
    private List<Project> allJavaProjects;
    private final UniqueProjectNameProvider uniqueProjectNameProvider;
    private final IdeArtifactRegistry artifactRegistry;
    private final ProjectStateRegistry projectPathRegistry;

    @Inject
    public IdeaPlugin(Instantiator instantiator, UniqueProjectNameProvider uniqueProjectNameProvider, IdeArtifactRegistry artifactRegistry, ProjectStateRegistry projectPathRegistry) {
        this.instantiator = instantiator;
        this.uniqueProjectNameProvider = uniqueProjectNameProvider;
        this.artifactRegistry = artifactRegistry;
        this.projectPathRegistry = projectPathRegistry;
    }

    public IdeaModel getModel() {
        return this.ideaModel;
    }

    protected String getLifecycleTaskName() {
        return "idea";
    }

    protected void onApply(Project project) {
        this.getLifecycleTask().configure(IdeaPlugin.withDescription((String)"Generates IDEA project files (IML, IPR, IWS)"));
        this.getCleanTask().configure(IdeaPlugin.withDescription((String)"Cleans IDEA project files (IML, IPR)"));
        this.ideaModel = (IdeaModel)project.getExtensions().create("idea", IdeaModel.class, new Object[0]);
        this.configureIdeaWorkspace(project);
        this.configureIdeaProject(project);
        this.configureIdeaModule((ProjectInternal)project);
        this.configureForJavaPlugin(project);
        this.configureForWarPlugin(project);
        this.configureForScalaPlugin();
        this.configureForTestSuitesPlugin(project);
        this.linkCompositeBuildDependencies((ProjectInternal)project);
    }

    private void configureIdeaWorkspace(final Project project) {
        IdeaWorkspace workspace = (IdeaWorkspace)project.getObjects().newInstance(IdeaWorkspace.class, new Object[0]);
        this.ideaModel.setWorkspace(workspace);
        if (this.isRoot()) {
            workspace.setIws(new XmlFileContentMerger(new XmlTransformer()));
            TaskProvider task = project.getTasks().register(IDEA_WORKSPACE_TASK_NAME, GenerateIdeaWorkspace.class, new Object[]{workspace});
            task.configure((Action)new Action<GenerateIdeaWorkspace>(){

                public void execute(GenerateIdeaWorkspace task) {
                    task.setDescription("Generates an IDEA workspace file (IWS)");
                    task.setOutputFile(new File(project.getProjectDir(), project.getName() + ".iws"));
                }
            });
            this.addWorker(task, IDEA_WORKSPACE_TASK_NAME, false);
        }
    }

    private void configureIdeaProject(final Project project) {
        if (this.isRoot()) {
            XmlFileContentMerger ipr = new XmlFileContentMerger(new XmlTransformer());
            IdeaProject ideaProject = (IdeaProject)this.instantiator.newInstance(IdeaProjectInternal.class, new Object[]{project, ipr});
            final TaskProvider projectTask = project.getTasks().register(IDEA_PROJECT_TASK_NAME, GenerateIdeaProject.class, new Object[]{ideaProject});
            projectTask.configure((Action)new Action<GenerateIdeaProject>(){

                public void execute(GenerateIdeaProject projectTask) {
                    projectTask.setDescription("Generates IDEA project file (IPR)");
                }
            });
            this.ideaModel.setProject(ideaProject);
            ideaProject.setOutputFile(new File(project.getProjectDir(), project.getName() + ".ipr"));
            ConventionMapping conventionMapping = ((IConventionAware)ideaProject).getConventionMapping();
            conventionMapping.map("jdkName", (Callable)new Callable<String>(){

                @Override
                public String call() {
                    return JavaVersion.current().toString();
                }
            });
            conventionMapping.map("languageLevel", (Callable)new Callable<IdeaLanguageLevel>(){

                @Override
                public IdeaLanguageLevel call() {
                    JavaVersion maxSourceCompatibility = IdeaPlugin.this.getMaxJavaModuleCompatibilityVersionFor((Function<Project, JavaVersion>)SOURCE_COMPATIBILITY);
                    return new IdeaLanguageLevel((Object)maxSourceCompatibility);
                }
            });
            conventionMapping.map("targetBytecodeVersion", (Callable)new Callable<JavaVersion>(){

                @Override
                public JavaVersion call() {
                    return IdeaPlugin.this.getMaxJavaModuleCompatibilityVersionFor((Function<Project, JavaVersion>)TARGET_COMPATIBILITY);
                }
            });
            ideaProject.getWildcards().addAll(Arrays.asList("!?*.class", "!?*.scala", "!?*.groovy", "!?*.java"));
            conventionMapping.map("modules", (Callable)new Callable<List<IdeaModule>>(){

                @Override
                public List<IdeaModule> call() {
                    return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Sets.filter((Set)project.getRootProject().getAllprojects(), (Predicate)new Predicate<Project>(){

                        public boolean apply(Project p) {
                            return p.getPlugins().hasPlugin(IdeaPlugin.class);
                        }
                    }), (Function)new Function<Project, IdeaModule>(){

                        public IdeaModule apply(Project p) {
                            return IdeaPlugin.ideaModelFor(p).getModule();
                        }
                    }));
                }
            });
            conventionMapping.map("pathFactory", (Callable)new Callable<PathFactory>(){

                @Override
                public PathFactory call() {
                    return new PathFactory().addPathVariable("PROJECT_DIR", ((GenerateIdeaProject)((Object)projectTask.get())).getOutputFile().getParentFile());
                }
            });
            this.addWorker(projectTask, IDEA_PROJECT_TASK_NAME);
            this.addWorkspace(ideaProject);
        }
    }

    private static IdeaModel ideaModelFor(Project project) {
        return (IdeaModel)project.getExtensions().getByType(IdeaModel.class);
    }

    private JavaVersion getMaxJavaModuleCompatibilityVersionFor(Function<Project, JavaVersion> toJavaVersion) {
        List<Project> allJavaProjects = this.getAllJavaProjects();
        if (allJavaProjects.isEmpty()) {
            return IdeaModuleSupport.FALLBACK_MODULE_JAVA_COMPATIBILITY_VERSION;
        }
        return (JavaVersion)Collections.max(Lists.transform(allJavaProjects, toJavaVersion));
    }

    private List<Project> getAllJavaProjects() {
        if (this.allJavaProjects != null) {
            return this.allJavaProjects;
        }
        this.allJavaProjects = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.project.getRootProject().getAllprojects(), HAS_IDEA_AND_JAVA_PLUGINS));
        return this.allJavaProjects;
    }

    private void configureIdeaModule(final ProjectInternal project) {
        IdeaModuleIml iml = new IdeaModuleIml(new XmlTransformer(), project.getProjectDir());
        final IdeaModule module = (IdeaModule)this.instantiator.newInstance(IdeaModuleInternal.class, new Object[]{project, iml});
        final TaskProvider task = project.getTasks().register(IDEA_MODULE_TASK_NAME, GenerateIdeaModule.class, new Object[]{module});
        task.configure((Action)new Action<GenerateIdeaModule>(){

            public void execute(GenerateIdeaModule task) {
                task.setDescription("Generates IDEA module files (IML)");
            }
        });
        this.ideaModel.setModule(module);
        String defaultModuleName = this.uniqueProjectNameProvider.getUniqueName((Project)project);
        module.setName(defaultModuleName);
        ConventionMapping conventionMapping = ((IConventionAware)module).getConventionMapping();
        final LinkedHashSet sourceDirs = new LinkedHashSet();
        conventionMapping.map("sourceDirs", (Callable)new Callable<Set<File>>(){

            @Override
            public Set<File> call() {
                return sourceDirs;
            }
        });
        conventionMapping.map("contentRoot", (Callable)new Callable<File>(){

            @Override
            public File call() {
                return project.getProjectDir();
            }
        });
        final LinkedHashSet testSourceDirs = new LinkedHashSet();
        conventionMapping.map("testSourceDirs", (Callable)new Callable<Set<File>>(){

            @Override
            public Set<File> call() {
                return testSourceDirs;
            }
        });
        final LinkedHashSet resourceDirs = new LinkedHashSet();
        conventionMapping.map("resourceDirs", (Callable)new Callable<Set<File>>(){

            @Override
            public Set<File> call() throws Exception {
                return resourceDirs;
            }
        });
        final LinkedHashSet testResourceDirs = new LinkedHashSet();
        conventionMapping.map("testResourceDirs", (Callable)new Callable<Set<File>>(){

            @Override
            public Set<File> call() throws Exception {
                return testResourceDirs;
            }
        });
        final LinkedHashSet excludeDirs = new LinkedHashSet();
        conventionMapping.map("excludeDirs", (Callable)new Callable<Set<File>>(){

            @Override
            public Set<File> call() {
                excludeDirs.add(project.file((Object)".gradle"));
                excludeDirs.add((File)project.getLayout().getBuildDirectory().getAsFile().get());
                return excludeDirs;
            }
        });
        conventionMapping.map("pathFactory", (Callable)new Callable<PathFactory>(){

            @Override
            public PathFactory call() {
                PathFactory factory = new PathFactory();
                factory.addPathVariable("MODULE_DIR", ((GenerateIdeaModule)((Object)task.get())).getOutputFile().getParentFile());
                for (Map.Entry<String, File> entry : module.getPathVariables().entrySet()) {
                    factory.addPathVariable(entry.getKey(), entry.getValue());
                }
                return factory;
            }
        });
        this.artifactRegistry.registerIdeProject((IdeProjectMetadata)new IdeaModuleMetadata(module, (TaskProvider<? extends Task>)task));
        this.addWorker(task, IDEA_MODULE_TASK_NAME);
    }

    private void configureForJavaPlugin(final Project project) {
        project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                IdeaPlugin.this.configureIdeaModuleForJava(project);
            }
        });
    }

    private void configureForWarPlugin(final Project project) {
        project.getPlugins().withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                IdeaPlugin.this.configureIdeaModuleForWar(project);
            }
        });
    }

    private void configureForTestSuitesPlugin(final Project project) {
        project.getPlugins().withType(JvmTestSuitePlugin.class, (Action)new Action<JvmTestSuitePlugin>(){

            public void execute(JvmTestSuitePlugin testSuitePlugin) {
                IdeaPlugin.this.configureIdeaModuleForTestSuites(project);
            }
        });
    }

    private void configureIdeaModuleForJava(final Project project) {
        JvmFeatureInternal mainFeature = JavaPluginHelper.getJavaComponent((Project)project).getMainFeature();
        JvmTestSuite defaultTestSuite = JavaPluginHelper.getDefaultTestSuite((Project)project);
        project.getTasks().withType(GenerateIdeaModule.class).configureEach(ideaModule -> ideaModule.dependsOn(new Object[]{() -> mainFeature.getSourceSet().getOutput().getDirs().plus(defaultTestSuite.getSources().getOutput().getDirs())}));
        this.setupScopes(mainFeature, defaultTestSuite);
        ConventionMapping convention = ((IConventionAware)this.ideaModel.getModule()).getConventionMapping();
        final LinkedHashSet sourceDirs = new LinkedHashSet();
        convention.map("sourceDirs", (Callable)new Callable<Set<File>>(){

            @Override
            public Set<File> call() {
                SourceSetContainer sourceSets = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets();
                sourceDirs.addAll(((SourceSet)sourceSets.getByName("main")).getAllJava().getSrcDirs());
                return sourceDirs;
            }
        });
        final LinkedHashSet resourceDirs = new LinkedHashSet();
        convention.map("resourceDirs", (Callable)new Callable<Set<File>>(){

            @Override
            public Set<File> call() {
                SourceSetContainer sourceSets = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets();
                resourceDirs.addAll(((SourceSet)sourceSets.getByName("main")).getResources().getSrcDirs());
                return resourceDirs;
            }
        });
        final LinkedHashMap singleEntryLibraries = new LinkedHashMap(2);
        convention.map("singleEntryLibraries", (Callable)new Callable<Map<String, FileCollection>>(){

            @Override
            public Map<String, FileCollection> call() {
                SourceSetContainer sourceSets = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets();
                singleEntryLibraries.putIfAbsent("RUNTIME", ((SourceSet)sourceSets.getByName("main")).getOutput().getDirs());
                singleEntryLibraries.putIfAbsent("TEST", ((SourceSet)sourceSets.getByName("test")).getOutput().getDirs());
                return singleEntryLibraries;
            }
        });
        convention.map("targetBytecodeVersion", (Callable)new Callable<JavaVersion>(){

            @Override
            public JavaVersion call() {
                JavaVersion moduleTargetBytecodeLevel = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getTargetCompatibility();
                return IdeaPlugin.includeModuleBytecodeLevelOverride(project.getRootProject(), moduleTargetBytecodeLevel) ? moduleTargetBytecodeLevel : null;
            }
        });
        convention.map("languageLevel", (Callable)new Callable<IdeaLanguageLevel>(){

            @Override
            public IdeaLanguageLevel call() {
                IdeaLanguageLevel moduleLanguageLevel = new IdeaLanguageLevel((Object)((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceCompatibility());
                return IdeaPlugin.includeModuleLanguageLevelOverride(project.getRootProject(), moduleLanguageLevel) ? moduleLanguageLevel : null;
            }
        });
    }

    private void setupScopes(JvmFeatureInternal mainFeature, JvmTestSuite defaultTestSuite) {
        LinkedHashMap<String, Map<String, Collection<Configuration>>> scopes = new LinkedHashMap<String, Map<String, Collection<Configuration>>>();
        for (GeneratedIdeaScope scope : GeneratedIdeaScope.values()) {
            LinkedHashMap plusMinus = new LinkedHashMap();
            plusMinus.put("plus", new ArrayList());
            plusMinus.put("minus", new ArrayList());
            scopes.put(scope.name(), plusMinus);
        }
        Collection provided = (Collection)((Map)scopes.get(GeneratedIdeaScope.PROVIDED.name())).get("plus");
        provided.add(mainFeature.getCompileClasspathConfiguration());
        Collection runtime = (Collection)((Map)scopes.get(GeneratedIdeaScope.RUNTIME.name())).get("plus");
        runtime.add(mainFeature.getRuntimeClasspathConfiguration());
        ConfigurationContainer configurations = this.project.getConfigurations();
        Collection test = (Collection)((Map)scopes.get(GeneratedIdeaScope.TEST.name())).get("plus");
        test.add(configurations.getByName(defaultTestSuite.getSources().getCompileClasspathConfigurationName()));
        test.add(configurations.getByName(defaultTestSuite.getSources().getRuntimeClasspathConfigurationName()));
        this.ideaModel.getModule().setScopes(scopes);
    }

    private void configureIdeaModuleForTestSuites(Project project) {
        TestingExtension testing = (TestingExtension)project.getExtensions().getByType(TestingExtension.class);
        IdeaModule ideaModule = IdeaPlugin.ideaModelFor(project).getModule();
        testing.getSuites().withType(JvmTestSuite.class).configureEach(suite -> {
            ideaModule.getTestSources().from(new Object[]{suite.getSources().getAllJava().getSourceDirectories()});
            ideaModule.getTestResources().from(new Object[]{suite.getSources().getResources().getSourceDirectories()});
        });
    }

    private void configureIdeaModuleForWar(final Project project) {
        project.getTasks().withType(GenerateIdeaModule.class).configureEach((Action)new Action<GenerateIdeaModule>(){

            public void execute(GenerateIdeaModule ideaModule) {
                ConfigurationContainer configurations = project.getConfigurations();
                Configuration providedRuntime = configurations.getByName("providedRuntime");
                Collection<Configuration> providedPlus = ideaModule.getModule().getScopes().get(GeneratedIdeaScope.PROVIDED.name()).get("plus");
                providedPlus.add(providedRuntime);
                Collection<Configuration> runtimeMinus = ideaModule.getModule().getScopes().get(GeneratedIdeaScope.RUNTIME.name()).get("minus");
                runtimeMinus.add(providedRuntime);
                Collection<Configuration> testMinus = ideaModule.getModule().getScopes().get(GeneratedIdeaScope.TEST.name()).get("minus");
                testMinus.add(providedRuntime);
            }
        });
    }

    private static boolean includeModuleBytecodeLevelOverride(Project rootProject, JavaVersion moduleTargetBytecodeLevel) {
        if (!rootProject.getPlugins().hasPlugin(IdeaPlugin.class)) {
            return true;
        }
        IdeaProject ideaProject = IdeaPlugin.ideaModelFor(rootProject).getProject();
        return !moduleTargetBytecodeLevel.equals((Object)ideaProject.getTargetBytecodeVersion());
    }

    private static boolean includeModuleLanguageLevelOverride(Project rootProject, IdeaLanguageLevel moduleLanguageLevel) {
        if (!rootProject.getPlugins().hasPlugin(IdeaPlugin.class)) {
            return true;
        }
        IdeaProject ideaProject = IdeaPlugin.ideaModelFor(rootProject).getProject();
        return !moduleLanguageLevel.equals((Object)ideaProject.getLanguageLevel());
    }

    private void configureForScalaPlugin() {
        this.project.getPlugins().withType(ScalaBasePlugin.class, (Action)new Action<ScalaBasePlugin>(){

            public void execute(ScalaBasePlugin scalaBasePlugin) {
                IdeaPlugin.this.ideaModuleDependsOnRoot();
            }
        });
        if (this.isRoot()) {
            new IdeaScalaConfigurer(this.project).configure();
        }
    }

    private void ideaModuleDependsOnRoot() {
        this.project.getTasks().named(IDEA_MODULE_TASK_NAME, IdeaPlugin.dependsOn((TaskProvider)this.project.getRootProject().getTasks().named(IDEA_PROJECT_TASK_NAME)));
    }

    private void linkCompositeBuildDependencies(ProjectInternal project) {
        if (this.isRoot()) {
            this.getLifecycleTask().configure(task -> task.dependsOn(new Object[]{context -> this.visitAllImlArtifactsInComposite(project, this.ideaModel.getProject(), context)}));
        }
    }

    private void visitAllImlArtifactsInComposite(ProjectInternal project, IdeaProject ideaProject, TaskDependencyResolveContext context) {
        ProjectComponentIdentifier thisProjectId = this.projectPathRegistry.stateFor((Project)project).getComponentIdentifier();
        for (IdeArtifactRegistry.Reference reference : this.artifactRegistry.getIdeProjects(IdeaModuleMetadata.class)) {
            BuildIdentifier otherBuildId = reference.getOwningProject().getBuild();
            if (thisProjectId.getBuild().equals(otherBuildId)) {
                boolean found = false;
                for (IdeaModule ideaModule : ideaProject.getModules()) {
                    if (!((IdeaModuleMetadata)reference.get()).getFile().equals(ideaModule.getOutputFile())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            reference.visitDependencies(context);
        }
    }
}

