/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.steps.AfterExecutionResult;
import org.gradle.internal.execution.steps.CachingContext;
import org.gradle.internal.execution.steps.IncrementalChangesContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.UpToDateResult;

public class NeverUpToDateStep<C extends CachingContext>
implements Step<C, UpToDateResult> {
    private static final ImmutableList<String> NO_HISTORY = ImmutableList.of((Object)"No history is available.");
    private final Step<? super IncrementalChangesContext, ? extends AfterExecutionResult> delegate;

    public NeverUpToDateStep(Step<? super IncrementalChangesContext, ? extends AfterExecutionResult> delegate) {
        this.delegate = delegate;
    }

    @Override
    public UpToDateResult execute(UnitOfWork work, C context) {
        AfterExecutionResult result = this.delegate.execute(work, new IncrementalChangesContext((CachingContext)context, NO_HISTORY, null));
        return new UpToDateResult(result, NO_HISTORY);
    }
}

