/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.service;

import java.io.IOException;
import java.io.InputStream;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.internal.controller.operations.LoadOperationDetails;
import org.gradle.caching.internal.controller.operations.LoadOperationHitResult;
import org.gradle.caching.internal.controller.operations.LoadOperationMissResult;
import org.gradle.caching.internal.controller.operations.StoreOperationDetails;
import org.gradle.caching.internal.controller.operations.StoreOperationResult;
import org.gradle.caching.internal.controller.service.BaseRemoteBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.BuildCacheServiceRole;
import org.gradle.caching.internal.controller.service.LoadTarget;
import org.gradle.caching.internal.controller.service.StoreTarget;
import org.gradle.caching.internal.operations.BuildCacheRemoteDisabledDueToFailureProgressDetails;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.RunnableBuildOperation;

public class OpFiringRemoteBuildCacheServiceHandle
extends BaseRemoteBuildCacheServiceHandle {
    private final String buildPath;
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildOperationProgressEventEmitter buildOperationProgressEventEmitter;

    public OpFiringRemoteBuildCacheServiceHandle(String buildPath, BuildCacheService service, boolean push, BuildCacheServiceRole role, BuildOperationExecutor buildOperationExecutor, BuildOperationProgressEventEmitter buildOperationProgressEventEmitter, boolean logStackTraces, boolean disableOnError) {
        super(service, push, role, logStackTraces, disableOnError);
        this.buildPath = buildPath;
        this.buildOperationExecutor = buildOperationExecutor;
        this.buildOperationProgressEventEmitter = buildOperationProgressEventEmitter;
    }

    @Override
    protected void loadInner(final String description, final BuildCacheKey key, final LoadTarget loadTarget) {
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                OpFiringRemoteBuildCacheServiceHandle.this.loadInner(key, new OpFiringEntryReader(loadTarget));
                context.setResult((Object)(loadTarget.isLoaded() ? new LoadOperationHitResult(loadTarget.getLoadedSize()) : LoadOperationMissResult.INSTANCE));
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)description).details((Object)new LoadOperationDetails(key)).progressDisplayName("Requesting from remote build cache");
            }
        });
    }

    @Override
    protected void storeInner(final String description, final BuildCacheKey key, final StoreTarget storeTarget) {
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                OpFiringRemoteBuildCacheServiceHandle.super.storeInner(description, key, storeTarget);
                context.setResult((Object)(storeTarget.isStored() ? StoreOperationResult.STORED : StoreOperationResult.NOT_STORED));
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)description).details((Object)new StoreOperationDetails(key, storeTarget.getSize())).progressDisplayName("Uploading to remote build cache");
            }
        });
    }

    @Override
    protected void onCacheDisabledDueToFailure(BuildCacheKey key, BaseRemoteBuildCacheServiceHandle.Operation operation, Throwable failure) {
        BuildCacheRemoteDisabledDueToFailureProgressDetails.BuildCacheOperationType operationType = OpFiringRemoteBuildCacheServiceHandle.convertToBuildOperationType(operation);
        this.buildOperationProgressEventEmitter.emitNowIfCurrent((Object)new RemoteDisabledDueToFailureProgressDetails(key, failure, operationType));
    }

    private static BuildCacheRemoteDisabledDueToFailureProgressDetails.BuildCacheOperationType convertToBuildOperationType(BaseRemoteBuildCacheServiceHandle.Operation operation) {
        switch (operation) {
            case LOAD: {
                return BuildCacheRemoteDisabledDueToFailureProgressDetails.BuildCacheOperationType.LOAD;
            }
            case STORE: {
                return BuildCacheRemoteDisabledDueToFailureProgressDetails.BuildCacheOperationType.STORE;
            }
        }
        throw new IllegalStateException();
    }

    private class RemoteDisabledDueToFailureProgressDetails
    implements BuildCacheRemoteDisabledDueToFailureProgressDetails {
        private final BuildCacheKey key;
        private final Throwable e;
        private final BuildCacheRemoteDisabledDueToFailureProgressDetails.BuildCacheOperationType operationType;

        public RemoteDisabledDueToFailureProgressDetails(BuildCacheKey key, Throwable e, BuildCacheRemoteDisabledDueToFailureProgressDetails.BuildCacheOperationType operationType) {
            this.key = key;
            this.e = e;
            this.operationType = operationType;
        }

        public String getBuildCacheConfigurationIdentifier() {
            return OpFiringRemoteBuildCacheServiceHandle.this.buildPath;
        }

        public String getCacheKey() {
            return this.key.getDisplayName();
        }

        public Throwable getFailure() {
            return this.e;
        }

        public BuildCacheRemoteDisabledDueToFailureProgressDetails.BuildCacheOperationType getOperationType() {
            return this.operationType;
        }
    }

    private static class UncheckedWrapper
    extends RuntimeException {
        UncheckedWrapper(IOException cause) {
            super(cause);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        IOException getIOException() {
            return (IOException)this.getCause();
        }
    }

    private class OpFiringEntryReader
    implements BuildCacheEntryReader {
        private final BuildCacheEntryReader delegate;

        OpFiringEntryReader(BuildCacheEntryReader delegate) {
            this.delegate = delegate;
        }

        public void readFrom(final InputStream input) throws IOException {
            try {
                OpFiringRemoteBuildCacheServiceHandle.this.buildOperationExecutor.run(new RunnableBuildOperation(){

                    public void run(BuildOperationContext context) {
                        try {
                            OpFiringEntryReader.this.delegate.readFrom(input);
                        }
                        catch (IOException e) {
                            throw new UncheckedWrapper(e);
                        }
                    }

                    public BuildOperationDescriptor.Builder description() {
                        return BuildOperationDescriptor.displayName((String)"Download from remote build cache").progressDisplayName("Downloading");
                    }
                });
            }
            catch (UncheckedWrapper uncheckedWrapper) {
                throw uncheckedWrapper.getIOException();
            }
        }
    }
}

