/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.internal.service.AnnotatedServiceLifecycleHandler;
import org.gradle.internal.service.ServiceScopeValidatorWorkarounds;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@NonNullApi
class ServiceScopeValidator
implements AnnotatedServiceLifecycleHandler {
    private static final List<Class<? extends Annotation>> SCOPE_ANNOTATIONS = Collections.singletonList(ServiceScope.class);
    private final Class<? extends Scope> scope;

    public ServiceScopeValidator(Class<? extends Scope> scope) {
        this.scope = scope;
    }

    @Override
    public List<Class<? extends Annotation>> getAnnotations() {
        return SCOPE_ANNOTATIONS;
    }

    @Override
    public void whenRegistered(Class<? extends Annotation> annotation, AnnotatedServiceLifecycleHandler.Registration registration) {
        this.validateScope(registration.getDeclaredType());
    }

    private void validateScope(Class<?> serviceType) {
        Class<? extends Scope> serviceScope = ServiceScopeValidator.scopeOf(serviceType);
        if (serviceScope == null || ServiceScopeValidatorWorkarounds.shouldSuppressValidation(serviceType)) {
            return;
        }
        if (!this.scope.equals(serviceScope)) {
            throw new IllegalArgumentException(this.invalidScopeMessage(serviceType, serviceScope));
        }
    }

    private String invalidScopeMessage(Class<?> serviceType, Class<? extends Scope> actualScope) {
        return String.format("Service '%s' was declared in scope '%s' but registered in scope '%s'", serviceType.getName(), actualScope.getSimpleName(), this.scope.getSimpleName());
    }

    @Nullable
    private static Class<? extends Scope> scopeOf(Class<?> serviceType) {
        ServiceScope scopeAnnotation = serviceType.getAnnotation(ServiceScope.class);
        return scopeAnnotation != null ? scopeAnnotation.value() : null;
    }
}

