/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.Collection;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ComponentMetadataProcessor;
import org.gradle.api.internal.artifacts.ComponentMetadataProcessorFactory;
import org.gradle.api.internal.artifacts.ComponentSelectionRulesInternal;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.MetadataResolutionContext;
import org.gradle.api.internal.artifacts.configurations.dynamicversion.CachePolicy;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.CachingModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ChangingValueDependencyResolutionListener;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ErrorHandlingModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.FilteredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.IvyDynamicResolveModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.LocalModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.NoRepositoriesResolver;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryDisabler;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.StartParameterResolutionOverride;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.UserResolverChain;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.DependencyVerificationOverride;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleRepositoryCacheProvider;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultComponentSelectionRules;
import org.gradle.api.internal.artifacts.repositories.ArtifactResolutionDetails;
import org.gradle.api.internal.artifacts.repositories.ContentFilteringRepository;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.result.DefaultResolvedArtifactResult;
import org.gradle.api.internal.attributes.AttributeSchemaServices;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Actions;
import org.gradle.internal.component.external.model.ModuleComponentGraphResolveState;
import org.gradle.internal.component.external.model.ModuleComponentGraphResolveStateFactory;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.model.CalculatedValueFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.caching.ComponentMetadataSupplierRuleExecutor;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentResolveResult;
import org.gradle.util.internal.BuildCommencedTimeProvider;

public class ExternalModuleComponentResolverFactory {
    private static final Logger LOGGER = Logging.getLogger(ExternalModuleComponentResolverFactory.class);
    private final ModuleRepositoryCacheProvider cacheProvider;
    private final StartParameterResolutionOverride startParameterResolutionOverride;
    private final BuildCommencedTimeProvider timeProvider;
    private final VersionComparator versionComparator;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final RepositoryDisabler repositoryBlacklister;
    private final VersionParser versionParser;
    private final ModuleComponentGraphResolveStateFactory moduleResolveStateFactory;
    private final CalculatedValueFactory calculatedValueFactory;
    private final ImmutableAttributesFactory attributesFactory;
    private final AttributeSchemaServices attributeSchemaServices;
    private final ComponentMetadataSupplierRuleExecutor componentMetadataSupplierRuleExecutor;
    private final DependencyVerificationOverride dependencyVerificationOverride;
    private final ChangingValueDependencyResolutionListener listener;

    @Inject
    public ExternalModuleComponentResolverFactory(ModuleRepositoryCacheProvider cacheProvider, StartParameterResolutionOverride startParameterResolutionOverride, DependencyVerificationOverride dependencyVerificationOverride, BuildCommencedTimeProvider timeProvider, VersionComparator versionComparator, ImmutableModuleIdentifierFactory moduleIdentifierFactory, RepositoryDisabler repositoryBlacklister, VersionParser versionParser, ListenerManager listenerManager, ModuleComponentGraphResolveStateFactory moduleResolveStateFactory, CalculatedValueFactory calculatedValueFactory, ImmutableAttributesFactory attributesFactory, AttributeSchemaServices attributeSchemaServices, ComponentMetadataSupplierRuleExecutor componentMetadataSupplierRuleExecutor) {
        this.cacheProvider = cacheProvider;
        this.startParameterResolutionOverride = startParameterResolutionOverride;
        this.timeProvider = timeProvider;
        this.versionComparator = versionComparator;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.repositoryBlacklister = repositoryBlacklister;
        this.versionParser = versionParser;
        this.dependencyVerificationOverride = dependencyVerificationOverride;
        this.listener = (ChangingValueDependencyResolutionListener)listenerManager.getBroadcaster(ChangingValueDependencyResolutionListener.class);
        this.moduleResolveStateFactory = moduleResolveStateFactory;
        this.calculatedValueFactory = calculatedValueFactory;
        this.attributesFactory = attributesFactory;
        this.attributeSchemaServices = attributeSchemaServices;
        this.componentMetadataSupplierRuleExecutor = componentMetadataSupplierRuleExecutor;
    }

    public ComponentResolvers createResolvers(Collection<? extends ResolutionAwareRepository> repositories, ComponentMetadataProcessorFactory metadataProcessor, ComponentSelectionRulesInternal componentSelectionRules, boolean dependencyVerificationEnabled, CachePolicy cachePolicy, AttributeContainer consumerAttributes, ImmutableAttributesSchema consumerSchema) {
        if (repositories.isEmpty()) {
            return new NoRepositoriesResolver();
        }
        UserResolverChain moduleResolver = new UserResolverChain(this.versionComparator, componentSelectionRules, this.versionParser, consumerAttributes, consumerSchema, this.attributesFactory, this.attributeSchemaServices, metadataProcessor, this.componentMetadataSupplierRuleExecutor, this.calculatedValueFactory, cachePolicy);
        ParentModuleLookupResolver parentModuleResolver = new ParentModuleLookupResolver(this.versionComparator, this.moduleIdentifierFactory, this.versionParser, consumerAttributes, consumerSchema, this.attributesFactory, this.attributeSchemaServices, metadataProcessor, this.componentMetadataSupplierRuleExecutor, this.calculatedValueFactory, cachePolicy);
        for (ResolutionAwareRepository resolutionAwareRepository : repositories) {
            ModuleComponentRepository<ModuleComponentGraphResolveState> moduleComponentRepository;
            ConfiguredModuleComponentRepository baseRepository = resolutionAwareRepository.createResolver();
            baseRepository.setComponentResolvers(parentModuleResolver);
            Instantiator instantiator = baseRepository.getComponentMetadataInstantiator();
            DefaultMetadataResolutionContext metadataResolutionContext = new DefaultMetadataResolutionContext(cachePolicy, instantiator);
            ComponentMetadataProcessor componentMetadataProcessor = metadataProcessor.createComponentMetadataProcessor(metadataResolutionContext);
            if (baseRepository.isLocal()) {
                moduleComponentRepository = new CachingModuleComponentRepository(baseRepository, this.cacheProvider.getInMemoryOnlyCaches(), this.moduleResolveStateFactory, cachePolicy, this.timeProvider, componentMetadataProcessor, ChangingValueDependencyResolutionListener.NO_OP);
                moduleComponentRepository = new LocalModuleComponentRepository<ModuleComponentGraphResolveState>(moduleComponentRepository);
            } else {
                ModuleComponentRepository<ModuleComponentResolveMetadata> overrideRepository = this.startParameterResolutionOverride.overrideModuleVersionRepository(baseRepository);
                moduleComponentRepository = new CachingModuleComponentRepository(overrideRepository, this.cacheProvider.getPersistentCaches(), this.moduleResolveStateFactory, cachePolicy, this.timeProvider, componentMetadataProcessor, this.listener);
            }
            moduleComponentRepository = this.cacheProvider.getResolvedArtifactCaches().provideResolvedArtifactCache(moduleComponentRepository, dependencyVerificationEnabled);
            if (baseRepository.isDynamicResolveMode()) {
                moduleComponentRepository = new IvyDynamicResolveModuleComponentRepository(moduleComponentRepository, this.moduleResolveStateFactory);
            }
            moduleComponentRepository = new ErrorHandlingModuleComponentRepository(moduleComponentRepository, this.repositoryBlacklister);
            moduleComponentRepository = ExternalModuleComponentResolverFactory.filterRepository(resolutionAwareRepository, moduleComponentRepository);
            moduleComponentRepository = this.maybeApplyDependencyVerification(moduleComponentRepository, dependencyVerificationEnabled);
            moduleResolver.add(moduleComponentRepository);
            parentModuleResolver.add(moduleComponentRepository);
        }
        return moduleResolver;
    }

    private static ModuleComponentRepository<ModuleComponentGraphResolveState> filterRepository(ResolutionAwareRepository repository, ModuleComponentRepository<ModuleComponentGraphResolveState> moduleComponentRepository) {
        Action<? super ArtifactResolutionDetails> filter = Actions.doNothing();
        if (repository instanceof ContentFilteringRepository) {
            filter = ((ContentFilteringRepository)((Object)repository)).getContentFilter();
        }
        if (filter == Actions.doNothing()) {
            return moduleComponentRepository;
        }
        return new FilteredModuleComponentRepository(moduleComponentRepository, filter);
    }

    private ModuleComponentRepository<ModuleComponentGraphResolveState> maybeApplyDependencyVerification(ModuleComponentRepository<ModuleComponentGraphResolveState> moduleComponentRepository, boolean dependencyVerificationEnabled) {
        if (!dependencyVerificationEnabled) {
            LOGGER.warn("Dependency verification has been disabled.");
            return moduleComponentRepository;
        }
        return this.dependencyVerificationOverride.overrideDependencyVerification(moduleComponentRepository);
    }

    public ArtifactResult verifiedArtifact(DefaultResolvedArtifactResult defaultResolvedArtifactResult) {
        return this.dependencyVerificationOverride.verifiedArtifact(defaultResolvedArtifactResult);
    }

    private static class DefaultMetadataResolutionContext
    implements MetadataResolutionContext {
        private final CachePolicy cachePolicy;
        private final Instantiator instantiator;

        private DefaultMetadataResolutionContext(CachePolicy cachePolicy, Instantiator instantiator) {
            this.cachePolicy = cachePolicy;
            this.instantiator = instantiator;
        }

        @Override
        public CachePolicy getCachePolicy() {
            return this.cachePolicy;
        }

        @Override
        public Instantiator getInjectingInstantiator() {
            return this.instantiator;
        }
    }

    private static class ParentModuleLookupResolver
    implements ComponentResolvers,
    DependencyToComponentIdResolver,
    ComponentMetaDataResolver,
    ArtifactResolver {
        private final UserResolverChain delegate;

        public ParentModuleLookupResolver(VersionComparator versionComparator, ImmutableModuleIdentifierFactory moduleIdentifierFactory, VersionParser versionParser, AttributeContainer consumerAttributes, ImmutableAttributesSchema attributesSchema, ImmutableAttributesFactory attributesFactory, AttributeSchemaServices attributeSchemaServices, ComponentMetadataProcessorFactory componentMetadataProcessorFactory, ComponentMetadataSupplierRuleExecutor componentMetadataSupplierRuleExecutor, CalculatedValueFactory calculatedValueFactory, CachePolicy cachePolicy) {
            this.delegate = new UserResolverChain(versionComparator, new DefaultComponentSelectionRules(moduleIdentifierFactory), versionParser, consumerAttributes, attributesSchema, attributesFactory, attributeSchemaServices, componentMetadataProcessorFactory, componentMetadataSupplierRuleExecutor, calculatedValueFactory, cachePolicy);
        }

        public void add(ModuleComponentRepository<ModuleComponentGraphResolveState> moduleComponentRepository) {
            this.delegate.add(moduleComponentRepository);
        }

        @Override
        public DependencyToComponentIdResolver getComponentIdResolver() {
            return this;
        }

        @Override
        public ComponentMetaDataResolver getComponentResolver() {
            return this;
        }

        @Override
        public ArtifactResolver getArtifactResolver() {
            return this;
        }

        @Override
        public void resolve(DependencyMetadata dependency, VersionSelector acceptor, @Nullable VersionSelector rejector, BuildableComponentIdResolveResult result) {
            this.delegate.getComponentIdResolver().resolve(dependency, acceptor, rejector, result);
        }

        @Override
        public void resolve(ComponentIdentifier identifier, ComponentOverrideMetadata componentOverrideMetadata, BuildableComponentResolveResult result) {
            this.delegate.getComponentResolver().resolve(identifier, componentOverrideMetadata, result);
        }

        @Override
        public boolean isFetchingMetadataCheap(ComponentIdentifier identifier) {
            return this.delegate.getComponentResolver().isFetchingMetadataCheap(identifier);
        }

        @Override
        public void resolveArtifactsWithType(ComponentArtifactResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            this.delegate.getArtifactResolver().resolveArtifactsWithType(component, artifactType, result);
        }

        @Override
        public void resolveArtifact(ComponentArtifactResolveMetadata component, ComponentArtifactMetadata artifact, BuildableArtifactResolveResult result) {
            this.delegate.getArtifactResolver().resolveArtifact(component, artifact, result);
        }
    }
}

