/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import kotlin.collections.ArrayDeque;
import org.gradle.execution.plan.HasFinalizers;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeGroup;
import org.gradle.execution.plan.OrdinalGroup;
import org.gradle.execution.plan.TaskNode;

public class FinalizerGroup
extends HasFinalizers {
    private static final MemberSuccessors DO_NOT_BLOCK = new DoNotBlock();
    private final TaskNode node;
    private final NodeGroup delegate;
    private final Set<Node> members = new LinkedHashSet<Node>();
    @Nullable
    private OrdinalGroup ordinal;
    @Nullable
    private ElementSuccessors successors;
    private boolean finalizedNodeHasStarted;
    private boolean hasBeenScheduled;

    public FinalizerGroup(TaskNode node, NodeGroup delegate) {
        this(node, delegate, delegate.asOrdinal());
    }

    public FinalizerGroup(TaskNode node, NodeGroup delegate, @Nullable OrdinalGroup ordinal) {
        this.node = node;
        this.delegate = delegate;
        this.ordinal = ordinal;
    }

    public String toString() {
        return "finalizer " + this.node + " ordinal: " + this.ordinal + ", delegate: " + this.delegate;
    }

    public TaskNode getNode() {
        return this.node;
    }

    @Override
    public NodeGroup getOrdinalGroup() {
        return this.delegate;
    }

    @Override
    public NodeGroup withOrdinalGroup(OrdinalGroup newOrdinal) {
        this.ordinal = newOrdinal;
        return this;
    }

    @Override
    public NodeGroup reachableFrom(OrdinalGroup newOrdinal) {
        this.ordinal = newOrdinal;
        return this;
    }

    public NodeGroup getDelegate() {
        return this.delegate;
    }

    public Set<Node> getFinalizedNodes() {
        return this.node.getFinalizingSuccessors();
    }

    @Override
    @Nullable
    public OrdinalGroup asOrdinal() {
        return this.ordinal;
    }

    @Override
    public boolean isReachableFromEntryPoint() {
        return this.delegate.isReachableFromEntryPoint();
    }

    @Override
    @Nullable
    public FinalizerGroup asFinalizer() {
        return this;
    }

    private static boolean memberCanStartAtAnyTime(Node node) {
        return node.getGroup().isReachableFromEntryPoint();
    }

    @Override
    public Set<FinalizerGroup> getFinalizerGroups() {
        return ImmutableSet.of((Object)this);
    }

    @Override
    public void addMember(Node node) {
        assert (this.successors == null);
        this.members.add(node);
        this.delegate.addMember(node);
    }

    @Override
    public void removeMember(Node node) {
        assert (this.successors == null);
        this.members.remove(node);
        this.delegate.removeMember(node);
    }

    public void visitAllMembers(Consumer<Node> visitor) {
        for (Node member : this.members) {
            visitor.accept(member);
        }
    }

    @Override
    public boolean isCanCancel() {
        if (!this.isCanCancel(Collections.singletonList(this))) {
            return false;
        }
        return this.delegate.isCanCancel();
    }

    public boolean isCanCancelSelf() {
        if (this.node.allDependenciesComplete() && !this.node.allDependenciesSuccessful()) {
            return true;
        }
        return !this.finalizedNodeHasStarted;
    }

    @Override
    public void onNodeStart(Node finalizer, Node node) {
        if (this.isFinalizerNode(finalizer) && !this.finalizedNodeHasStarted && this.getFinalizedNodes().contains(node)) {
            this.finalizedNodeHasStarted = true;
        }
    }

    public void scheduleMembers(SetMultimap<FinalizerGroup, FinalizerGroup> reachableGroups) {
        if (this.hasBeenScheduled) {
            return;
        }
        this.hasBeenScheduled = true;
        Set<Node> finalizedNodesToBlockOn = this.findFinalizedNodesThatDoNotIntroduceACycle(reachableGroups);
        WaitForNodesToComplete waitForFinalizers = new WaitForNodesToComplete(finalizedNodesToBlockOn);
        HashSet<Node> blockedFinalizedMembers = new HashSet<Node>(this.getFinalizedNodes());
        blockedFinalizedMembers.removeAll(finalizedNodesToBlockOn);
        blockedFinalizedMembers.retainAll(this.members);
        if (blockedFinalizedMembers.isEmpty()) {
            this.successors = node -> waitForFinalizers;
            return;
        }
        ImmutableMap.Builder blockingNodesBuilder = ImmutableMap.builder();
        Set<Node> dependenciesThatAreMembers = this.getDependenciesThatAreMembers(blockedFinalizedMembers);
        for (Node member : this.members) {
            if (this.isFinalizerNode(member) || FinalizerGroup.memberCanStartAtAnyTime(member)) continue;
            if (blockedFinalizedMembers.contains(member)) {
                if (!finalizedNodesToBlockOn.isEmpty()) {
                    blockingNodesBuilder.put((Object)member, (Object)waitForFinalizers);
                    continue;
                }
                blockingNodesBuilder.put((Object)member, (Object)new WaitForFinalizedNodesToBecomeActive(Collections.singleton(member)));
                continue;
            }
            if (dependenciesThatAreMembers.contains(member)) {
                blockingNodesBuilder.put((Object)member, (Object)waitForFinalizers);
                continue;
            }
            LinkedHashSet<Node> blockOn = new LinkedHashSet<Node>(finalizedNodesToBlockOn);
            blockOn.addAll(blockedFinalizedMembers);
            blockingNodesBuilder.put((Object)member, (Object)new WaitForNodesToComplete(blockOn));
        }
        ImmutableMap blockingNodes = blockingNodesBuilder.build();
        this.successors = arg_0 -> ((ImmutableMap)blockingNodes).get(arg_0);
    }

    private Set<Node> findFinalizedNodesThatDoNotIntroduceACycle(SetMultimap<FinalizerGroup, FinalizerGroup> reachableGroups) {
        HashSet<Node> nodesWithNoCycle = new HashSet<Node>(this.getFinalizedNodes().size());
        for (Node finalizedNode : this.getFinalizedNodes()) {
            if (this.hasACycle(finalizedNode, reachableGroups)) continue;
            nodesWithNoCycle.add(finalizedNode);
        }
        return nodesWithNoCycle;
    }

    @Override
    public Node.DependenciesState checkSuccessorsCompleteFor(Node node) {
        MemberSuccessors waitingFor = this.getNodesThatBlock(node);
        Node.DependenciesState state = waitingFor.successorsComplete();
        if (state != null) {
            return state;
        }
        if (this.delegate.isReachableFromEntryPoint()) {
            return Node.DependenciesState.COMPLETE_AND_SUCCESSFUL;
        }
        if (this.delegate instanceof HasFinalizers) {
            return this.delegate.checkSuccessorsCompleteFor(node);
        }
        return Node.DependenciesState.COMPLETE_AND_CAN_SKIP;
    }

    private MemberSuccessors getNodesThatBlock(Node node) {
        if (this.isFinalizerNode(node)) {
            return new WaitForNodesToComplete(this.getFinalizedNodes());
        }
        if (FinalizerGroup.memberCanStartAtAnyTime(node)) {
            return DO_NOT_BLOCK;
        }
        return this.successors.getNodesThatBlock(node);
    }

    private Set<Node> getDependenciesThatAreMembers(Set<Node> blockedFinalizedMembers) {
        HashSet<Node> dependenciesThatAreMembers = new HashSet<Node>(this.members.size());
        HashSet seen = new HashSet(1024);
        ArrayDeque queue = new ArrayDeque(1024);
        for (Node fromNode : blockedFinalizedMembers) {
            queue.add((Object)fromNode);
            while (!queue.isEmpty()) {
                Node toNode = (Node)queue.removeFirst();
                if (this.members.contains(toNode) && !blockedFinalizedMembers.contains(toNode)) {
                    dependenciesThatAreMembers.add(toNode);
                }
                toNode.visitHardSuccessors(node -> {
                    if (seen.add(node)) {
                        queue.add(node);
                    }
                });
            }
        }
        return dependenciesThatAreMembers;
    }

    private boolean hasACycle(Node finalized, SetMultimap<FinalizerGroup, FinalizerGroup> reachableGroups) {
        if (!(finalized.getGroup() instanceof HasFinalizers) || finalized.getGroup().isReachableFromEntryPoint()) {
            return false;
        }
        HasFinalizers groups = (HasFinalizers)finalized.getGroup();
        for (FinalizerGroup finalizerGroup : groups.getFinalizerGroups()) {
            if (!this.reachableGroups(finalizerGroup, reachableGroups).contains(this)) continue;
            return true;
        }
        return false;
    }

    private Set<FinalizerGroup> reachableGroups(FinalizerGroup fromGroup, SetMultimap<FinalizerGroup, FinalizerGroup> reachableGroups) {
        if (!reachableGroups.containsKey((Object)fromGroup)) {
            HashSet<Node> seen = new HashSet<Node>();
            ArrayList<Node> queue = new ArrayList<Node>(fromGroup.getFinalizedNodes());
            while (!queue.isEmpty()) {
                Node node = (Node)queue.remove(0);
                if (!seen.add(node) || node.getGroup().isReachableFromEntryPoint()) continue;
                if (node.getGroup() instanceof HasFinalizers) {
                    HasFinalizers groups = (HasFinalizers)node.getGroup();
                    for (FinalizerGroup finalizerGroup : groups.getFinalizerGroups()) {
                        reachableGroups.put((Object)fromGroup, (Object)finalizerGroup);
                        queue.addAll(finalizerGroup.getFinalizedNodes());
                    }
                }
                Iterables.addAll(queue, node.getHardSuccessors());
            }
        }
        return reachableGroups.get((Object)fromGroup);
    }

    private boolean isFinalizerNode(Node node) {
        return node == this.node;
    }

    private static class WaitForFinalizedNodesToBecomeActive
    implements MemberSuccessors {
        private final Set<Node> nodes;

        public WaitForFinalizedNodesToBecomeActive(Set<Node> nodes) {
            this.nodes = nodes;
        }

        @Override
        @Nullable
        public Node.DependenciesState successorsComplete() {
            for (Node node : this.nodes) {
                for (FinalizerGroup finalizerGroup : ((HasFinalizers)node.getGroup()).getFinalizerGroups()) {
                    if (!finalizerGroup.finalizedNodeHasStarted) continue;
                    return Node.DependenciesState.COMPLETE_AND_SUCCESSFUL;
                }
            }
            return Node.DependenciesState.NOT_COMPLETE;
        }
    }

    private static class WaitForNodesToComplete
    implements MemberSuccessors {
        private final Set<Node> nodes;

        public WaitForNodesToComplete(Set<Node> nodes) {
            this.nodes = nodes;
        }

        @Override
        @Nullable
        public Node.DependenciesState successorsComplete() {
            boolean isAnyExecuted = false;
            for (Node node : this.nodes) {
                if (!node.isComplete()) {
                    return Node.DependenciesState.NOT_COMPLETE;
                }
                isAnyExecuted |= node.isExecuted();
            }
            if (isAnyExecuted) {
                return Node.DependenciesState.COMPLETE_AND_SUCCESSFUL;
            }
            return null;
        }
    }

    private static class DoNotBlock
    implements MemberSuccessors {
        private DoNotBlock() {
        }

        @Override
        public Node.DependenciesState successorsComplete() {
            return Node.DependenciesState.COMPLETE_AND_SUCCESSFUL;
        }
    }

    private static interface MemberSuccessors {
        @Nullable
        public Node.DependenciesState successorsComplete();
    }

    private static interface ElementSuccessors {
        public MemberSuccessors getNodesThatBlock(Node var1);
    }
}

