/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.runtime.structure;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.runtime.structure.Java16SealedRecordLoader;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectClassUtilKt;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaAnnotationOwner;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaClass;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaClassifierType;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaConstructor;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaElement;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaField;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaMethod;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaModifierListOwner;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaRecordComponent;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaRecordComponent;
import org.jetbrains.kotlin.load.java.structure.LightClassOriginKind;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0011\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010@\u001a\u00020\u001b2\b\u0010A\u001a\u0004\u0018\u00010BH\u0096\u0002J\u0012\u0010C\u001a\u0004\u0018\u00010\u00002\u0006\u0010-\u001a\u00020\u0018H\u0016J\b\u0010D\u001a\u00020\u001bH\u0016J\b\u0010E\u001a\u00020*H\u0016J\u0010\u0010F\u001a\u00020\u001b2\u0006\u0010G\u001a\u00020HH\u0002J\b\u0010I\u001a\u00020JH\u0016R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\fR\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001cR\u0014\u0010 \u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001cR\u0014\u0010!\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001cR\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\u0004\u0018\u00010#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\fR\u0014\u0010)\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0016\u00100\u001a\u0004\u0018\u00010\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u001a\u00103\u001a\b\u0012\u0004\u0012\u000205048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u001a\u00108\u001a\b\u0012\u0004\u0012\u000209048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u00107R\u001a\u0010;\u001a\b\u0012\u0004\u0012\u000205048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u00107R\u001a\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010\f\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaClass;", "Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaElement;", "Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaAnnotationOwner;", "Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaModifierListOwner;", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "klass", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "constructors", "", "Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaConstructor;", "getConstructors", "()Ljava/util/List;", "element", "getElement", "()Ljava/lang/Class;", "fields", "Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaField;", "getFields", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "innerClassNames", "Lorg/jetbrains/kotlin/name/Name;", "getInnerClassNames", "isAnnotationType", "", "()Z", "isEnum", "isFromSource", "isInterface", "isRecord", "isSealed", "lightClassOriginKind", "Lorg/jetbrains/kotlin/load/java/structure/LightClassOriginKind;", "getLightClassOriginKind", "()Lorg/jetbrains/kotlin/load/java/structure/LightClassOriginKind;", "methods", "Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaMethod;", "getMethods", "modifiers", "", "getModifiers", "()I", "name", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "outerClass", "getOuterClass", "()Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaClass;", "permittedTypes", "", "Lorg/jetbrains/kotlin/load/java/structure/JavaClassifierType;", "getPermittedTypes", "()Ljava/util/Collection;", "recordComponents", "Lorg/jetbrains/kotlin/load/java/structure/JavaRecordComponent;", "getRecordComponents", "supertypes", "getSupertypes", "typeParameters", "Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaTypeParameter;", "getTypeParameters", "equals", "other", "", "findInnerClass", "hasDefaultConstructor", "hashCode", "isEnumValuesOrValueOf", "method", "Ljava/lang/reflect/Method;", "toString", "", "descriptors.runtime"})
@SourceDebugExtension(value={"SMAP\nReflectJavaClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReflectJavaClass.kt\norg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaClass\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,208:1\n179#2,2:209\n1#3:211\n1549#4:212\n1620#4,3:213\n11065#5:216\n11400#5,3:217\n11065#5:221\n11400#5,3:222\n11065#5:225\n11400#5,3:226\n26#6:220\n*S KotlinDebug\n*F\n+ 1 ReflectJavaClass.kt\norg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaClass\n*L\n51#1:209,2\n64#1:212\n64#1:213,3\n118#1:216\n118#1:217,3\n131#1:221\n131#1:222,3\n138#1:225\n138#1:226,3\n131#1:220\n*E\n"})
public final class ReflectJavaClass
extends ReflectJavaElement
implements ReflectJavaAnnotationOwner,
ReflectJavaModifierListOwner,
JavaClass {
    @NotNull
    private final Class<?> klass;

    public ReflectJavaClass(@NotNull Class<?> klass) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        this.klass = klass;
    }

    @Override
    @NotNull
    public Class<?> getElement() {
        return this.klass;
    }

    @Override
    public int getModifiers() {
        return this.klass.getModifiers();
    }

    @Override
    public boolean isFromSource() {
        return false;
    }

    @NotNull
    public List<Name> getInnerClassNames() {
        Class<?>[] classArray = this.klass.getDeclaredClasses();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"getDeclaredClasses(...)");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])classArray), (Function1)innerClassNames.1.INSTANCE), (Function1)innerClassNames.2.INSTANCE));
    }

    @Override
    @Nullable
    public ReflectJavaClass findInnerClass(@NotNull Name name2) {
        ReflectJavaClass reflectJavaClass;
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Class<?>[] classArray = this.klass.getDeclaredClasses();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getDeclaredClasses(...)");
            Sequence $this$firstOrNull$iv = ArraysKt.asSequence((Object[])classArray);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Class it = (Class)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSimpleName(), (Object)name2.asString())) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        Class clazz = v1;
        if (clazz != null) {
            Class p0 = clazz;
            boolean bl = false;
            reflectJavaClass = new ReflectJavaClass(p0);
        } else {
            reflectJavaClass = null;
        }
        return reflectJavaClass;
    }

    @Override
    @NotNull
    public FqName getFqName() {
        FqName fqName2 = ReflectClassUtilKt.getClassId(this.klass).asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"asSingleFqName(...)");
        return fqName2;
    }

    @Override
    @Nullable
    public ReflectJavaClass getOuterClass() {
        ReflectJavaClass reflectJavaClass;
        Class<?> clazz = this.klass.getDeclaringClass();
        if (clazz != null) {
            Class<?> p0 = clazz;
            boolean bl = false;
            reflectJavaClass = new ReflectJavaClass(p0);
        } else {
            reflectJavaClass = null;
        }
        return reflectJavaClass;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<JavaClassifierType> getSupertypes() {
        void $this$mapTo$iv$iv;
        if (Intrinsics.areEqual(this.klass, Object.class)) {
            return CollectionsKt.emptyList();
        }
        SpreadBuilder spreadBuilder2 = new SpreadBuilder(2);
        Type type2 = this.klass.getGenericSuperclass();
        if (type2 == null) {
            type2 = (Type)((Object)Object.class);
        }
        spreadBuilder2.add((Object)type2);
        Type[] typeArray = this.klass.getGenericInterfaces();
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getGenericInterfaces(...)");
        spreadBuilder2.addSpread((Object)typeArray);
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])spreadBuilder2.toArray((Object[])new Type[spreadBuilder2.size()]));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Type type3 = (Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ReflectJavaClassifierType((Type)p0));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<ReflectJavaMethod> getMethods() {
        Method[] methodArray = this.klass.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(...)");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])methodArray), (Function1)((Function1)new Function1<Method, Boolean>(this){
            final /* synthetic */ ReflectJavaClass this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Method method) {
                boolean bl;
                if (method.isSynthetic()) {
                    bl = false;
                } else if (this.this$0.isEnum()) {
                    Intrinsics.checkNotNull((Object)method);
                    bl = !ReflectJavaClass.access$isEnumValuesOrValueOf(this.this$0, method);
                } else {
                    bl = true;
                }
                return bl;
            }
        })), (Function1)methods.2.INSTANCE));
    }

    private final boolean isEnumValuesOrValueOf(Method method) {
        boolean bl;
        String string2 = method.getName();
        if (Intrinsics.areEqual((Object)string2, (Object)"values")) {
            Class<?>[] classArray = method.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
            bl = ((Object[])classArray).length == 0;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"valueOf")) {
            Object[] objectArray = new Class[]{String.class};
            bl = Arrays.equals(method.getParameterTypes(), objectArray);
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public List<ReflectJavaField> getFields() {
        Field[] fieldArray = this.klass.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])fieldArray), (Function1)fields.1.INSTANCE), (Function1)fields.2.INSTANCE));
    }

    @NotNull
    public List<ReflectJavaConstructor> getConstructors() {
        Constructor<?>[] constructorArray = this.klass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getDeclaredConstructors(...)");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])constructorArray), (Function1)constructors.1.INSTANCE), (Function1)constructors.2.INSTANCE));
    }

    @Override
    public boolean hasDefaultConstructor() {
        return false;
    }

    @Override
    @Nullable
    public LightClassOriginKind getLightClassOriginKind() {
        return null;
    }

    @Override
    @NotNull
    public Name getName() {
        Name name2;
        if (this.klass.isAnonymousClass()) {
            String string2 = this.klass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            Name name3 = Name.identifier(StringsKt.substringAfterLast$default((String)string2, (String)".", null, (int)2, null));
            Intrinsics.checkNotNull((Object)name3);
            name2 = name3;
        } else {
            Name name4 = Name.identifier(this.klass.getSimpleName());
            Intrinsics.checkNotNull((Object)name4);
            name2 = name4;
        }
        return name2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ReflectJavaTypeParameter> getTypeParameters() {
        void $this$mapTo$iv$iv;
        TypeVariable<Class<?>>[] typeVariableArray = this.klass.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(typeVariableArray, (String)"getTypeParameters(...)");
        Object[] $this$map$iv = typeVariableArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TypeVariable typeVariable = (TypeVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ReflectJavaTypeParameter((TypeVariable<?>)p0));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean isInterface() {
        return this.klass.isInterface();
    }

    @Override
    public boolean isAnnotationType() {
        return this.klass.isAnnotation();
    }

    @Override
    public boolean isEnum() {
        return this.klass.isEnum();
    }

    @Override
    public boolean isRecord() {
        Boolean bl = Java16SealedRecordLoader.INSTANCE.loadIsRecord(this.klass);
        return bl != null ? bl : false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<JavaRecordComponent> getRecordComponents() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = Java16SealedRecordLoader.INSTANCE.loadGetRecordComponents(this.klass);
        if (objectArray == null) {
            boolean $i$f$emptyArray = false;
            objectArray = new Object[]{};
        }
        Object[] $this$map$iv = objectArray;
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void p0;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ReflectJavaRecordComponent(p0));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean isSealed() {
        Boolean bl = Java16SealedRecordLoader.INSTANCE.loadIsSealed(this.klass);
        return bl != null ? bl : false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<JavaClassifierType> getPermittedTypes() {
        Collection collection;
        Class<?>[] classArray = Java16SealedRecordLoader.INSTANCE.loadGetPermittedSubclasses(this.klass);
        if (classArray != null) {
            void $this$mapTo$iv$iv;
            Class<?>[] $this$map$iv = classArray;
            boolean $i$f$map = false;
            Class<?>[] classArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                Type type2 = (Type)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(new ReflectJavaClassifierType((Type)p0));
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ReflectJavaClass && Intrinsics.areEqual(this.klass, ((ReflectJavaClass)other).klass);
    }

    public int hashCode() {
        return this.klass.hashCode();
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + ": " + this.klass;
    }

    public static final /* synthetic */ boolean access$isEnumValuesOrValueOf(ReflectJavaClass $this, Method method) {
        return $this.isEnumValuesOrValueOf(method);
    }
}

