; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -relocation-model=static < %s \
; RUN:   | FileCheck %s --check-prefix=RV32-STATIC
; RUN: llc -mtriple=riscv32 -relocation-model=pic < %s \
; RUN:   | FileCheck %s --check-prefix=RV32-PIC
; RUN: llc -mtriple=riscv64 -relocation-model=static < %s \
; RUN:   | FileCheck %s --check-prefix=RV64-STATIC
; RUN: llc -mtriple=riscv64 -relocation-model=pic < %s \
; RUN:   | FileCheck %s --check-prefix=RV64-PIC

@preemptable_var = dso_preemptable global i32 42
define ptr @get_preemptable_var() nounwind {
; RV32-STATIC-LABEL: get_preemptable_var:
; RV32-STATIC:       # %bb.0:
; RV32-STATIC-NEXT:    lui a0, %hi(preemptable_var)
; RV32-STATIC-NEXT:    addi a0, a0, %lo(preemptable_var)
; RV32-STATIC-NEXT:    ret
;
; RV32-PIC-LABEL: get_preemptable_var:
; RV32-PIC:       # %bb.0:
; RV32-PIC-NEXT:  .Lpcrel_hi0:
; RV32-PIC-NEXT:    auipc a0, %got_pcrel_hi(preemptable_var)
; RV32-PIC-NEXT:    lw a0, %pcrel_lo(.Lpcrel_hi0)(a0)
; RV32-PIC-NEXT:    ret
;
; RV64-STATIC-LABEL: get_preemptable_var:
; RV64-STATIC:       # %bb.0:
; RV64-STATIC-NEXT:    lui a0, %hi(preemptable_var)
; RV64-STATIC-NEXT:    addi a0, a0, %lo(preemptable_var)
; RV64-STATIC-NEXT:    ret
;
; RV64-PIC-LABEL: get_preemptable_var:
; RV64-PIC:       # %bb.0:
; RV64-PIC-NEXT:  .Lpcrel_hi0:
; RV64-PIC-NEXT:    auipc a0, %got_pcrel_hi(preemptable_var)
; RV64-PIC-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi0)(a0)
; RV64-PIC-NEXT:    ret
  ret ptr @preemptable_var
}

@dsolocal_var = dso_local global i32 42
define ptr @get_dsolocal_var() nounwind {
; RV32-STATIC-LABEL: get_dsolocal_var:
; RV32-STATIC:       # %bb.0:
; RV32-STATIC-NEXT:    lui a0, %hi(dsolocal_var)
; RV32-STATIC-NEXT:    addi a0, a0, %lo(dsolocal_var)
; RV32-STATIC-NEXT:    ret
;
; RV32-PIC-LABEL: get_dsolocal_var:
; RV32-PIC:       # %bb.0:
; RV32-PIC-NEXT:  .Lpcrel_hi1:
; RV32-PIC-NEXT:    auipc a0, %pcrel_hi(.Ldsolocal_var$local)
; RV32-PIC-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi1)
; RV32-PIC-NEXT:    ret
;
; RV64-STATIC-LABEL: get_dsolocal_var:
; RV64-STATIC:       # %bb.0:
; RV64-STATIC-NEXT:    lui a0, %hi(dsolocal_var)
; RV64-STATIC-NEXT:    addi a0, a0, %lo(dsolocal_var)
; RV64-STATIC-NEXT:    ret
;
; RV64-PIC-LABEL: get_dsolocal_var:
; RV64-PIC:       # %bb.0:
; RV64-PIC-NEXT:  .Lpcrel_hi1:
; RV64-PIC-NEXT:    auipc a0, %pcrel_hi(.Ldsolocal_var$local)
; RV64-PIC-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi1)
; RV64-PIC-NEXT:    ret
  ret ptr @dsolocal_var
}

@weak_dsolocal_var = weak dso_local global i32 42
define ptr @get_weak_dsolocal_var() nounwind {
; RV32-STATIC-LABEL: get_weak_dsolocal_var:
; RV32-STATIC:       # %bb.0:
; RV32-STATIC-NEXT:    lui a0, %hi(weak_dsolocal_var)
; RV32-STATIC-NEXT:    addi a0, a0, %lo(weak_dsolocal_var)
; RV32-STATIC-NEXT:    ret
;
; RV32-PIC-LABEL: get_weak_dsolocal_var:
; RV32-PIC:       # %bb.0:
; RV32-PIC-NEXT:  .Lpcrel_hi2:
; RV32-PIC-NEXT:    auipc a0, %pcrel_hi(weak_dsolocal_var)
; RV32-PIC-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi2)
; RV32-PIC-NEXT:    ret
;
; RV64-STATIC-LABEL: get_weak_dsolocal_var:
; RV64-STATIC:       # %bb.0:
; RV64-STATIC-NEXT:    lui a0, %hi(weak_dsolocal_var)
; RV64-STATIC-NEXT:    addi a0, a0, %lo(weak_dsolocal_var)
; RV64-STATIC-NEXT:    ret
;
; RV64-PIC-LABEL: get_weak_dsolocal_var:
; RV64-PIC:       # %bb.0:
; RV64-PIC-NEXT:  .Lpcrel_hi2:
; RV64-PIC-NEXT:    auipc a0, %pcrel_hi(weak_dsolocal_var)
; RV64-PIC-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi2)
; RV64-PIC-NEXT:    ret
  ret ptr @weak_dsolocal_var
}

@hidden_var = hidden global i32 42
define ptr @get_hidden_var() nounwind {
; RV32-STATIC-LABEL: get_hidden_var:
; RV32-STATIC:       # %bb.0:
; RV32-STATIC-NEXT:    lui a0, %hi(hidden_var)
; RV32-STATIC-NEXT:    addi a0, a0, %lo(hidden_var)
; RV32-STATIC-NEXT:    ret
;
; RV32-PIC-LABEL: get_hidden_var:
; RV32-PIC:       # %bb.0:
; RV32-PIC-NEXT:  .Lpcrel_hi3:
; RV32-PIC-NEXT:    auipc a0, %pcrel_hi(hidden_var)
; RV32-PIC-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi3)
; RV32-PIC-NEXT:    ret
;
; RV64-STATIC-LABEL: get_hidden_var:
; RV64-STATIC:       # %bb.0:
; RV64-STATIC-NEXT:    lui a0, %hi(hidden_var)
; RV64-STATIC-NEXT:    addi a0, a0, %lo(hidden_var)
; RV64-STATIC-NEXT:    ret
;
; RV64-PIC-LABEL: get_hidden_var:
; RV64-PIC:       # %bb.0:
; RV64-PIC-NEXT:  .Lpcrel_hi3:
; RV64-PIC-NEXT:    auipc a0, %pcrel_hi(hidden_var)
; RV64-PIC-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi3)
; RV64-PIC-NEXT:    ret
  ret ptr @hidden_var
}

@protected_var = protected global i32 42
define ptr @get_protected_var() nounwind {
; RV32-STATIC-LABEL: get_protected_var:
; RV32-STATIC:       # %bb.0:
; RV32-STATIC-NEXT:    lui a0, %hi(protected_var)
; RV32-STATIC-NEXT:    addi a0, a0, %lo(protected_var)
; RV32-STATIC-NEXT:    ret
;
; RV32-PIC-LABEL: get_protected_var:
; RV32-PIC:       # %bb.0:
; RV32-PIC-NEXT:  .Lpcrel_hi4:
; RV32-PIC-NEXT:    auipc a0, %pcrel_hi(protected_var)
; RV32-PIC-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi4)
; RV32-PIC-NEXT:    ret
;
; RV64-STATIC-LABEL: get_protected_var:
; RV64-STATIC:       # %bb.0:
; RV64-STATIC-NEXT:    lui a0, %hi(protected_var)
; RV64-STATIC-NEXT:    addi a0, a0, %lo(protected_var)
; RV64-STATIC-NEXT:    ret
;
; RV64-PIC-LABEL: get_protected_var:
; RV64-PIC:       # %bb.0:
; RV64-PIC-NEXT:  .Lpcrel_hi4:
; RV64-PIC-NEXT:    auipc a0, %pcrel_hi(protected_var)
; RV64-PIC-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi4)
; RV64-PIC-NEXT:    ret
  ret ptr @protected_var
}

define dso_preemptable ptr @preemptable_func() nounwind {
; RV32-STATIC-LABEL: preemptable_func:
; RV32-STATIC:       # %bb.0:
; RV32-STATIC-NEXT:    lui a0, %hi(preemptable_func)
; RV32-STATIC-NEXT:    addi a0, a0, %lo(preemptable_func)
; RV32-STATIC-NEXT:    ret
;
; RV32-PIC-LABEL: preemptable_func:
; RV32-PIC:       # %bb.0:
; RV32-PIC-NEXT:  .Lpcrel_hi5:
; RV32-PIC-NEXT:    auipc a0, %got_pcrel_hi(preemptable_func)
; RV32-PIC-NEXT:    lw a0, %pcrel_lo(.Lpcrel_hi5)(a0)
; RV32-PIC-NEXT:    ret
;
; RV64-STATIC-LABEL: preemptable_func:
; RV64-STATIC:       # %bb.0:
; RV64-STATIC-NEXT:    lui a0, %hi(preemptable_func)
; RV64-STATIC-NEXT:    addi a0, a0, %lo(preemptable_func)
; RV64-STATIC-NEXT:    ret
;
; RV64-PIC-LABEL: preemptable_func:
; RV64-PIC:       # %bb.0:
; RV64-PIC-NEXT:  .Lpcrel_hi5:
; RV64-PIC-NEXT:    auipc a0, %got_pcrel_hi(preemptable_func)
; RV64-PIC-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi5)(a0)
; RV64-PIC-NEXT:    ret
  ret ptr @preemptable_func
}

define dso_local ptr @dsolocal_func() nounwind {
; RV32-STATIC-LABEL: dsolocal_func:
; RV32-STATIC:       # %bb.0:
; RV32-STATIC-NEXT:    lui a0, %hi(dsolocal_func)
; RV32-STATIC-NEXT:    addi a0, a0, %lo(dsolocal_func)
; RV32-STATIC-NEXT:    ret
;
; RV32-PIC-LABEL: dsolocal_func:
; RV32-PIC:       # %bb.0:
; RV32-PIC-NEXT:  .Lpcrel_hi6:
; RV32-PIC-NEXT:    auipc a0, %pcrel_hi(.Ldsolocal_func$local)
; RV32-PIC-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi6)
; RV32-PIC-NEXT:    ret
;
; RV64-STATIC-LABEL: dsolocal_func:
; RV64-STATIC:       # %bb.0:
; RV64-STATIC-NEXT:    lui a0, %hi(dsolocal_func)
; RV64-STATIC-NEXT:    addi a0, a0, %lo(dsolocal_func)
; RV64-STATIC-NEXT:    ret
;
; RV64-PIC-LABEL: dsolocal_func:
; RV64-PIC:       # %bb.0:
; RV64-PIC-NEXT:  .Lpcrel_hi6:
; RV64-PIC-NEXT:    auipc a0, %pcrel_hi(.Ldsolocal_func$local)
; RV64-PIC-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi6)
; RV64-PIC-NEXT:    ret
  ret ptr @dsolocal_func
}

define weak dso_local ptr @weak_dsolocal_func() nounwind {
; RV32-STATIC-LABEL: weak_dsolocal_func:
; RV32-STATIC:       # %bb.0:
; RV32-STATIC-NEXT:    lui a0, %hi(weak_dsolocal_func)
; RV32-STATIC-NEXT:    addi a0, a0, %lo(weak_dsolocal_func)
; RV32-STATIC-NEXT:    ret
;
; RV32-PIC-LABEL: weak_dsolocal_func:
; RV32-PIC:       # %bb.0:
; RV32-PIC-NEXT:  .Lpcrel_hi7:
; RV32-PIC-NEXT:    auipc a0, %pcrel_hi(weak_dsolocal_func)
; RV32-PIC-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi7)
; RV32-PIC-NEXT:    ret
;
; RV64-STATIC-LABEL: weak_dsolocal_func:
; RV64-STATIC:       # %bb.0:
; RV64-STATIC-NEXT:    lui a0, %hi(weak_dsolocal_func)
; RV64-STATIC-NEXT:    addi a0, a0, %lo(weak_dsolocal_func)
; RV64-STATIC-NEXT:    ret
;
; RV64-PIC-LABEL: weak_dsolocal_func:
; RV64-PIC:       # %bb.0:
; RV64-PIC-NEXT:  .Lpcrel_hi7:
; RV64-PIC-NEXT:    auipc a0, %pcrel_hi(weak_dsolocal_func)
; RV64-PIC-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi7)
; RV64-PIC-NEXT:    ret
  ret ptr @weak_dsolocal_func
}

;; call .Ldsolocal_func$local either resolves to a constant at assembly time
;; or produces a relocation referencing a non-preemptible local symbol.
define dso_local void @call_dsolocal_func() nounwind {
; RV32-STATIC-LABEL: call_dsolocal_func:
; RV32-STATIC:       # %bb.0:
; RV32-STATIC-NEXT:    addi sp, sp, -16
; RV32-STATIC-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32-STATIC-NEXT:    call dsolocal_func
; RV32-STATIC-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32-STATIC-NEXT:    addi sp, sp, 16
; RV32-STATIC-NEXT:    ret
;
; RV32-PIC-LABEL: call_dsolocal_func:
; RV32-PIC:       # %bb.0:
; RV32-PIC-NEXT:    addi sp, sp, -16
; RV32-PIC-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32-PIC-NEXT:    call .Ldsolocal_func$local
; RV32-PIC-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32-PIC-NEXT:    addi sp, sp, 16
; RV32-PIC-NEXT:    ret
;
; RV64-STATIC-LABEL: call_dsolocal_func:
; RV64-STATIC:       # %bb.0:
; RV64-STATIC-NEXT:    addi sp, sp, -16
; RV64-STATIC-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64-STATIC-NEXT:    call dsolocal_func
; RV64-STATIC-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64-STATIC-NEXT:    addi sp, sp, 16
; RV64-STATIC-NEXT:    ret
;
; RV64-PIC-LABEL: call_dsolocal_func:
; RV64-PIC:       # %bb.0:
; RV64-PIC-NEXT:    addi sp, sp, -16
; RV64-PIC-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64-PIC-NEXT:    call .Ldsolocal_func$local
; RV64-PIC-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64-PIC-NEXT:    addi sp, sp, 16
; RV64-PIC-NEXT:    ret
  call ptr @dsolocal_func()
  ret void
}
