%feature("docstring") OT::TruncatedOverMesh
"Truncated distribution over a mesh.

.. warning::
    This class is experimental and likely to be modified in future releases.
    To use it, import the ``openturns.experimental`` submodule.

Parameters
----------
dist : :class:`~openturns.Distribution`
    Distribution to truncate
mesh : :class:`~openturns.Mesh`
    Mesh defining the domain of the distribution.

See also
--------
openturns.UniformOverMesh

Notes
-----
Its probability density function is defined as:

.. math::

    f_X(x) = \\frac{1}{|\\cD|}, \\quad x \\in \\cD

with :math:`\\cD\\subset\\Rset^n` a mesh of dimension :math:`n`.

Examples
--------
Create a distribution:

>>> import openturns as ot
>>> import openturns.experimental as otexp
>>> f = ot.SymbolicFunction(['x', 'y'], ['sin(x) * sin(y)'])
>>> levelSet = ot.LevelSet(f, ot.Less(), 0.2)
>>> box = ot.Interval([-5.0] * 2, [5.0] * 2)
>>> mesh = ot.LevelSetMesher([50]*2).build(levelSet, box, False)
>>> dist = ot.Normal([0] * 2, [2] * 2)
>>> distribution = otexp.TruncatedOverMesh(dist, mesh)

Draw a sample:

>>> sample = distribution.getSample(5)"

// ---------------------------------------------------------------------

%feature("docstring") OT::TruncatedOverMesh::getMesh
"Accessor to the distribution's mesh.

Returns
-------
mesh : :class:`~openturns.Mesh`
    Mesh."

// ---------------------------------------------------------------------

%feature("docstring") OT::TruncatedOverMesh::setMesh
"Accessor to the distribution's mesh.

Parameters
----------
mesh : :class:`~openturns.Mesh`
    Mesh."
