# grep

> Пошук шаблонів у файлах за допомогою регулярних виразів.
> Дивіться також: `regex`.
> Більше інформації: <https://www.gnu.org/software/grep/manual/grep.html>.

- Знайти шаблон у файлі:

`grep "{{шаблон_пошуку}}" {{шлях/до/файлу}}`

- Знайти точний рядок (відключає регулярні вирази):

`grep {{[-F|--fixed-strings]}} "{{точний_рядок}}" {{шлях/до/файлу}}`

- Знайти шаблон у всіх файлах рекурсивно в каталозі, виводячи номери рядків збігів, ігноруючи бінарні файли:

`grep {{[-rnI|--recursive --line-number --binary-files=without-match]}} "{{шаблон_пошуку}}" {{шлях/до/каталогу}}`

- Використовувати розширені регулярні вирази (підтримує `?`, `+`, `{}`, `()`, та `|`), у режимі без урахування регістру:

`grep {{[-Ei|--extended-regexp --ignore-case]}} "{{шаблон_пошуку}}" {{шлях/до/файлу}}`

- Вивести 3 рядки контексту навколо, до, або після кожного збігу:

`grep {{--context|--before-context|--after-context}} 3 "{{шаблон_пошуку}}" {{шлях/до/файлу}}`

- Вивести назву файлу та номер рядка для кожного збігу з кольоровим виводом:

`grep {{[-Hn|--with-filename --line-number]}} --color=always "{{шаблон_пошуку}}" {{шлях/до/файлу}}`

- Шукати рядкі, що відповідають шаблону, виводячи лише відповідний текст:

`grep {{[-o|--only-matching]}} "{{шаблон_пошуку}}" {{шлях/до/файлу}}`

- Знайти в `stdin` рядки, які не відповідають шаблону:

`cat {{шлях/до/файлу}} | grep {{[-v|--invert-match]}} "{{шаблон_пошуку}}"`
