// Copyright 2002 - 2008, 2010, 2011 National Technology Engineering
// Solutions of Sandia, LLC (NTESS). Under the terms of Contract
// DE-NA0003525 with NTESS, the U.S. Government retains certain rights
// in this software.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
// 
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
// 
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
// 
//     * Neither the name of NTESS nor the names of its contributors
//       may be used to endorse or promote products derived from this
//       software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

#include <gtest/gtest.h>
#include <stk_io/StkMeshIoBroker.hpp>

#include <stk_mesh/base/BulkData.hpp>

#ifndef STK_USE_SIMPLE_FIELDS

TEST(UnitTestNodeBucketsHaveValidTopology_legacy, testUnit)
{
  std::string generated_mesh("generated:2x3x4");

  stk::ParallelMachine comm = MPI_COMM_WORLD;
  stk::io::StkMeshIoBroker meshReader(comm);
  meshReader.add_mesh_database(generated_mesh, stk::io::READ_MESH);

  meshReader.create_input_mesh();
  meshReader.populate_bulk_data();

  const stk::mesh::BulkData& stkmesh = meshReader.bulk_data();

  const stk::mesh::BucketVector& nodeBuckets = stkmesh.buckets(stk::topology::NODE_RANK);

  for(size_t i=0; i<nodeBuckets.size(); ++i) {
    const stk::mesh::Bucket& bucket = *nodeBuckets[i];

    EXPECT_EQ(stk::topology::NODE, bucket.topology());
  }
}

#endif // STK_USE_SIMPLE_FIELDS

namespace simple_fields {

TEST(UnitTestNodeBucketsHaveValidTopology, testUnit)
{
  std::string generated_mesh("generated:2x3x4");

  stk::ParallelMachine comm = MPI_COMM_WORLD;
  stk::io::StkMeshIoBroker meshReader(comm);
  meshReader.use_simple_fields();
  meshReader.add_mesh_database(generated_mesh, stk::io::READ_MESH);

  meshReader.create_input_mesh();
  meshReader.populate_bulk_data();

  const stk::mesh::BulkData& stkmesh = meshReader.bulk_data();

  const stk::mesh::BucketVector& nodeBuckets = stkmesh.buckets(stk::topology::NODE_RANK);

  for(size_t i=0; i<nodeBuckets.size(); ++i) {
    const stk::mesh::Bucket& bucket = *nodeBuckets[i];

    EXPECT_EQ(stk::topology::NODE, bucket.topology());
  }
}

} // namespace simple_fields
