<!-- This file is generated by scripts/link-docs.mjs. Do not edit manually. -->
# Server-Side Configurations

[HTML](https://myriad-dreamin.github.io/tinymist/config/neovim.html) | Markdown

## `compileStatus`

In VSCode, enable compile status meaning that the extension will show the compilation status in the status bar. Since Neovim and Helix don’t have a such feature, it is disabled by default at the language server label.

- **Type**: `string`
- **Valid Values**:
  - `"enable"`
  - `"disable"`
- **Default**: `"enable"`

## `completion.postfix`

Whether to enable postfix code completion. For example, `[A].box|` will be completed to `box[A]|`. Hint: Restarting the editor is required to change this setting.

- **Type**: `boolean`
- **Default**: `true`

## `completion.postfixUfcs`

Whether to enable UFCS-style completion. For example, `[A].box|` will be completed to `box[A]|`. Hint: Restarting the editor is required to change this setting.

- **Type**: `boolean`
- **Default**: `true`

## `completion.postfixUfcsLeft`

Whether to enable left-variant UFCS-style completion. For example, `[A].table|` will be completed to `table(|)[A]`. Hint: Restarting the editor is required to change this setting.

- **Type**: `boolean`
- **Default**: `true`

## `completion.postfixUfcsRight`

Whether to enable right-variant UFCS-style completion. For example, `[A].table|` will be completed to `table([A], |)`. Hint: Restarting the editor is required to change this setting.

- **Type**: `boolean`
- **Default**: `true`

## `completion.symbol`

Whether to make symbol completion stepless. For example, `$ar|$` will be completed to `$arrow.r$`. Hint: Restarting the editor is required to change this setting.

- **Type**: `string`
- **Valid Values**:
  - `"step"` : Complete symbols step by step
  - `"stepless"` : Complete symbols steplessly
- **Default**: `"step"`

## `completion.triggerOnSnippetPlaceholders`

Whether to trigger completions on arguments (placeholders) of snippets. For example, `box` will be completed to `box(|)`, and server will request the editor (lsp client) to request completion after moving cursor to the placeholder in the snippet. Note: this has no effect if the editor doesn’t support `editor.action.triggerSuggest` or `tinymist.triggerSuggestAndParameterHints` command. Hint: Restarting the editor is required to change this setting.

- **Type**: `boolean`
- **Default**: `false`

## `exportPdf`

The extension can export PDFs of your Typst files. This setting controls whether this feature is enabled and how often it runs.

- **Type**: `string`
- **Valid Values**:
  - `"never"` : Never export PDFs, you will manually run typst.
  - `"onSave"` : Export PDFs when you save a file.
  - `"onType"` : Export PDFs as you type in a file.
  - `"onDocumentHasTitle"` : (Deprecated) Export PDFs when a document has a title (and save a file), which is useful to filter out template files.
- **Default**: `"never"`

## `exportTarget`

The target to export the document to. Defaults to `paged`. Note: you can still export PDF when it is set to `html`. This configuration only affects how the language server completes your code.

- **Type**: `string`
- **Valid Values**:
  - `"paged"` : The current export target is for PDF, PNG, and SVG export.
  - `"html"` : The current export target is for HTML export.
- **Default**: `"paged"`

## `fontPaths`

A list of file or directory path to fonts. Note: The configuration source in higher priority will **override** the configuration source in lower priority. The order of precedence is: Configuration `tinymist.fontPaths` \> Configuration `tinymist.typstExtraArgs.fontPaths` \> LSP’s CLI Argument `--font-path` \> The environment variable `TYPST_FONT_PATHS` (a path list separated by `;` (on Windows) or `:` (Otherwise)). Note: If the path to fonts is a relative path, it will be resolved based on the root directory. Note: In VSCode, you can use VSCode variables in the path, e.g. `${workspaceFolder}/fonts`.

- **Type**: array | null

## `formatterIndentSize`

Sets the indent size (using space) for the formatter.

- **Type**: `number`
- **Default**: `2`

## `formatterMode`

The extension can format Typst files using typstfmt or typstyle.

- **Type**: `string`
- **Valid Values**:
  - `"disable"` : Formatter is not activated.
  - `"typstyle"` : Use typstyle formatter.
  - `"typstfmt"` : Use typstfmt formatter.
- **Default**: `"typstyle"`

## `formatterPrintWidth`

Sets the print width for the formatter, which is a **soft limit** of characters per line. See [the definition of _Print Width_](https://prettier.io/docs/en/options.html#print-width). Note: this has lower priority than the formatter’s specific configurations.

- **Type**: `number`
- **Default**: `120`

## `formatterProseWrap`

Controls how the formatter handles prose line wrapping. If enabled, the formatter will insert hard line breaks at the specified print width. If disabled, the formatter keeps the original line breaks and spaces.

- **Type**: `boolean`
- **Default**: `false`

## `lint.enabled`

Enable or disable lint checks. Note: restarting the editor is required to change this setting.

- **Type**: `boolean`
- **Default**: `false`

## `lint.when`

Configure when to perform lint checks. Note: restarting the editor is required to change this setting.

- **Type**: `string`
- **Valid Values**:
  - `"onSave"` : Perform lint checks on save
  - `"onType"` : Perform lint checks on type
- **Default**: `"onSave"`

## `outputPath`

The path pattern to store Typst artifacts, you can use `$root` or `$dir` or `$name` to do magic configuration, e.g. `$dir/$name` (default) and `$root/target/$dir/$name`.

- **Type**: `string`
- **Default**: `""`

## `preview.background.args`

The arguments that the background preview server used for. It is only used when \`tinymist.preview.background\` is enabled. Check \`tinymist preview\` to see the allowed arguments.

- **Type**: `array`
- **Properties**:
  - `"type"`: 
    - **Type**: `string`
- **Default**: `[
    "--data-plane-host=127.0.0.1:23635",
    "--invert-colors=auto"
  ]`

## `preview.background.enabled`

This configuration is only used for the editors that doesn't support lsp well, e.g. helix and zed. When it is enabled, the preview server listens a specific tcp port in the background. You can discover the background previewers in the preview panel.

- **Type**: `boolean`
- **Default**: `false`

## `preview.browsing.args`

The arguments used by \`tinymist.startDefaultPreview\` command. Check \`tinymist preview\` to see the allowed arguments.

- **Type**: `array`
- **Properties**:
  - `"type"`: 
    - **Type**: `string`
- **Default**: `[
    "--data-plane-host=127.0.0.1:0",
    "--invert-colors=auto",
    "--open"
  ]`

## `preview.invertColors`

Invert colors of the preview (useful for dark themes without cost). Please note you could see the origin colors when you hover elements in the preview. It is also possible to specify strategy to each element kind by an object map in JSON format.

This configuration item can be one of following types:

- Invert colors of the preview.
  - **Type**: `string`
  - **Valid Values**:
    - `"never"` : Never
    - `"auto"` : Inferring from the browser settings
    - `"always"` : Always
- Invert colors of the preview in a more fine-grained way.
  - **Type**: `object`
  - **Properties**:
    - `"rest"`: Invert colors of the rest of the elements.
      - **Type**: `string`
      - **Valid Values**:
        - `"never"` : Never
        - `"auto"` : Inferring from the browser settings
        - `"always"` : Always
      - **Default**: `"never"`
    - `"image"`: Invert colors of the images.
      - **Type**: `string`
      - **Valid Values**:
        - `"never"` : Never
        - `"auto"` : Inferring from the browser settings
        - `"always"` : Always
      - **Default**: `"never"`
- **Default**: `"never"`

## `preview.partialRendering`

Only render visible part of the document. This can improve performance but still being experimental.

- **Type**: `boolean`
- **Default**: `true`

## `preview.refresh`

Refresh preview when the document is saved or when the document is changed

- **Type**: `string`
- **Valid Values**:
  - `"onSave"` : Refresh preview on save
  - `"onType"` : Refresh preview on type
- **Default**: `"onType"`

## `projectResolution`

This configuration specifies the way to resolved projects.

- **Type**: `string`
- **Valid Values**:
  - `"singleFile"` : Manage typst documents like what we did in Markdown. Each single file is an individual document and no project resolution is needed.
  - `"lockDatabase"` : Manage typst documents like what we did in Rust. For each workspace, tinymist tracks your preview and compilation history, and stores the information in a lock file. Tinymist will automatically selects the main file to use according to the lock file. This also allows other tools push preview and export tasks to language server by updating the lock file.
- **Default**: `"singleFile"`

## `rootPath`

Configure the root for absolute paths in typst. Note: for Neovim users, if it complains root not found, you must set `require("lspconfig")["tinymist"].setup { root_dir }` as well, see [tinymist#528](https://github.com/Myriad-Dreamin/tinymist/issues/528).

- **Type**: string | null

## `semanticTokens`

Enable or disable semantic tokens (LSP syntax highlighting)

- **Type**: `string`
- **Valid Values**:
  - `"enable"` : Use semantic tokens for syntax highlighting
  - `"disable"` : Do not use semantic tokens for syntax highlighting
- **Default**: `"enable"`

## `syntaxOnly`

Configure whether to enable syntax-only mode for the language server. In syntax-only mode, the language server will only provide syntax checking and basic code completion, but will not perform full document compilation or code analysis. This can be useful for improving performance on low-end devices or when working with large documents.

- **Type**: `string`
- **Valid Values**:
  - `"auto"` : Always disable syntax-only mode. The strategy may be changed in the future, for example, automatically enable syntax-only mode when the system is in power-saving mode.
  - `"onPowerSaving"` : Enable syntax-only mode when the system is in power-saving mode.
  - `"enable"` : Always enable syntax-only mode.
  - `"disable"` : Always disable syntax-only mode.
- **Default**: `"auto"`

## `systemFonts`

A flag that determines whether to load system fonts for Typst compiler, which is useful for ensuring reproducible compilation. If set to null or not set, the extension will use the default behavior of the Typst compiler. Note: You need to restart LSP to change this options.

- **Type**: `boolean`
- **Default**: `true`

## `typstExtraArgs`

You can pass any arguments as you like, and we will try to follow behaviors of the **same version** of typst-cli. Note: the arguments may be overridden by other settings. For example, `--font-path` will be overridden by `tinymist.fontPaths`.

- **Type**: `array`
- **Default**: `[]`
